/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.mdckms;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.components.mdckms.OwnershipObject;
import com.adventnet.wms.servercommon.components.mdckms.stats.MultiDCKeyMgmtStats;
import com.adventnet.wms.servercommon.components.net.WCPDispatcher;
import com.adventnet.wms.servercommon.components.net.WCPSessionManager;
import com.adventnet.wms.servercommon.components.net.servlet.WCPFuture;
import com.adventnet.wms.servercommon.components.net.servlet.WCPRequest;
import com.adventnet.wms.servercommon.components.net.servlet.WCPResponse;
import com.adventnet.wms.servercommon.components.net.servlet.WCPServletMapper;
import com.adventnet.wms.servercommon.dc.DC;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPManager {
    private static final Logger LOGGER = Logger.getLogger(WCPManager.class.getName());
    private static boolean isInitialized = false;
    private static final String WCP_MDC_KMS_REQ = "mdckmsreq";
    private static final String WCP_MDC_KMS_CONTEXT = "mdckms";

    protected static void initialize(Properties wcpProps) {
        if (isInitialized) {
            return;
        }
        try {
            WCPServletMapper.initialize(wcpProps);
            WCPDispatcher.initialize();
            WCPSessionManager.initialize();
            WCPDispatcher.createWCPConnPool(WCP_MDC_KMS_REQ, DC.getServertype(), DC.getServertype(), DC.getCluster(), WCP_MDC_KMS_CONTEXT, true);
            isInitialized = true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while initializing WCP ", e);
        }
    }

    public static OwnershipObject register(String key, Set<String> dcList) throws Exception {
        long startTime = System.currentTimeMillis();
        OwnershipObject ownershipObject = null;
        WCPRequest request = new WCPRequest("/registermdckey");
        request.setData(key);
        WCPFuture futureObj = WCPDispatcher.sendRequestToDR(WCP_MDC_KMS_REQ, request, null, key);
        WCPResponse wcpResponse = futureObj.get();
        if (wcpResponse != null && wcpResponse.getResponseData() != null) {
            ownershipObject = (OwnershipObject)HttpDataWraper.getObject((String)wcpResponse.getResponseData());
        }
        MultiDCKeyMgmtStats.addWCPRegisterRequest(key, DC.getDrDCId(), System.currentTimeMillis() - startTime);
        return ownershipObject;
    }
}

