/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.mdckms;

import com.adventnet.wms.servercommon.components.mdckms.OwnershipObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisManager {
    private static final Logger LOGGER = Logger.getLogger(RedisManager.class.getName());
    private static final int DB_NAME = 5;
    private static JedisPool jedisPool = null;
    private static final String SEQUENCE_ID = "SEQUENCEID";
    private static final String STATE_CHANGE_TIME = "STATECHANGETIME";
    private static final String APP_UUID = "APPUUID";
    private static final String STATE = "STATE";
    private static final String OWNER_DC = "OWNERDC";
    private static final String FOLLOWER_DC = "FOLLOWERDC";
    private static final String FOLLOWER_DC_DELIMITER = ",";

    protected static void initialize(Properties jedisProp) throws Exception {
        try {
            JedisPoolConfig jpc = new JedisPoolConfig();
            jedisPool = new JedisPool((GenericObjectPoolConfig)jpc, jedisProp.getProperty("clusterIP"), Integer.parseInt(jedisProp.getProperty("port")), Integer.parseInt(jedisProp.getProperty("timeout")), null, 5);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while initializing RedisConnection pool", e);
            throw e;
        }
    }

    protected static void reInitialize(Properties jedisProp) throws Exception {
        if (jedisPool != null) {
            jedisPool.destroy();
        }
        RedisManager.initialize(jedisProp);
    }

    protected static void add(String key, OwnershipObject ownershipObject) throws Exception {
        RedisManager.add(key, RedisManager.getMapValues(ownershipObject));
    }

    protected static void add(String key, Map<String, String> ownershipObject) throws Exception {
        jedisPool.getResource().hmset(key, ownershipObject);
    }

    protected static void remove(String key) throws Exception {
        jedisPool.getResource().del(key);
    }

    protected static OwnershipObject lookup(String key) throws Exception {
        Map mapValues = jedisPool.getResource().hgetAll(key);
        return RedisManager.convertMapToOwnershipObject(mapValues);
    }

    protected static OwnershipObject convertMapToOwnershipObject(Map<String, String> mapValues) {
        if (mapValues.size() == 0) {
            return null;
        }
        return new OwnershipObject(Long.parseLong(mapValues.get(SEQUENCE_ID)), Long.parseLong(mapValues.get(STATE_CHANGE_TIME)), Long.parseLong(mapValues.get(APP_UUID)), OwnershipObject.getOwnershipState(mapValues.get(STATE)), mapValues.get(OWNER_DC), RedisManager.getFollowerDC(mapValues.get(FOLLOWER_DC)));
    }

    protected static Map<String, String> getMapValues(OwnershipObject ownershipObject) {
        HashMap<String, String> mapValues = new HashMap<String, String>(6);
        mapValues.put(OWNER_DC, ownershipObject.getOwnerDC());
        mapValues.put(SEQUENCE_ID, String.valueOf(ownershipObject.getSequenceID()));
        mapValues.put(STATE_CHANGE_TIME, String.valueOf(ownershipObject.getStateChangeTime()));
        mapValues.put(APP_UUID, String.valueOf(ownershipObject.getStateChangeTime()));
        mapValues.put(STATE, ownershipObject.getState().name());
        if (ownershipObject.getFollowerDC() != null) {
            mapValues.put(FOLLOWER_DC, RedisManager.getFollowerDcAsString(ownershipObject.getFollowerDC()));
        }
        return mapValues;
    }

    private static Set<String> getFollowerDC(String followerDCList) {
        if (followerDCList == null || followerDCList.isEmpty()) {
            return null;
        }
        return Stream.of(FOLLOWER_DC_DELIMITER).collect(Collectors.toSet());
    }

    private static String getFollowerDcAsString(Set<String> followerDC) {
        return String.join((CharSequence)FOLLOWER_DC_DELIMITER, followerDC);
    }
}

