/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.mdckms;

import com.adventnet.wms.servercommon.components.mdckms.MultiDCKeyMgmtConfHandler;
import com.adventnet.wms.servercommon.components.mdckms.OwnershipObject;
import com.adventnet.wms.servercommon.components.mdckms.OwnershipState;
import com.adventnet.wms.servercommon.components.mdckms.RedisManager;
import com.adventnet.wms.servercommon.components.mdckms.WCPManager;
import com.adventnet.wms.servercommon.components.mdckms.stats.MultiDCKeyMgmtStats;
import com.adventnet.wms.servercommon.dc.DC;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class MultiDCKeyMgmtHandler {
    private static final Logger LOGGER = Logger.getLogger(MultiDCKeyMgmtHandler.class.getName());

    public static void initialize() throws Exception {
        MultiDCKeyMgmtConfHandler.initialize();
    }

    public static OwnershipObject register(String key) throws Exception {
        return MultiDCKeyMgmtHandler.register(key, null);
    }

    public static OwnershipObject register(String key, Set<String> dcList) throws Exception {
        OwnershipObject ownershipObject = RedisManager.lookup(key);
        if (ownershipObject == null) {
            ownershipObject = WCPManager.register(key, dcList);
            if (ownershipObject == null) {
                ownershipObject = MultiDCKeyMgmtHandler.createOwnershipObject();
            }
            RedisManager.add(key, ownershipObject);
        }
        return ownershipObject;
    }

    public static void forceRegisterAsOwner(String key) throws Exception {
        RedisManager.add(key, MultiDCKeyMgmtHandler.createOwnershipObject());
    }

    public static void forceRegister(String key, OwnershipObject ownershipObject) throws Exception {
        RedisManager.add(key, ownershipObject);
    }

    public static void forceRegister(String key, Map<String, String> ownershipObject) throws Exception {
        RedisManager.add(key, ownershipObject);
    }

    public static void remove(String key) throws Exception {
        RedisManager.remove(key);
    }

    public static OwnershipObject localLookup(String key) throws Exception {
        return RedisManager.lookup(key);
    }

    public static OwnershipObject getOwnerShipObject(Map<String, String> values) {
        return RedisManager.convertMapToOwnershipObject(values);
    }

    public static Map lookup(String key) throws Exception {
        long startTime = System.currentTimeMillis();
        OwnershipObject ownershipObject = RedisManager.lookup(key);
        if (ownershipObject == null) {
            return null;
        }
        MultiDCKeyMgmtStats.addLookupRequest(key, System.currentTimeMillis() - startTime);
        return RedisManager.getMapValues(ownershipObject);
    }

    private static OwnershipObject createOwnershipObject() {
        return new OwnershipObject(1L, System.currentTimeMillis(), 0L, OwnershipState.owner, DC.getDCId(), null);
    }
}

