/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.mdckms;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.components.mdckms.MultiDCKeyMgmtHandler;
import com.adventnet.wms.servercommon.components.mdckms.RedisManager;
import com.adventnet.wms.servercommon.components.mdckms.WCPManager;
import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MultiDCKeyMgmtConfHandler {
    private static final Logger LOGGER = Logger.getLogger(MultiDCKeyMgmtHandler.class.getName());
    private static String redisConfFile = System.getProperty("server.home") + File.separator + "conf" + File.separator + "mdc_kms_redis.properties";
    private static Properties redisConfProps = new Properties();
    private static Properties wcpProps = new Properties();
    public static final String REDIS_CLUSTERIP = "clusterIP";
    public static final String REDIS_PORT = "port";
    public static final String REDIS_TIMEOUT = "timeout";
    public static final String WCP_REGISTER_MDCKEY_SERVLET_NAME = "/registemdckey";
    private static final String WCP_REGISTER_MDCKEY_SERVLET_MAPPING = "com.adventnet.wms.servercommon.components.mdckms.servlet.RegisterMDCkey";

    protected static void initialize() throws Exception {
        MultiDCKeyMgmtConfHandler.loadWcpServletMapping();
        WCPManager.initialize(wcpProps);
        MultiDCKeyMgmtConfHandler.loadRedisPropsFile();
        RedisManager.initialize(redisConfProps);
    }

    private static void initializeRedis() throws Exception {
        RedisManager.reInitialize(redisConfProps);
    }

    public static void setProps(String props) {
        try {
            Hashtable propsMap = (Hashtable)HttpDataWraper.getObject((String)props);
            redisConfProps.setProperty(REDIS_CLUSTERIP, (String)propsMap.get(REDIS_CLUSTERIP));
            redisConfProps.setProperty(REDIS_PORT, (String)propsMap.get(REDIS_PORT));
            redisConfProps.setProperty(REDIS_TIMEOUT, (String)propsMap.get(REDIS_TIMEOUT));
            MultiDCKeyMgmtConfHandler.initializeRedis();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while setting props", e);
        }
    }

    private static void loadWcpServletMapping() {
        wcpProps.setProperty(WCP_REGISTER_MDCKEY_SERVLET_NAME, WCP_REGISTER_MDCKEY_SERVLET_MAPPING);
    }

    private static void loadRedisPropsFile() {
        FileInputStream fis = null;
        try {
            LOGGER.log(Level.INFO, "Loading Configs: {0}", redisConfFile);
            fis = new FileInputStream(redisConfFile);
            redisConfProps.load(fis);
        }
        catch (Exception exp) {
            LOGGER.log(Level.SEVERE, "Unable to load Conf File: " + redisConfFile, exp);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exp) {
                    LOGGER.log(Level.SEVERE, "Unable to close FIS while loading Redis Conf File: " + redisConfFile, exp);
                }
            }
        }
    }
}

