/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.logging;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import com.adventnet.wms.servercommon.cassandra.datastax.QueryExecutor;
import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.components.executor.WMSThreadPoolExecutor;
import com.adventnet.wms.servercommon.components.executor.WmsTask;
import com.adventnet.wms.servercommon.components.logging.WMSLogDatastaxManager;
import com.adventnet.wms.servercommon.components.logging.WmsLog;
import com.adventnet.wms.servercommon.components.logging.util.LoggingUtil;
import com.adventnet.wms.servercommon.components.queue.BufferedQueue;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.stats.influx.conf.StatsConf;
import com.adventnet.wms.servercommon.util.WMSUtil;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WmsLogger {
    private static int bqSize = 1000;
    private static int maxPoolSize = 5;
    private static int corePoolSize = 1;
    private static BufferedQueue bq = null;
    private static String trimmedString = null;
    private static boolean dispatchLogs = false;
    private static boolean isInitialised = false;
    private static DatastaxSession session = null;
    private static WMSThreadPoolExecutor wmsTPE = null;
    private static Hashtable<String, String> conf = new Hashtable();
    private static final String PRD = "prd";
    private static final String TIME = "time";
    private static final String REQ_ID = "reqid";
    private static final String STATUS = "status";
    private static final String MESSAGE = "message";
    private static final String SERVICE = "service";
    private static final String ENTITYID = "entityid";
    private static final String CATEGORY = "category";
    private static final String MILESTONE = "milestone";
    private static final String TIME_UUID = "time_uuid";
    private static final String ADDL_INFO_1 = "addlinfo1";
    private static final String ADDL_INFO_2 = "addlinfo2";
    private static final String ADDL_INFO_3 = "addlinfo3";
    private static final String SUBCATEGORY = "subcategory";
    private static final int SUCCESS = 1;
    private static final int FAILURE = 0;
    private static final Logger LOGGER = Logger.getLogger(WmsLogger.class.getName());

    public static void handleConfChanges(String props) {
        try {
            conf = (Hashtable)HttpDataWraper.getObject((String)props);
            boolean isEnabled = Boolean.parseBoolean(conf.get("isenabled"));
            if (isEnabled && !isInitialised) {
                bqSize = WMSUtil.getInteger(conf.get("bqsize"), bqSize);
                maxPoolSize = WMSUtil.getInteger(conf.get("maxpoolsize"), maxPoolSize);
                corePoolSize = WMSUtil.getInteger(conf.get("corepoolsize"), corePoolSize);
                WmsLogger.initialiseLogger();
            } else if (!isEnabled && isInitialised) {
                WmsLogger.stopWMSLoggerDispatcher();
            } else if (isEnabled && isInitialised) {
                corePoolSize = WMSUtil.getInteger(conf.get("corepoolsize"), corePoolSize);
                maxPoolSize = WMSUtil.getInteger(conf.get("maxpoolsize"), maxPoolSize);
                wmsTPE.setPoolSize(corePoolSize, maxPoolSize);
            }
        }
        catch (Exception e) {
            StatsDB.recordError(ComponentConstants.WMSLOGGER_ENUM.getModuleCode(), ComponentConstants.WMSLOGGER_ENUM.WMSLOGGER_NOT_INITIALIZED.getErrorCode(), 1L);
            LOGGER.log(Level.SEVERE, "WMSLOG --> Failed to initialize wmslogger, props:" + props, e);
        }
    }

    private static void initialiseLogger() {
        block5: {
            try {
                if (session == null) {
                    WMSLogDatastaxManager.initialise();
                }
                if ((session = WMSLogDatastaxManager.getDefaultSession()) != null) {
                    bq = new BufferedQueue(ServerUtil.dataHome + "wmslogger", "WMSLogger", bqSize, false);
                    wmsTPE = new WMSThreadPoolExecutor("WMSLogger/WMSLogger", corePoolSize, maxPoolSize, 5L, TimeUnit.SECONDS, bq, new WMSLogHandler());
                    WmsLogger.startWMSLoggerDispatcher();
                    isInitialised = true;
                }
            }
            catch (Exception e) {
                StatsDB.recordError(ComponentConstants.WMSLOGGER_ENUM.getModuleCode(), ComponentConstants.WMSLOGGER_ENUM.WMSLOGGER_NOT_INITIALIZED.getErrorCode(), 1L);
                LOGGER.log(Level.SEVERE, "WMSLOG --> Error while initialising conf :" + conf, e);
                if (wmsTPE != null) {
                    wmsTPE.shutdown();
                }
                if (bq == null) break block5;
                bq.close();
            }
        }
    }

    private static void startWMSLoggerDispatcher() {
        wmsTPE.start();
        dispatchLogs = true;
    }

    private static void stopWMSLoggerDispatcher() {
        wmsTPE.shutdown();
        bq.close();
        dispatchLogs = false;
        isInitialised = false;
    }

    private static Statement getInsertStatement(WmsLog log) {
        Insert statement = QueryBuilder.insertInto((String)QueryBuilder.quote((String)"WMSLOG"), (String)QueryBuilder.quote((String)LoggingUtil.getCFName(log.getCreatedTime()))).value(ENTITYID, (Object)log.getDataAsString(ENTITYID)).value(SERVICE, (Object)log.getDataAsString(SERVICE)).value(PRD, (Object)log.getDataAsString(PRD)).value(CATEGORY, (Object)log.getDataAsString(CATEGORY)).value(TIME_UUID, (Object)LoggingUtil.getTimeUUID(log.getCreatedTime())).value(SUBCATEGORY, (Object)log.getDataAsString(SUBCATEGORY)).value(MESSAGE, (Object)log.getDataAsString(MESSAGE)).value(MILESTONE, (Object)log.getDataAsString(MILESTONE)).value(REQ_ID, (Object)log.getDataAsString(REQ_ID)).value(STATUS, (Object)((Integer)log.getData(STATUS))).value(ADDL_INFO_1, (Object)log.getDataAsString(ADDL_INFO_1)).value(ADDL_INFO_2, (Object)log.getDataAsString(ADDL_INFO_2)).value(ADDL_INFO_3, (Object)log.getDataAsString(ADDL_INFO_3));
        return statement;
    }

    public static void log(String service, String prd, String entityID, String category, String subCategory, String reqId, String message, String stage, String addlInfo1, String addlInfo2, String addlInfo3) {
        WmsLogger.printLog(service, prd, entityID, category, subCategory, reqId, message, stage, 1, addlInfo1, addlInfo2, addlInfo3);
    }

    public static void severeLog(String service, String prd, String entityID, String category, String subCategory, String reqId, String message, String stage, String addlInfo1, String addlInfo2, String addlInfo3) {
        WmsLogger.printLog(service, prd, entityID, category, subCategory, reqId, message, stage, 0, addlInfo1, addlInfo2, addlInfo3);
    }

    private static void printLog(String service, String prd, String entityID, String category, String subCategory, String reqId, String message, String stage, int status, String addlInfo1, String addlInfo2, String addlInfo3) {
        if (!dispatchLogs) {
            return;
        }
        if (CommonUtil.isEmpty((String)service) || CommonUtil.isEmpty((String)prd) || CommonUtil.isEmpty((String)entityID) || CommonUtil.isEmpty((String)category)) {
            StatsDB.recordError(ComponentConstants.WMSLOGGER_ENUM.getModuleCode(), ComponentConstants.WMSLOGGER_ENUM.MISSING_PARAM.getErrorCode(), 1L);
            LOGGER.info("WMSLOG --> Error adding logs, null value for service=" + service + " product=" + prd + " entityID=" + entityID + " category=" + category + " subcat=" + subCategory + " reqid=" + reqId + " msg=" + message + " stage=" + stage);
            return;
        }
        if (CommonUtil.isEmpty((String)reqId)) {
            reqId = LoggingUtil.getUUID();
        }
        try {
            WmsLog log = new WmsLog();
            log.setOpr("addlog");
            log.putData(SERVICE, service);
            log.putData(PRD, prd);
            log.putData(ENTITYID, entityID);
            log.putData(CATEGORY, category);
            log.putData(REQ_ID, reqId);
            log.putData(STATUS, status);
            if (!CommonUtil.isEmpty((String)subCategory)) {
                log.putData(SUBCATEGORY, WmsLogger.stringMasker(subCategory, 30));
            } else {
                log.putData(SUBCATEGORY, "-");
            }
            if (!CommonUtil.isEmpty((String)stage)) {
                log.putData(MILESTONE, WmsLogger.stringMasker(stage, 30));
            } else {
                log.putData(MILESTONE, "-");
            }
            if (!CommonUtil.isEmpty((String)message)) {
                log.putData(MESSAGE, WmsLogger.stringMasker(message, 30));
            } else {
                log.putData(MESSAGE, "-");
            }
            if (!CommonUtil.isEmpty((String)addlInfo1)) {
                log.putData(ADDL_INFO_1, WmsLogger.stringMasker(addlInfo1, 30));
            } else {
                log.putData(ADDL_INFO_1, "-");
            }
            if (!CommonUtil.isEmpty((String)addlInfo2)) {
                log.putData(ADDL_INFO_2, WmsLogger.stringMasker(addlInfo2, 30));
            } else {
                log.putData(ADDL_INFO_2, "-");
            }
            if (!CommonUtil.isEmpty((String)addlInfo3)) {
                log.putData(ADDL_INFO_3, WmsLogger.stringMasker(addlInfo3, 30));
            } else {
                log.putData(ADDL_INFO_3, "-");
            }
            wmsTPE.execute(log);
            if (StatsConf.isWmsLoggerStatsEnabled()) {
                StatsDB.addData("sst_server_side_usage", service, prd, category, status == 1 ? "success" : "failure", 1);
            }
        }
        catch (Exception e) {
            LoggingUtil.recordException(e);
            LOGGER.log(Level.SEVERE, "WMSLOG --> Error while adding log in queue, prd=" + prd + " service=" + service + " entityId=" + entityID + " category=" + category, e);
        }
    }

    private static String stringMasker(String message, int length) {
        try {
            trimmedString = message.trim();
            if (trimmedString.length() <= length) {
                return trimmedString;
            }
            return trimmedString.substring(0, length);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "WMSLOG --> Unable to trim string = " + message, e);
            return "";
        }
    }

    public static Map<String, Object> handleAdminOperation(Map<String, String> header, Map<String, String> params) {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        try {
            LOGGER.info("WMSLOG--> Header : " + header + " param : " + params);
            String opr = header.get("opr");
            if ("fetch".equals(opr)) {
                Map columnData = (Map)HttpDataWraper.getObject((String)params.get("data"));
                responseMap.put(STATUS, 200);
                responseMap.put("result", HttpDataWraper.getString(WmsLogger.fetchLogs(columnData)));
            } else {
                LOGGER.info("WMSLOG --> opr : " + opr);
                responseMap.put(STATUS, 500);
                responseMap.put("result", "Invalid Opr");
            }
        }
        catch (Exception e) {
            StatsDB.recordError(ComponentConstants.WMSLOGGER_ENUM.getModuleCode(), ComponentConstants.WMSLOGGER_ENUM.ERROR_WHILE_FETCHING_LOGS.getErrorCode(), 1L);
            LOGGER.log(Level.SEVERE, "WMSLOG --> Error while handling wms logger operations", e);
            responseMap.put(STATUS, 500);
            responseMap.put("result", "Error inside handle opr");
        }
        return responseMap;
    }

    private static List<Map<String, Object>> fetchLogs(Map<String, Object> columnData) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try {
            int limit = 0;
            ResultSet resultset = null;
            Statement statement = null;
            LinkedHashMap<String, Object> rowDetails = null;
            Long stime = Long.parseLong((String)columnData.get("stime"));
            Long etime = Long.parseLong((String)columnData.get("etime"));
            if (stime == null || etime == null || stime < 1L || etime < 1L) {
                return result;
            }
            ArrayList<String> cfList = LoggingUtil.getCFList(stime, etime);
            for (String cfName : cfList) {
                try {
                    if (result.size() < 100) {
                        limit = 100 - result.size();
                        statement = WmsLogger.getSelectStatement(cfName, (String)columnData.get(SERVICE), (String)columnData.get(PRD), (String)columnData.get(ENTITYID), (String)columnData.get(CATEGORY), (String)columnData.get(SUBCATEGORY), (String)columnData.get(REQ_ID), (String)columnData.get(ADDL_INFO_1), (String)columnData.get(ADDL_INFO_2), (String)columnData.get(ADDL_INFO_3), stime, etime, limit);
                        resultset = QueryExecutor.execute(session, statement);
                        for (Row row : resultset) {
                            rowDetails = new LinkedHashMap<String, Object>();
                            rowDetails.put(ENTITYID, row.getString(ENTITYID));
                            rowDetails.put(SERVICE, row.getString(SERVICE));
                            rowDetails.put(PRD, row.getString(PRD));
                            rowDetails.put(CATEGORY, row.getString(CATEGORY));
                            rowDetails.put(SUBCATEGORY, row.getString(SUBCATEGORY));
                            rowDetails.put(MESSAGE, row.getString(MESSAGE));
                            rowDetails.put(MILESTONE, row.getString(MILESTONE));
                            rowDetails.put(TIME, LoggingUtil.getTimeStamp(row.getUUID(TIME_UUID)));
                            rowDetails.put(REQ_ID, row.getString(REQ_ID));
                            rowDetails.put(STATUS, row.getShort(STATUS));
                            rowDetails.put(ADDL_INFO_1, row.getString(ADDL_INFO_1));
                            rowDetails.put(ADDL_INFO_2, row.getString(ADDL_INFO_2));
                            rowDetails.put(ADDL_INFO_3, row.getString(ADDL_INFO_3));
                            result.add(rowDetails);
                        }
                        continue;
                    }
                    break;
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "WMSLOG --> Error while processing data from cf :" + cfName, e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "WMSLOG--> Error while getting logs for column datas : " + columnData, e);
        }
        return result;
    }

    public static Statement getSelectStatement(String cfName, String service, String prd, String entityID, String category, String subCategory, String reqid, String addlInfo1, String addlInfo2, String addlInfo3, long stime, long etime, int limit) {
        Select.Selection selection = QueryBuilder.select();
        Select.Builder builder = selection.all();
        Select select = builder.from(QueryBuilder.quote((String)"WMSLOG"), QueryBuilder.quote((String)cfName));
        Select.Where where = select.where(QueryBuilder.eq((String)SERVICE, (Object)service));
        where = where.and(QueryBuilder.eq((String)ENTITYID, (Object)entityID));
        where = where.and(QueryBuilder.eq((String)PRD, (Object)prd));
        where = where.and(QueryBuilder.eq((String)CATEGORY, (Object)category));
        where = where.and(QueryBuilder.gte((String)TIME_UUID, (Object)LoggingUtil.getTimeUUID(stime)));
        where = where.and(QueryBuilder.lte((String)TIME_UUID, (Object)LoggingUtil.getTimeUUID(etime)));
        if (!CommonUtil.isEmpty((String)subCategory)) {
            where = where.and(QueryBuilder.eq((String)SUBCATEGORY, (Object)subCategory));
        }
        if (!CommonUtil.isEmpty((String)reqid)) {
            where = where.and(QueryBuilder.eq((String)REQ_ID, (Object)reqid));
        }
        if (!CommonUtil.isEmpty((String)addlInfo1)) {
            where = where.and(QueryBuilder.eq((String)ADDL_INFO_1, (Object)addlInfo1));
        }
        if (!CommonUtil.isEmpty((String)addlInfo2)) {
            where = where.and(QueryBuilder.eq((String)ADDL_INFO_2, (Object)addlInfo2));
        }
        if (!CommonUtil.isEmpty((String)addlInfo3)) {
            where = where.and(QueryBuilder.eq((String)ADDL_INFO_3, (Object)addlInfo3));
        }
        if (limit <= 100) {
            where.limit(limit);
        } else {
            where.limit(100);
        }
        if (!(CommonUtil.isEmpty((String)subCategory) && CommonUtil.isEmpty((String)reqid) && CommonUtil.isEmpty((String)addlInfo1) && CommonUtil.isEmpty((String)addlInfo2) && CommonUtil.isEmpty((String)addlInfo3))) {
            where.allowFiltering();
        }
        return where;
    }

    static class WMSLogHandler
    implements WmsTask {
        WMSLogHandler() {
        }

        @Override
        public void handle(Object obj) {
            String opr;
            WmsLog log = (WmsLog)obj;
            if (log != null && (opr = log.getOpr()).equals("addlog")) {
                try {
                    Statement statement = WmsLogger.getInsertStatement(log);
                    QueryExecutor.execute(session, statement);
                }
                catch (Exception exp) {
                    LoggingUtil.recordException(exp);
                    LOGGER.log(Level.SEVERE, "WMSLOG --> Error while adding data" + log.toString(), exp);
                }
            }
        }
    }

    public static class User {
        public static final String WMSADMIN = "3";
        public static final String PRODUCT_ADMIN = "2";
        public static final String PRODUCT_DEV = "1";
    }
}

