/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.executor;

import com.adventnet.wms.common.HttpConnection;
import com.adventnet.wms.servercommon.components.executor.TaskExecutorService;
import com.adventnet.wms.servercommon.grid.ar.ARManager;
import com.adventnet.wms.servercommon.grid.ar.ARModule;
import com.adventnet.wms.servercommon.util.FileUtil;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskManagerModule
implements ARModule {
    private static Logger logger = Logger.getLogger(TaskManagerModule.class.getName());
    private long maxARPrepareTime = -1L;
    private boolean isDrain = false;

    public TaskManagerModule() {
        this(false);
    }

    public TaskManagerModule(long maxARPrepareTime) {
        if (maxARPrepareTime > 0L && maxARPrepareTime < 120000L) {
            this.maxARPrepareTime = maxARPrepareTime;
        }
    }

    public TaskManagerModule(boolean isDrain) {
        this.isDrain = isDrain;
    }

    @Override
    public boolean init(int serverMode) {
        return true;
    }

    @Override
    public void prepare() {
        Boolean status;
        String statusMessage = "";
        if (this.isDrain) {
            status = TaskExecutorService.drain();
            statusMessage = status.booleanValue() ? TaskExecutorService.getAll().size() + " managers drained " : "TES not initialized";
        } else {
            status = TaskExecutorService.shutdown(true);
            if (status.booleanValue()) {
                this.transferFiles();
                statusMessage = TaskExecutorService.getTotalPoolSize() + "/" + TaskExecutorService.getTotalPoolSize() + " threads Shutdown ";
            } else {
                statusMessage = "TES not initialized";
            }
        }
        if (status.booleanValue()) {
            try {
                ARManager.updateStatus(this, 100, statusMessage);
            }
            catch (Exception e) {
                logger.log(Level.FINE, "NS--> Exception while calling updateStatus", e);
            }
        } else {
            try {
                ARManager.updateStatus(this, 101, statusMessage);
            }
            catch (Exception e) {
                logger.log(Level.FINE, "NS--> Exception while calling updateStatus", e);
            }
        }
    }

    @Override
    public void perform() {
        try {
            ARManager.updateStatus(this, 200, "No Operation");
        }
        catch (Exception e) {
            logger.log(Level.FINE, "NS--> Exception while calling updateStatus inside TaskManagerModule", e);
        }
    }

    @Override
    public void onComplete(int serverMode) {
    }

    @Override
    public Map<String, String> getProgress() {
        return TaskExecutorService.getShutdownProgress(this.isDrain);
    }

    @Override
    public int getExecutionType() {
        return 2;
    }

    @Override
    public int getModuleId() {
        return 102;
    }

    @Override
    public String getModuleName() {
        return "TaskExecutorService";
    }

    @Override
    public Hashtable<String, Object> getStatus(int serverMode) {
        return TaskExecutorService.getShutdownStatus(this.isDrain);
    }

    @Override
    public Hashtable<String, Object> getDetailedStatus(int serverMode) {
        return TaskExecutorService.getDetailedShutdownStatus(this.isDrain);
    }

    @Override
    public void abort() {
        if (TaskExecutorService.isShutDownInProgress) {
            logger.info("VS --> TaskManagerModule abort called");
            TaskExecutorService.isInitialized = false;
        }
    }

    @Override
    public long getMaximumPrepareTime() {
        if (this.maxARPrepareTime != -1L) {
            return this.maxARPrepareTime;
        }
        return 120000L;
    }

    @Override
    public long getMaximumPerformTime() {
        return 3000L;
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean transferFiles() {
        ArrayList<File> list = TaskExecutorService.getArTransferFiles();
        if (list.isEmpty()) {
            return true;
        }
        try {
            int streamSize = 32768;
            String url = "http://" + ARManager.getARIp() + ":" + ARManager.getGACPort() + "/ar/filetransfer";
            for (File file : list) {
                String filePath = file.getPath();
                if (!file.exists()) {
                    logger.info("TESAR--> Skipping file transfer for file=" + filePath + " as file does not exist.");
                    continue;
                }
                if (filePath.length() == 0) {
                    logger.info("TESAR--> Skipping file transfer for file=" + filePath + " as file length is zero");
                    continue;
                }
                HttpConnection con = new HttpConnection(url, 20000, 5000);
                con.addHeader("x-streammode", "1");
                con.addHeader("componentname", "TES");
                con.addHeader("filepath", filePath);
                con.addHeader("Content-Length", "" + file.length());
                con.addHeader("Content-Type", "application/octet-stream");
                InputStream is = FileUtil.getInputStream(filePath);
                HttpURLConnection urlConn = (HttpURLConnection)con.getConnection();
                OutputStream os = urlConn.getOutputStream();
                int responseCode = 0;
                try {
                    FileUtil.fileTransfer(is, os, streamSize);
                    responseCode = urlConn.getResponseCode();
                    if (responseCode == 200) continue;
                    throw new Exception("responseCode error " + responseCode);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "VS_ERR --> Exception while transfering Properties files for File - " + file.getName() + " response code - " + responseCode, e);
                    return false;
                    return true;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "VS_ERR --> Exception while transfering TES Properties Files", e);
            return false;
        }
    }
}

