/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.executor;

import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.TraceLogConfManager;
import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.components.executor.AbsTaskManager;
import com.adventnet.wms.servercommon.components.executor.TaskEngine;
import com.adventnet.wms.servercommon.components.executor.WMSQueueScheduler;
import com.adventnet.wms.servercommon.components.executor.WMSThreadPoolExecutor;
import com.adventnet.wms.servercommon.components.executor.WmsTask;
import com.adventnet.wms.servercommon.components.queue.BufferedQueue;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.stats.influx.conf.StatsConf;
import com.adventnet.wms.servercommon.util.WMSUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskManager
extends AbsTaskManager {
    private static Logger logger = Logger.getLogger(TaskManager.class.getName());
    private Logger msgtracelogger = Logger.getLogger("msgtracelogger");
    private String tmName;
    private String tesVersion = "";
    private boolean isBlocked = false;
    private boolean isAREnabled;
    private String taskConfDir;
    private HashMap<String, TaskEngine> taskEngine = new HashMap();
    private ConcurrentHashMap<String, AtomicLong> taskcounter = new ConcurrentHashMap(100, 0.75f, 16);
    private ConcurrentHashMap<String, Hashtable<String, AtomicLong>> prdtaskcounter = null;
    private long timeout = -1L;
    private Hashtable ignoretasks = new Hashtable();
    private boolean prdstatsenabled = false;
    private WMSQueueScheduler wmsQueueScheduler = null;
    private int corePoolSize = 0;
    private int maxPoolSize = 0;
    private int isoPoolSize = 0;
    private long startupTime = 0L;
    private BufferedQueue isolationQueue;
    private WMSThreadPoolExecutor isolationExecutor;
    private ConcurrentHashMap<String, AtomicLong> tasksCountMap = new ConcurrentHashMap();

    public boolean initialize(String tmName, String tesVersion, long timelimit, int corePoolSize, int maxPoolSize, int keepAliveTime, boolean isAREnabled) {
        try {
            this.tmName = tmName;
            this.tesVersion = tesVersion;
            this.isAREnabled = isAREnabled;
            this.wmsQueueScheduler = new WMSQueueScheduler(tmName, tesVersion, keepAliveTime, TimeUnit.MILLISECONDS);
            this.taskConfDir = ServerUtil.serverHome + File.separator + "conf" + File.separator + "taskmanager" + File.separator + tmName + File.separator;
            this.isolationQueue = new BufferedQueue(ServerUtil.dataHome + "newbqueue" + File.separator + "tes" + File.separator + tmName + File.separator + "isolation_tmp", tmName + "-isolation", 500, isAREnabled);
            this.isolationExecutor = new WMSThreadPoolExecutor("TES/-" + tmName + "-isolation", 0, 1, 30L, TimeUnit.SECONDS, this.isolationQueue, new EventHandler(this.taskEngine));
            Properties tconf = ServerUtil.getProperties(this.taskConfDir + "taskengine.conf");
            int poolSize = 0;
            Enumeration<?> e = tconf.propertyNames();
            while (e.hasMoreElements()) {
                int lowpriorityratio;
                int highpriorityratio;
                int mediumpriorityratio;
                String teName = (String)e.nextElement();
                String teParam = (String)tconf.get(teName);
                String[] teParams = teParam.split(",");
                int bufSize = new Integer(teParams[0]);
                try {
                    mediumpriorityratio = new Integer(teParams[1]);
                }
                catch (Exception exp) {
                    mediumpriorityratio = 0;
                }
                try {
                    highpriorityratio = new Integer(teParams[2]);
                }
                catch (Exception exp) {
                    highpriorityratio = 0;
                }
                try {
                    lowpriorityratio = new Integer(teParams[3]);
                }
                catch (Exception exp) {
                    lowpriorityratio = 0;
                }
                poolSize += mediumpriorityratio + highpriorityratio + lowpriorityratio;
                TaskEngine engine = new TaskEngine(teName, tmName, tesVersion, bufSize, highpriorityratio, mediumpriorityratio, lowpriorityratio, this.wmsQueueScheduler, this.isolationExecutor, isAREnabled);
                if (!engine.start()) {
                    return false;
                }
                this.taskEngine.put(teName, engine);
                this.startupTime = System.currentTimeMillis();
            }
            if (corePoolSize <= 0) {
                corePoolSize = poolSize;
            }
            if (maxPoolSize <= 0) {
                maxPoolSize = poolSize;
            }
            this.corePoolSize = corePoolSize;
            this.maxPoolSize = maxPoolSize;
            this.timeout = timelimit;
            this.wmsQueueScheduler.intialize(corePoolSize, maxPoolSize);
            this.wmsQueueScheduler.setTaskEngineMap(this.taskEngine);
            this.wmsQueueScheduler.startFairPolicyAllocator();
            this.isoPoolSize = maxPoolSize / 3;
            if (this.isoPoolSize == 0) {
                this.isoPoolSize = 1;
            }
            this.isolationExecutor.setMaximumPoolSize(this.isoPoolSize);
            this.isolationExecutor.start();
            logger.info("TES --> Task Manager::" + tmName + " intialized " + this.taskEngine);
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "TES_ERR--> TM_INITIALIZATION_FAILED " + tmName, e);
            StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TM_INITIALIZATION_FAILED.getErrorCode(), 1L);
            return false;
        }
    }

    @Override
    public void delegate(WmsEvent event, boolean needsDuplication) {
        try {
            if (event == null) {
                return;
            }
            if (this.isDisabledEvent(event)) {
                logger.fine("TES --> disabled event=" + event);
                return;
            }
            long starttime = System.currentTimeMillis();
            this.printTrace(event, "delegate");
            this.incrementTaskCount(event);
            event.putData("inqueuetime", (Object)("" + starttime));
            if (needsDuplication) {
                event = event.duplicate();
            }
            event.trackOpr("d");
            long duplicationtime = System.currentTimeMillis();
            this.hit(event.getOpr());
            ServerUtil.logExternal(event, "delegate", "event_in");
            this.taskEngine.get(event.getOpr().split("\\.")[0]).handle(event);
            long totaltime = System.currentTimeMillis();
            if (this.timeout != -1L && (totaltime - starttime >= this.timeout || totaltime - duplicationtime >= this.timeout)) {
                logger.info("TES --> Timeout in taskmanager totaltime: " + (totaltime - starttime) + " duplicationtime: " + (duplicationtime - starttime));
            }
            this.hit(event);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "TES_ERR --> TM_DELEGATE_FAILED Unable to delegate task event : " + event.getOpr(), e);
            StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TM_DELEGATE_FAILED.getErrorCode(), 1L);
        }
    }

    @Override
    public boolean chain(WmsEvent event) {
        try {
            if (event == null) {
                return false;
            }
            if (this.isDisabledEvent(event)) {
                return false;
            }
            this.printTrace(event, "chain");
            event.trackOpr("c");
            this.incrementTaskCount(event);
            ServerUtil.logExternal(event, "chain", "event_start");
            return this.taskEngine.get(event.getOpr().split("\\.")[0]).chain(event);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "TES_ERR --> TM_CHAIN_FAILED Unable to chain task event : " + event.getOpr(), e);
            StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TM_CHAIN_FAILED.getErrorCode(), 1L);
            return false;
        }
    }

    @Override
    public void printTrace(WmsEvent event, String method) {
        if (TraceLogConfManager.isDebugEnabled(event.getOpr(), event.getRKey())) {
            this.msgtracelogger.info("TaskManager [" + method + "] [" + event.getOpr() + "] [" + event.getRKey() + "] [Event] " + event.toString());
            event.enableTrace();
        }
    }

    @Override
    public boolean isAREnabled() {
        return this.isAREnabled;
    }

    @Override
    public void shutdown() {
        this.wmsQueueScheduler.shutdown();
        this.isolationExecutor.shutdown();
    }

    @Override
    public void stopAllEngines() {
        for (TaskEngine engine : this.taskEngine.values()) {
            engine.stop();
        }
        this.isolationQueue.close();
    }

    @Override
    public void restart() {
        for (TaskEngine engine : this.taskEngine.values()) {
            engine.restart();
        }
        this.isolationQueue.open();
    }

    @Override
    public ConcurrentHashMap<String, AtomicLong> getStats() {
        return this.taskcounter;
    }

    @Override
    public void resetStats() {
        this.taskcounter.clear();
    }

    private void hit(String taskName) {
        if (taskName == null) {
            return;
        }
        try {
            this.taskcounter.putIfAbsent(taskName, new AtomicLong());
            this.taskcounter.get(taskName).incrementAndGet();
        }
        catch (Exception exp) {
            logger.log(Level.INFO, "TES_ERR --> Error in adding stats. taskName :" + taskName, exp);
        }
    }

    @Override
    public void enablePrdStats() {
        this.prdstatsenabled = true;
        this.prdtaskcounter = new ConcurrentHashMap();
    }

    @Override
    public void disablePrdStats() {
        this.prdstatsenabled = false;
        this.prdtaskcounter = new ConcurrentHashMap();
    }

    public void setPoolSize(int corePoolSize, int maximumPoolSize) {
        this.wmsQueueScheduler.setPoolSize(corePoolSize, maximumPoolSize);
    }

    @Override
    public ConcurrentHashMap<String, Hashtable<String, AtomicLong>> getPrdStats() {
        return this.prdtaskcounter;
    }

    @Override
    public String drainQueue(String teName, String queueID, int drainCount, boolean isIsolation) {
        if (isIsolation && (drainCount == -1 ? this.isolationQueue.dropAll() : this.isolationQueue.drop(drainCount))) {
            return "Drain completed for " + this.isolationQueue.getFileName();
        }
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).drainQueue(queueID, drainCount);
        }
        return "invalid taskenginename";
    }

    @Override
    public String blockAllEngines() {
        if (this.isBlocked) {
            return "TaskManager - " + this.tmName + " is already blocked";
        }
        for (TaskEngine engine : this.taskEngine.values()) {
            engine.blockEngine();
        }
        this.isBlocked = true;
        return "blocked TaskManager - " + this.tmName;
    }

    @Override
    public String blockEngine(String teName) {
        if (this.isBlocked) {
            return "TaskManager - " + this.tmName + " is blocked";
        }
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).blockEngine();
        }
        return "invalid taskenginename";
    }

    @Override
    public String blockTask(String teName, String task) {
        if (this.isBlocked) {
            return "TaskManager - " + this.tmName + " is blocked";
        }
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).blockTask(task);
        }
        return "invalid taskenginename";
    }

    @Override
    public String dropTask(String teName, String task, int count) {
        if (this.isBlocked) {
            return "TaskManager - " + this.tmName + " is blocked";
        }
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).dropTask(task, count);
        }
        return "invalid taskenginename";
    }

    @Override
    public String blockRkey(String teName, String task, String rkey) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).blockRkey(rkey, task);
        }
        return "invalid taskenginename";
    }

    @Override
    public String blockRkey(String teName, String rkey) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).blockRkey(rkey);
        }
        return "invalid taskenginename";
    }

    @Override
    public String blockRkey(String rkey) {
        for (TaskEngine engine : this.taskEngine.values()) {
            engine.blockRkey(rkey);
        }
        return "Blocked Rkey - " + rkey;
    }

    @Override
    public String blockPrd(String teName, String task, String prd) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).blockPrd(prd, task);
        }
        return "invalid taskenginename";
    }

    @Override
    public String blockPrd(String teName, String prd) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).blockPrd(prd);
        }
        return "invalid taskenginename";
    }

    @Override
    public String blockPrd(String prd) {
        for (TaskEngine engine : this.taskEngine.values()) {
            engine.blockPrd(prd);
        }
        return "Blocked Prd - " + prd;
    }

    @Override
    public String unblockAllEngines() {
        if (!this.isBlocked) {
            return "TaskManager - " + this.tmName + " is already unblocked";
        }
        for (TaskEngine engine : this.taskEngine.values()) {
            engine.unblockEngine();
        }
        this.isBlocked = false;
        return "unblocked TaskManager - " + this.tmName;
    }

    @Override
    public String unblockEngine(String teName) {
        if (this.isBlocked) {
            return "TaskManager - " + this.tmName + " is blocked";
        }
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).unblockEngine();
        }
        return "invalid taskenginename";
    }

    @Override
    public String unblockTask(String teName, String task) {
        if (this.isBlocked) {
            return "TaskManager - " + this.tmName + " is blocked";
        }
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).unblockTask(task);
        }
        return "invalid taskenginename";
    }

    @Override
    public String unblockRkey(String teName, String task, String rkey) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).unblockRkey(rkey, task);
        }
        return "invalid taskenginename";
    }

    @Override
    public String unblockRkey(String teName, String rkey) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).unblockRkey(rkey);
        }
        return "invalid taskenginename";
    }

    @Override
    public String unblockRkey(String rkey) {
        for (TaskEngine engine : this.taskEngine.values()) {
            engine.unblockRkey(rkey);
        }
        return "Blocked Rkey - " + rkey;
    }

    @Override
    public String unblockPrd(String teName, String task, String prd) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).unblockPrd(prd, task);
        }
        return "invalid taskenginename";
    }

    @Override
    public String unblockPrd(String teName, String prd) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).unblockPrd(prd);
        }
        return "invalid taskenginename";
    }

    @Override
    public String unblockPrd(String prd) {
        for (TaskEngine engine : this.taskEngine.values()) {
            engine.unblockPrd(prd);
        }
        return "UnBlocked Prd - " + prd;
    }

    public String isolateEngine(String teName) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).isolatedEngine();
        }
        return "invalid taskenginename";
    }

    public String isolateTask(String teName, String task) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).isolateTask(task);
        }
        return "invalid taskenginename";
    }

    public String isolatePrd(String prd) {
        for (TaskEngine engine : this.taskEngine.values()) {
            engine.isolatePrd(prd);
        }
        return "Isolated Prd - " + prd;
    }

    public String isolateRkey(String rkey) {
        for (TaskEngine engine : this.taskEngine.values()) {
            engine.isolateRkey(rkey);
        }
        return "Isolated Rkey - " + rkey;
    }

    public String isolatePrd(String teName, String prd) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).isolatePrd(prd);
        }
        return "invalid taskenginename";
    }

    public String isolateRkey(String teName, String rkey) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).isolateRkey(rkey);
        }
        return "invalid taskenginename";
    }

    public String deIsolateEngine(String teName) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).deIsolateEngine();
        }
        return "invalid taskenginename";
    }

    public String deIsolateTask(String teName, String task) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).deIsolateTask(task);
        }
        return "invalid taskenginename";
    }

    public String deIsolatePrd(String prd) {
        for (TaskEngine engine : this.taskEngine.values()) {
            engine.deIsolatePrd(prd);
        }
        return "DeIsolated Prd - " + prd;
    }

    public String deIsolateRkey(String rkey) {
        for (TaskEngine engine : this.taskEngine.values()) {
            engine.deIsolateRkey(rkey);
        }
        return "DeIsolated Rkey - " + rkey;
    }

    public String deIsolatePrd(String teName, String prd) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).deIsolatePrd(prd);
        }
        return "invalid taskenginename";
    }

    public String deIsolateRkey(String teName, String rkey) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).deIsolateRkey(rkey);
        }
        return "invalid taskenginename";
    }

    public void setIsolationThreadsCount(int count) {
        this.isolationExecutor.setMaximumPoolSize(count);
        this.isoPoolSize = count;
    }

    @Override
    public HashMap<String, ConcurrentHashMap<String, Object>> getBlockedStatus() {
        HashMap<String, ConcurrentHashMap<String, Object>> result = new HashMap<String, ConcurrentHashMap<String, Object>>();
        for (TaskEngine engine : this.taskEngine.values()) {
            ConcurrentHashMap<String, Object> map = engine.getBlockedStatus();
            if (map.isEmpty()) continue;
            result.put(engine.getName(), map);
        }
        return result;
    }

    public HashMap<String, HashMap<String, ConcurrentHashMap<String, AtomicLong>>> getIsolationStatus() {
        HashMap<String, HashMap<String, ConcurrentHashMap<String, AtomicLong>>> result = new HashMap<String, HashMap<String, ConcurrentHashMap<String, AtomicLong>>>();
        for (TaskEngine engine : this.taskEngine.values()) {
            HashMap<String, ConcurrentHashMap<String, AtomicLong>> map = engine.getIsolationStatus();
            if (map.isEmpty()) continue;
            result.put(engine.getName(), map);
        }
        return result;
    }

    @Override
    public void resetPrdStats() {
        this.prdtaskcounter = new ConcurrentHashMap();
    }

    private void hit(WmsEvent event) {
        if (!this.prdstatsenabled) {
            return;
        }
        String taskname = event.getOpr();
        if (taskname == null) {
            return;
        }
        String prd = event.getDataAsString("prd");
        this.addPrdTask(prd, taskname);
        this.addPrdTask("wms", taskname);
    }

    private void addPrdTask(String prd, String taskname) {
        AtomicLong al;
        if (prd == null) {
            return;
        }
        if (StatsConf.isTaskEngineStatsEnabled()) {
            StatsDB.addData("tasks", this.tmName, prd, taskname, taskname.split("\\.")[0], 1);
            StatsDB.addData("tesinstats", DC.getServertype(), DC.getCluster(), prd, this.tmName, taskname.split("\\.")[0], taskname, 1);
            return;
        }
        Hashtable<String, AtomicLong> tcount = this.prdtaskcounter.get(prd);
        if (tcount == null) {
            tcount = new Hashtable();
            tcount.put(taskname, new AtomicLong());
            this.prdtaskcounter.put(prd, tcount);
        }
        if ((al = tcount.get(taskname)) == null) {
            al = new AtomicLong();
            tcount.put(taskname, al);
        }
        al.incrementAndGet();
    }

    @Override
    public Hashtable<String, Hashtable<String, String>> getQueStats() {
        Hashtable<String, Hashtable<String, String>> details = new Hashtable<String, Hashtable<String, String>>();
        for (TaskEngine engine : this.taskEngine.values()) {
            details.put(engine.getName(), engine.getStats());
        }
        return details;
    }

    @Override
    public Hashtable<String, ArrayList<Hashtable<String, String>>> getWmsQStats() {
        Hashtable<String, ArrayList<Hashtable<String, String>>> details = new Hashtable<String, ArrayList<Hashtable<String, String>>>();
        for (TaskEngine engine : this.taskEngine.values()) {
            details.put(engine.getName(), engine.getWmsQStats());
        }
        ArrayList<Hashtable<String, String>> isoDetails = new ArrayList<Hashtable<String, String>>();
        isoDetails.add(this.isolationQueue.getWmsQStats());
        details.put("isolation", isoDetails);
        return details;
    }

    @Override
    public void clearQueStats() {
        for (TaskEngine engine : this.taskEngine.values()) {
            engine.clearStats();
        }
    }

    @Override
    public boolean isDisabledEvent(WmsEvent event) {
        if (this.ignoretasks != null && this.ignoretasks.size() != 0) {
            Hashtable disabledprds = null;
            if (this.ignoretasks.containsKey(event.getOpr().split("\\.")[0]) ? (disabledprds = (Hashtable)this.ignoretasks.get(event.getOpr().split("\\.")[0])) == null || disabledprds.size() == 0 : this.ignoretasks.containsKey(event.getOpr()) && ((disabledprds = (Hashtable)this.ignoretasks.get(event.getOpr())) == null || disabledprds.size() == 0)) {
                return true;
            }
            if (event.getData("prd") != null && disabledprds != null && disabledprds.containsKey(event.getData("prd"))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setIgnoreTasks(Hashtable properties) {
        this.ignoretasks = properties;
    }

    @Override
    public void initiateDrain() {
        for (TaskEngine engine : this.taskEngine.values()) {
            engine.setDrain(true);
            engine.restart();
        }
    }

    @Override
    public void stopDrain() {
        for (TaskEngine engine : this.taskEngine.values()) {
            engine.setDrain(false);
        }
    }

    @Override
    public int getTotalQueueSize() {
        int size = 0;
        for (TaskEngine engine : this.taskEngine.values()) {
            size += engine.getQueueSize();
        }
        return size += this.isolationQueue.size();
    }

    public ConcurrentHashMap<String, Long> resetAndGetMaxThreadAllotmentDetails() {
        ConcurrentHashMap<String, Long> map = this.wmsQueueScheduler.resetAndGetMaxThreadAllotmentDetails();
        if (this.isolationExecutor.getLargestPoolSize() != 0) {
            map.put("isolation", Long.valueOf(this.isolationExecutor.getLargestPoolSize()));
            map.put("maxThreads", map.get("maxThreads") + (long)this.isolationExecutor.getLargestPoolSize());
        }
        this.isolationExecutor.resetLargestPoolSize();
        return map;
    }

    public ConcurrentHashMap<String, Long> getMaxThreadAllotmentDetails() {
        ConcurrentHashMap<String, Long> map = this.wmsQueueScheduler.getMaxThreadAllotmentDetails();
        if (this.isolationExecutor.getLargestPoolSize() != 0) {
            map.put("isolation", Long.valueOf(this.isolationExecutor.getLargestPoolSize()));
            map.put("maxThreads", map.get("maxThreads") + (long)this.isolationExecutor.getLargestPoolSize());
        }
        return map;
    }

    public ConcurrentHashMap<String, AtomicLong> getCurrentThreadAllotmentDetails() {
        ConcurrentHashMap<String, AtomicLong> map = this.wmsQueueScheduler.getCurrentThreadAllotmentDetails();
        if (this.isolationExecutor.getCurrentPoolSize() != 0) {
            map.put("isolation", new AtomicLong(this.isolationExecutor.getActivePoolSize()));
            map.get("currentThreads").addAndGet(this.isolationExecutor.getActivePoolSize());
        }
        return map;
    }

    @Override
    public int getCurrentThreadCount() {
        return this.wmsQueueScheduler.getCurrentThreadCount() + this.isolationExecutor.getCurrentPoolSize();
    }

    @Override
    public int getActiveThreadCount() {
        return this.wmsQueueScheduler.getActiveThreadCount() + this.isolationExecutor.getActivePoolSize();
    }

    @Override
    public int getPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public Hashtable<String, Object> getShutdownStatus() {
        return this.wmsQueueScheduler.getShutdownStatus();
    }

    private void incrementTaskCount(WmsEvent event) {
        if (this.tasksCountMap.containsKey(event.getOpr())) {
            this.tasksCountMap.get(event.getOpr()).incrementAndGet();
        } else {
            this.tasksCountMap.put(event.getOpr(), new AtomicLong(1L));
        }
    }

    @Override
    public LinkedHashMap<String, Object> getStatus() {
        LinkedHashMap<String, Object> taskDetails = new LinkedHashMap<String, Object>();
        long duration = System.currentTimeMillis() - this.startupTime;
        taskDetails.put("Thread Count", this.getCurrentThreadCount() + (this.taskEngine.size() + 1));
        taskDetails.put("Total Execution Time", WMSUtil.HumanReadable.getDuration(duration, true));
        ArrayList taskDetailsOrder = new ArrayList(taskDetails.keySet());
        taskDetails.put("_order", taskDetailsOrder);
        return taskDetails;
    }

    @Override
    public LinkedHashMap<String, Object> getDetailedStatus() {
        LinkedHashMap<String, Object> taskDetails = new LinkedHashMap<String, Object>();
        long duration = System.currentTimeMillis() - this.startupTime;
        LinkedHashMap<String, Serializable> taskThreadDetails = new LinkedHashMap<String, Serializable>();
        taskThreadDetails.put("Max Thread Count", Integer.valueOf(this.getPoolSize()));
        taskThreadDetails.put("Created Thread Count", Integer.valueOf(this.getCurrentThreadCount()));
        taskThreadDetails.put("Active Thread Count", this.getCurrentThreadAllotmentDetails().remove("currentThreads"));
        taskThreadDetails.put("Basic Thread Count", Integer.valueOf(this.taskEngine.size() + 1));
        ArrayList taskThreadDetailsOrder = new ArrayList(taskThreadDetails.keySet());
        taskThreadDetails.put("_order", taskThreadDetailsOrder);
        taskDetails.put("Thread Details", taskThreadDetails);
        taskDetails.put("Total Execution Time", WMSUtil.HumanReadable.getDuration(duration, false));
        taskDetails.put("Task Details", this.tasksCountMap);
        ArrayList taskDetailsOrder = new ArrayList(taskDetails.keySet());
        taskDetails.put("_order", taskDetailsOrder);
        return taskDetails;
    }

    @Override
    public String getName() {
        return this.tmName;
    }

    private class EventHandler
    implements WmsTask {
        HashMap<String, TaskEngine> taskEngineMap;

        public EventHandler(HashMap<String, TaskEngine> taskEngineMap) {
            this.taskEngineMap = taskEngineMap;
        }

        @Override
        public void handle(Object obj) {
            WmsEvent event = (WmsEvent)obj;
            String opr = event.getOpr();
            String engineName = opr.split("\\.")[0];
            try {
                this.taskEngineMap.get(engineName).process(event);
            }
            catch (Error e) {
                StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TE_HANDLE_ERR.getErrorCode(), 1L);
                logger.log(Level.SEVERE, "TES_ERR --> TE_HANDLE_ERR Error while processing in WMSThreadPoolManager in " + TaskManager.this.tmName + " for event opr " + event.getOpr(), e);
                throw e;
            }
            StatsDB.addData("isolationcount", DC.getServertype(), DC.getCluster(), TaskManager.this.tmName, engineName, event.getOpr(), 1);
        }
    }
}

