/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.executor;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.components.executor.AbsTaskManager;
import com.adventnet.wms.servercommon.components.executor.SequentialTaskManager;
import com.adventnet.wms.servercommon.components.executor.StatusCollector;
import com.adventnet.wms.servercommon.components.executor.TESStatusCollector;
import com.adventnet.wms.servercommon.components.executor.TaskManager;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskExecutorService {
    private static Logger logger = Logger.getLogger(TaskExecutorService.class.getName());
    private static String tmConfDir = ServerUtil.serverHome + File.separator + "conf" + File.separator + "taskmanager" + File.separator;
    private static HashMap<String, AbsTaskManager> taskManager = new HashMap();
    private static HashMap<String, TaskManager> parallelTaskManager = new HashMap();
    private static HashMap<String, SequentialTaskManager> seqTaskManager = new HashMap();
    private static AtomicLong managerCountForShutdown;
    private static boolean prdstatsenabled;
    protected static boolean isInitialized;
    private static String version;
    protected static final long MAX_AR_PREPARE_TIME = 120000L;
    protected static final long MAX_AR_PERFORM_TIME = 3000L;
    protected static boolean isShutDownInProgress;
    protected static boolean isARInProgress;
    private static ReentrantLock shutDownLock;
    private static Condition shutDownCompleted;
    private static Hashtable<String, Integer> shutdownStatus;
    protected static final String TES_THREAD_PREFIX = "TES/";

    public static boolean initialise() {
        if (!isInitialized) {
            try {
                version = Long.toString(System.currentTimeMillis());
                Properties tconf = ServerUtil.getProperties(tmConfDir + "taskmanager.conf");
                managerCountForShutdown = new AtomicLong();
                for (String tmName : tconf.stringPropertyNames()) {
                    int maxPoolSize;
                    int corePoolSize;
                    boolean isAREnabled;
                    boolean isSequential;
                    String value = tconf.getProperty(tmName);
                    long timelimit = -1L;
                    String timeLimit = value.split(",")[0];
                    if (!CommonUtil.isEmpty((String)timeLimit)) {
                        try {
                            timelimit = Long.parseLong(timeLimit);
                        }
                        catch (Exception e) {
                            timelimit = -1L;
                        }
                    }
                    try {
                        String s = value.split(",")[1];
                        isSequential = Boolean.parseBoolean(s);
                    }
                    catch (Exception e) {
                        isSequential = false;
                    }
                    try {
                        String s = value.split(",")[5];
                        isAREnabled = Boolean.parseBoolean(s);
                    }
                    catch (Exception e) {
                        isAREnabled = true;
                    }
                    if (isSequential) {
                        SequentialTaskManager tm = new SequentialTaskManager();
                        if (!tm.initialize(tmName, version, timelimit, isAREnabled)) {
                            logger.log(Level.SEVERE, "TES_ERR --> TaskExecutorService is not initialized ");
                            return false;
                        }
                        if (prdstatsenabled) {
                            tm.enablePrdStats();
                        }
                        taskManager.put(tmName, tm);
                        seqTaskManager.put(tmName, tm);
                        continue;
                    }
                    try {
                        corePoolSize = Integer.parseInt(value.split(",")[2]);
                    }
                    catch (Exception e) {
                        corePoolSize = 0;
                    }
                    try {
                        maxPoolSize = Integer.parseInt(value.split(",")[3]);
                    }
                    catch (Exception e) {
                        maxPoolSize = 0;
                    }
                    int keepAliveTime = 0;
                    try {
                        keepAliveTime = Integer.parseInt(value.split(",")[4]);
                    }
                    catch (Exception e) {
                        keepAliveTime = 60000;
                    }
                    TaskManager tm = new TaskManager();
                    if (!tm.initialize(tmName, version, timelimit, corePoolSize, maxPoolSize, keepAliveTime, isAREnabled)) {
                        logger.log(Level.SEVERE, "TES_ERR --> TaskExecutorService is not initialized ");
                        return false;
                    }
                    if (prdstatsenabled) {
                        tm.enablePrdStats();
                    }
                    taskManager.put(tmName, tm);
                    parallelTaskManager.put(tmName, tm);
                }
                logger.info("TES --> TaskExecutorService is initialized version : " + version);
                StatusCollector.register(new TESStatusCollector());
                isInitialized = true;
                isShutDownInProgress = false;
                isARInProgress = false;
                return true;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "TES_ERR --> TES_INITIALIZATION_FAILED ", e);
                StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TES_INITIALIZATION_FAILED.getErrorCode(), 1L);
            }
        } else {
            logger.info("TES_ERR --> TaskExecutorService is already initialized version : " + version);
        }
        return false;
    }

    public static boolean startManager(String tmName, boolean isSequential, int corePoolSize, int maxPoolSize, int keepAliveTime) {
        boolean status = false;
        if (taskManager.containsKey(tmName)) {
            logger.info("TES_ERR --> TaskManager is already initialized " + tmName);
            return status;
        }
        if (isSequential) {
            SequentialTaskManager tm = new SequentialTaskManager();
            status = tm.initialize(tmName, "" + System.currentTimeMillis(), -1L, false);
            if (prdstatsenabled) {
                tm.enablePrdStats();
            }
            taskManager.put(tmName, tm);
        } else {
            TaskManager tm = new TaskManager();
            status = tm.initialize(tmName, "" + System.currentTimeMillis(), -1L, corePoolSize, maxPoolSize, keepAliveTime, false);
            if (prdstatsenabled) {
                tm.enablePrdStats();
            }
            taskManager.put(tmName, tm);
        }
        return status;
    }

    public static boolean stopManager(String tmName) {
        boolean status = true;
        if (taskManager.containsKey(tmName)) {
            int size = taskManager.get(tmName).getTotalQueueSize();
            int counter = 0;
            while (size > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    logger.fine("TES_ERR --> InterruptedException");
                }
                size = taskManager.get(tmName).getTotalQueueSize();
                if (counter++ != 2400) continue;
                logger.info("TES_ERR --> TaskManager Timeout in clearing queue");
                status = false;
                break;
            }
            taskManager.get(tmName).shutdown();
            counter = 0;
            int threads = taskManager.get(tmName).getActiveThreadCount();
            while (threads > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    logger.fine("TES_ERR --> InterruptedException");
                }
                threads = taskManager.get(tmName).getActiveThreadCount();
                if (counter++ != 600) continue;
                logger.info("TES_ERR --> TaskManager Timeout in stopping threads");
                status = false;
                break;
            }
            taskManager.get(tmName).stopAllEngines();
            taskManager.remove(tmName);
        }
        return status;
    }

    public static void execute(WmsEvent event) {
        TaskExecutorService.execute(event, true);
    }

    public static void execute(WmsEvent event, boolean needsDuplication) {
        if (!CommonUtil.isEmpty((String)event.getManager())) {
            taskManager.get(event.getManager()).delegate(event, needsDuplication);
        } else {
            com.adventnet.wms.servercommon.taskengine.TaskManager.delegate(event);
        }
    }

    public static boolean chain(WmsEvent event) {
        if (!CommonUtil.isEmpty((String)event.getHeader("tmname"))) {
            return taskManager.get(event.getHeader("tmname")).chain(event);
        }
        return com.adventnet.wms.servercommon.taskengine.TaskManager.chain(event);
    }

    public static AbsTaskManager get(String taskManagerName) {
        return taskManager.get(taskManagerName);
    }

    public static List<AbsTaskManager> getAll() {
        ArrayList<AbsTaskManager> taskManagersList = new ArrayList<AbsTaskManager>();
        for (String taskManagerName : taskManager.keySet()) {
            taskManagersList.add(taskManager.get(taskManagerName));
        }
        return taskManagersList;
    }

    public static void printTrace(String tmName, WmsEvent event, String method) {
        if (taskManager.containsKey(tmName)) {
            taskManager.get(tmName).printTrace(event, method);
        }
    }

    public static Hashtable<String, Hashtable<String, ArrayList<Hashtable<String, String>>>> getWmsQStats() {
        Hashtable<String, Hashtable<String, ArrayList<Hashtable<String, String>>>> wmsQStats = new Hashtable<String, Hashtable<String, ArrayList<Hashtable<String, String>>>>();
        for (String tmName : taskManager.keySet()) {
            wmsQStats.put(tmName, taskManager.get(tmName).getWmsQStats());
        }
        return wmsQStats;
    }

    public static Hashtable<String, ArrayList<Hashtable<String, String>>> getWmsQStats(String tmName) {
        if (taskManager.containsKey(tmName)) {
            return taskManager.get(tmName).getWmsQStats();
        }
        return null;
    }

    public static void initiateDrain() {
        for (String tmName : taskManager.keySet()) {
            taskManager.get(tmName).initiateDrain();
        }
    }

    public static void initiateDrain(String taskManagerName) {
        if (taskManager.containsKey(taskManagerName)) {
            taskManager.get(taskManagerName).initiateDrain();
        }
    }

    public static void stopDrain() {
        for (String tmName : taskManager.keySet()) {
            taskManager.get(tmName).stopDrain();
        }
    }

    public static void stopDrain(String taskManagerName) {
        if (taskManager.containsKey(taskManagerName)) {
            taskManager.get(taskManagerName).stopDrain();
        }
    }

    public static void stopAllEngines() {
        for (String tmName : taskManager.keySet()) {
            taskManager.get(tmName).stopAllEngines();
        }
    }

    public static ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>> getStats() {
        ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>> details = new ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>>();
        for (String tmName : taskManager.keySet()) {
            details.put(tmName, taskManager.get(tmName).getStats());
        }
        return details;
    }

    public static ConcurrentHashMap<String, AtomicLong> getStats(String tmName) {
        if (taskManager.containsKey(tmName)) {
            return taskManager.get(tmName).getStats();
        }
        return null;
    }

    public static void resetStats() {
        for (String tmName : taskManager.keySet()) {
            taskManager.get(tmName).resetStats();
        }
    }

    public static void resetStats(String tmName) {
        if (taskManager.containsKey(tmName)) {
            taskManager.get(tmName).resetStats();
        }
    }

    public static void enablePrdStats() {
        prdstatsenabled = true;
        for (String tmName : taskManager.keySet()) {
            taskManager.get(tmName).enablePrdStats();
        }
    }

    public static void enablePrdStats(String tmName) {
        if (taskManager.containsKey(tmName)) {
            taskManager.get(tmName).enablePrdStats();
        }
    }

    public static void disablePrdStats() {
        prdstatsenabled = false;
        for (String tmName : taskManager.keySet()) {
            taskManager.get(tmName).disablePrdStats();
        }
    }

    public static void disablePrdStats(String tmName) {
        if (taskManager.containsKey(tmName)) {
            taskManager.get(tmName).disablePrdStats();
        }
    }

    public static ConcurrentHashMap<String, ConcurrentHashMap<String, Hashtable<String, AtomicLong>>> getPrdStats() {
        ConcurrentHashMap<String, ConcurrentHashMap<String, Hashtable<String, AtomicLong>>> details = new ConcurrentHashMap<String, ConcurrentHashMap<String, Hashtable<String, AtomicLong>>>();
        for (String tmName : taskManager.keySet()) {
            details.put(tmName, taskManager.get(tmName).getPrdStats());
        }
        return details;
    }

    public static ConcurrentHashMap<String, Hashtable<String, AtomicLong>> getPrdStats(String tmName) {
        if (taskManager.containsKey(tmName)) {
            return taskManager.get(tmName).getPrdStats();
        }
        return null;
    }

    public static void resetPrdStats() {
        for (String tmName : taskManager.keySet()) {
            taskManager.get(tmName).resetPrdStats();
        }
    }

    public static void resetPrdStats(String tmName) {
        if (taskManager.containsKey(tmName)) {
            taskManager.get(tmName).resetPrdStats();
        }
    }

    public static Hashtable<String, Hashtable<String, Hashtable<String, String>>> getQueStats() {
        Hashtable<String, Hashtable<String, Hashtable<String, String>>> details = new Hashtable<String, Hashtable<String, Hashtable<String, String>>>();
        for (String tmName : taskManager.keySet()) {
            details.put(tmName, taskManager.get(tmName).getQueStats());
        }
        return details;
    }

    public static Hashtable<String, Hashtable<String, String>> getQueStats(String tmName) {
        if (taskManager.containsKey(tmName)) {
            return taskManager.get(tmName).getQueStats();
        }
        return null;
    }

    public static void clearQueStats() {
        for (String tmName : taskManager.keySet()) {
            taskManager.get(tmName).clearQueStats();
        }
    }

    public static void clearQueStats(String tmName) {
        if (taskManager.containsKey(tmName)) {
            taskManager.get(tmName).clearQueStats();
        }
    }

    public static boolean isDisabledEvent(String tmName, WmsEvent event) {
        if (taskManager.containsKey(tmName)) {
            return taskManager.get(tmName).isDisabledEvent(event);
        }
        return false;
    }

    public static String enableDebug(String tmName, String teName, int queueid, long duration) {
        if (seqTaskManager.containsKey(tmName)) {
            return seqTaskManager.get(tmName).enableDebug(teName, queueid, duration);
        }
        return "invalid taskenginename";
    }

    public static String disableDebug(String tmName, String teName, int queueid) {
        if (seqTaskManager.containsKey(tmName)) {
            return seqTaskManager.get(tmName).disableDebug(teName, queueid);
        }
        return "invalid taskenginename";
    }

    public static void setPoolSize(String tmName, int corePoolSize, int maximumPoolSize) {
        if (parallelTaskManager.containsKey(tmName)) {
            parallelTaskManager.get(tmName).setPoolSize(corePoolSize, maximumPoolSize);
        }
    }

    public static String drainQueue(String tmName, String teName, String queueID, int drainCount, boolean isIsolation) {
        if (taskManager.containsKey(tmName)) {
            return taskManager.get(tmName).drainQueue(teName, queueID, drainCount, isIsolation);
        }
        return "invalid taskmanager name";
    }

    public static String blockManager(String tmName) {
        if (taskManager.containsKey(tmName)) {
            return taskManager.get(tmName).blockAllEngines();
        }
        return "invalid taskmanager name";
    }

    public static String blockEngine(String tmName, String teName) {
        if (taskManager.containsKey(tmName)) {
            return taskManager.get(tmName).blockEngine(teName);
        }
        return "invalid taskmanager name";
    }

    public static String blockTask(String tmName, String teName, String task) {
        if (taskManager.containsKey(tmName)) {
            return taskManager.get(tmName).blockTask(teName, task);
        }
        return "invalid taskmanager name";
    }

    public static String dropTask(String tmName, String teName, String task, int count) {
        if (taskManager.containsKey(tmName)) {
            return taskManager.get(tmName).dropTask(teName, task, count);
        }
        return "invalid taskmanager name";
    }

    public static String blockRkey(String tmName, String teName, String task, String rkey) {
        if (tmName == null) {
            for (String name : taskManager.keySet()) {
                taskManager.get(name).blockRkey(rkey);
            }
            return " blocked rkey - " + rkey;
        }
        if (taskManager.containsKey(tmName)) {
            if (teName == null) {
                return taskManager.get(tmName).blockRkey(rkey);
            }
            if (task == null) {
                return taskManager.get(tmName).blockRkey(teName, rkey);
            }
            return taskManager.get(tmName).blockRkey(teName, task, rkey);
        }
        return "invalid taskmanager name";
    }

    public static String blockPrd(String tmName, String teName, String task, String prd) {
        if (tmName == null) {
            for (String name : taskManager.keySet()) {
                taskManager.get(name).blockPrd(prd);
            }
        } else if (taskManager.containsKey(tmName)) {
            if (teName == null) {
                return taskManager.get(tmName).blockPrd(prd);
            }
            if (task == null) {
                return taskManager.get(tmName).blockPrd(teName, prd);
            }
            return taskManager.get(tmName).blockPrd(teName, task, prd);
        }
        return "invalid taskmanager name";
    }

    public static String unblockManager(String tmName) {
        if (taskManager.containsKey(tmName)) {
            return taskManager.get(tmName).unblockAllEngines();
        }
        return "invalid taskmanager name";
    }

    public static String unblockEngine(String tmName, String teName) {
        if (taskManager.containsKey(tmName)) {
            return taskManager.get(tmName).unblockEngine(teName);
        }
        return "invalid taskmanager name";
    }

    public static String unblockTask(String tmName, String teName, String task) {
        if (taskManager.containsKey(tmName)) {
            return taskManager.get(tmName).unblockTask(teName, task);
        }
        return "invalid taskmanager name";
    }

    public static String unblockRkey(String tmName, String teName, String task, String rkey) {
        if (tmName == null) {
            for (String name : taskManager.keySet()) {
                taskManager.get(name).unblockRkey(rkey);
            }
        } else if (taskManager.containsKey(tmName)) {
            if (teName == null) {
                return taskManager.get(tmName).unblockRkey(rkey);
            }
            if (task == null) {
                return taskManager.get(tmName).unblockRkey(teName, rkey);
            }
            return taskManager.get(tmName).unblockRkey(teName, task, rkey);
        }
        return "invalid taskmanager name";
    }

    public static String unblockPrd(String tmName, String teName, String task, String prd) {
        if (tmName == null) {
            for (String name : taskManager.keySet()) {
                taskManager.get(name).unblockPrd(prd);
            }
        } else if (taskManager.containsKey(tmName)) {
            if (teName == null) {
                return taskManager.get(tmName).unblockPrd(prd);
            }
            if (task == null) {
                return taskManager.get(tmName).unblockPrd(teName, prd);
            }
            return taskManager.get(tmName).unblockPrd(teName, task, prd);
        }
        return "invalid taskmanager name";
    }

    public static String isolateEngine(String tmName, String teName) {
        if (parallelTaskManager.containsKey(tmName)) {
            return parallelTaskManager.get(tmName).isolateEngine(teName);
        }
        return "invalid taskmanager name";
    }

    public static String isolateTask(String tmName, String teName, String task) {
        if (parallelTaskManager.containsKey(tmName)) {
            return parallelTaskManager.get(tmName).isolateTask(teName, task);
        }
        return "invalid taskmanager name";
    }

    public static String isolatePrd(String tmName, String prd) {
        if (parallelTaskManager.containsKey(tmName)) {
            return parallelTaskManager.get(tmName).isolatePrd(prd);
        }
        return "invalid taskmanager name";
    }

    public static String isolatePrd(String tmName, String teName, String prd) {
        if (parallelTaskManager.containsKey(tmName)) {
            return parallelTaskManager.get(tmName).isolatePrd(teName, prd);
        }
        return "invalid taskmanager name";
    }

    public static String isolateRkey(String tmName, String rkey) {
        if (parallelTaskManager.containsKey(tmName)) {
            return parallelTaskManager.get(tmName).isolateRkey(rkey);
        }
        return "invalid taskmanager name";
    }

    public static String isolateRkey(String tmName, String teName, String rkey) {
        if (parallelTaskManager.containsKey(tmName)) {
            return parallelTaskManager.get(tmName).isolateRkey(teName, rkey);
        }
        return "invalid taskmanager name";
    }

    public static String deIsolateEngine(String tmName, String teName) {
        if (parallelTaskManager.containsKey(tmName)) {
            return parallelTaskManager.get(tmName).deIsolateEngine(teName);
        }
        return "invalid taskmanager name";
    }

    public static String deIsolateTask(String tmName, String teName, String task) {
        if (parallelTaskManager.containsKey(tmName)) {
            return parallelTaskManager.get(tmName).deIsolateTask(teName, task);
        }
        return "invalid taskmanager name";
    }

    public static String deIsolatePrd(String tmName, String prd) {
        if (parallelTaskManager.containsKey(tmName)) {
            return parallelTaskManager.get(tmName).deIsolatePrd(prd);
        }
        return "invalid taskmanager name";
    }

    public static String deIsolatePrd(String tmName, String teName, String prd) {
        if (parallelTaskManager.containsKey(tmName)) {
            return parallelTaskManager.get(tmName).deIsolatePrd(teName, prd);
        }
        return "invalid taskmanager name";
    }

    public static String deIsolateRkey(String tmName, String rkey) {
        if (parallelTaskManager.containsKey(tmName)) {
            return parallelTaskManager.get(tmName).deIsolateRkey(rkey);
        }
        return "invalid taskmanager name";
    }

    public static String deIsolateRkey(String tmName, String teName, String rkey) {
        if (parallelTaskManager.containsKey(tmName)) {
            return parallelTaskManager.get(tmName).deIsolateRkey(teName, rkey);
        }
        return "invalid taskmanager name";
    }

    public static String setIsolationThreadsCount(String tmName, int count) {
        if (parallelTaskManager.containsKey(tmName)) {
            parallelTaskManager.get(tmName).setIsolationThreadsCount(count);
            return "Isolation Thread Count for " + tmName + " = " + count;
        }
        return "invalid taskmanager name";
    }

    public static HashMap<String, HashMap<String, ConcurrentHashMap<String, Object>>> getBlockedStatus() {
        HashMap<String, HashMap<String, ConcurrentHashMap<String, Object>>> result = new HashMap<String, HashMap<String, ConcurrentHashMap<String, Object>>>();
        for (String tmName : taskManager.keySet()) {
            HashMap<String, ConcurrentHashMap<String, Object>> map = taskManager.get(tmName).getBlockedStatus();
            if (map.isEmpty()) continue;
            result.put(tmName, map);
        }
        return result;
    }

    public static HashMap<String, HashMap<String, HashMap<String, ConcurrentHashMap<String, AtomicLong>>>> getParallelIsolationStatus() {
        HashMap<String, HashMap<String, HashMap<String, ConcurrentHashMap<String, AtomicLong>>>> result = new HashMap<String, HashMap<String, HashMap<String, ConcurrentHashMap<String, AtomicLong>>>>();
        for (String tmName : parallelTaskManager.keySet()) {
            HashMap<String, HashMap<String, ConcurrentHashMap<String, AtomicLong>>> map = parallelTaskManager.get(tmName).getIsolationStatus();
            if (map.isEmpty()) continue;
            result.put(tmName, map);
        }
        return result;
    }

    public static Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, String>>>> getSequentialIsolationQueueStats() {
        Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, String>>>> returnHash = new Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, String>>>>();
        for (String tmName : seqTaskManager.keySet()) {
            returnHash.put(tmName, seqTaskManager.get(tmName).getIsolationQueueStats());
        }
        return returnHash;
    }

    public static void setIgnoreTasks(String tmName, Hashtable properties) {
        if (taskManager.containsKey(tmName)) {
            taskManager.get(tmName).setIgnoreTasks(properties);
        }
    }

    public static boolean isolate(String tmName, String teName, String seqID) {
        if (seqTaskManager.containsKey(tmName)) {
            return seqTaskManager.get(tmName).isolate(teName, seqID);
        }
        return false;
    }

    public static boolean isolate(String tmName, String seqID) {
        if (seqTaskManager.containsKey(tmName)) {
            seqTaskManager.get(tmName).isolate(seqID);
            return true;
        }
        return false;
    }

    public static boolean isolate(String seqID) {
        for (SequentialTaskManager manager : seqTaskManager.values()) {
            manager.isolate(seqID);
        }
        return true;
    }

    public static boolean deisolate(String tmName, String teName, String seqID) {
        if (seqTaskManager.containsKey(tmName)) {
            return seqTaskManager.get(tmName).deisolate(teName, seqID);
        }
        return false;
    }

    public static boolean deisolate(String tmName, String seqID) {
        if (seqTaskManager.containsKey(tmName)) {
            seqTaskManager.get(tmName).deisolate(seqID);
            return true;
        }
        return false;
    }

    public static boolean deisolate(String seqID) {
        for (SequentialTaskManager manager : seqTaskManager.values()) {
            manager.deisolate(seqID);
        }
        return true;
    }

    public static HashMap<String, HashMap<String, HashMap<String, ConcurrentHashMap<String, AtomicLong>>>> getIsolatedSeqIDs() {
        HashMap<String, HashMap<String, HashMap<String, ConcurrentHashMap<String, AtomicLong>>>> map = new HashMap<String, HashMap<String, HashMap<String, ConcurrentHashMap<String, AtomicLong>>>>();
        for (SequentialTaskManager manager : seqTaskManager.values()) {
            map.put(manager.getName(), manager.getIsolatedSeqIDs());
        }
        return map;
    }

    public static boolean shutdown() {
        return TaskExecutorService.shutdown(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shutdown(boolean isAR) {
        if (isShutDownInProgress) {
            logger.info("TES_ERR --> shutdown or drain already in progress");
            return false;
        }
        if (isInitialized) {
            boolean result = true;
            try {
                shutDownLock.lock();
                logger.info("TES_SD --> Shutdown TES started");
                isShutDownInProgress = true;
                if (isAR) {
                    isARInProgress = true;
                    for (String tmName : taskManager.keySet()) {
                        if (!taskManager.get(tmName).isAREnabled()) continue;
                        managerCountForShutdown.incrementAndGet();
                        taskManager.get(tmName).shutdown();
                    }
                } else {
                    for (String tmName : taskManager.keySet()) {
                        taskManager.get(tmName).shutdown();
                        managerCountForShutdown.incrementAndGet();
                    }
                }
                if (managerCountForShutdown.get() > 0L) {
                    result = shutDownCompleted.await(120000L, TimeUnit.MILLISECONDS);
                }
                if (!result) {
                    for (String tmName : taskManager.keySet()) {
                        int threads = taskManager.get(tmName).getActiveThreadCount();
                        if (threads == 0) continue;
                        logger.info("TES_SD --> TaskManager - " + tmName + " pending count " + threads);
                    }
                    logger.info("TES_SD --> ShutDown failed ");
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "TES_SD --> Exception while TES shutdown", e);
            }
            finally {
                shutDownLock.unlock();
            }
            return result;
        }
        logger.info("TES_SD --> is not initialized");
        return false;
    }

    protected static void shutdownCompleted(String tesVersion, String tmName) {
        if (version.equals(tesVersion)) {
            if (managerCountForShutdown.decrementAndGet() == 0L) {
                isInitialized = false;
                isShutDownInProgress = false;
                isARInProgress = false;
                logger.info("TES_SD --> Shutdown completed successfully");
                try {
                    shutDownLock.lock();
                    shutDownCompleted.signal();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "TES_SD --> Exception while TES shutdown", e);
                }
                finally {
                    shutDownLock.unlock();
                }
            }
            logger.info("TES_SD --> TaskManager - " + tmName + " is shutdown remaing managers count : " + managerCountForShutdown.get());
        } else {
            logger.info("TES_SD --> shutdownCompleted invalid versionid - " + tesVersion + " current version -" + version);
        }
    }

    public static boolean drain() {
        if (isShutDownInProgress) {
            logger.info("TES_SD --> shutdown or drain already in progress");
            return false;
        }
        if (isInitialized) {
            long counter = 0L;
            long maxLimit = 1200L;
            while (counter++ < maxLimit) {
                int threads;
                int size;
                int totalSize = 0;
                int totalThreads = 0;
                for (String tmName : taskManager.keySet()) {
                    size = taskManager.get(tmName).getTotalQueueSize();
                    threads = taskManager.get(tmName).getActiveThreadCount();
                    if (size <= 0 && threads <= 0) continue;
                    if (counter % 50L == 0L) {
                        logger.info("TES_SD --> Drain Manager name = " + tmName + " pending count = " + size + " active thread count = " + threads);
                    }
                    totalSize += size;
                    totalThreads += threads;
                }
                if (totalSize <= 0 && totalThreads <= 0) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        logger.fine("TES_SD --> InterruptedException in drain");
                    }
                    totalSize = 0;
                    totalThreads = 0;
                    for (String tmName : taskManager.keySet()) {
                        size = taskManager.get(tmName).getTotalQueueSize();
                        threads = taskManager.get(tmName).getActiveThreadCount();
                        if (size <= 0 && threads <= 0) continue;
                        logger.info("TES_SD --> Drain Manager name = " + tmName + " pending count = " + size + " active thread count = " + threads);
                        totalSize += size;
                        totalThreads += threads;
                    }
                    if (totalSize == 0 && totalThreads == 0) break;
                }
                logger.info("TES_SD --> Drain Total pending count = " + totalSize + " active thread count = " + totalThreads);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    logger.fine("TES_SD --> InterruptedException in drain");
                }
            }
            if (counter >= maxLimit) {
                logger.info("TES_SD --> Drain failed");
            } else {
                logger.info("TES_SD --> Drain completed successfully");
            }
            return true;
        }
        logger.info("TES_SD --> is not initialized");
        return false;
    }

    protected static void updateShutdownStatus(String tmname, int percentage) {
        shutdownStatus.put(tmname, percentage);
    }

    protected static ArrayList<File> getArTransferFiles() {
        ArrayList<File> list = new ArrayList<File>();
        for (String tmName : seqTaskManager.keySet()) {
            list.addAll(seqTaskManager.get(tmName).getArTransferFiles());
        }
        return list;
    }

    public static HashMap<String, ConcurrentHashMap<String, Long>> resetAndGetMaxThreadAllotmentDetails() {
        HashMap<String, ConcurrentHashMap<String, Long>> maxThreadAllotmentDetails = new HashMap<String, ConcurrentHashMap<String, Long>>();
        for (String tmName : parallelTaskManager.keySet()) {
            maxThreadAllotmentDetails.put(tmName, parallelTaskManager.get(tmName).resetAndGetMaxThreadAllotmentDetails());
        }
        for (String tmName : seqTaskManager.keySet()) {
            maxThreadAllotmentDetails.put(tmName, seqTaskManager.get(tmName).getMaxThreadStats());
        }
        return maxThreadAllotmentDetails;
    }

    public static HashMap<String, ConcurrentHashMap<String, Long>> getMaxThreadAllotmentDetails() {
        HashMap<String, ConcurrentHashMap<String, Long>> maxThreadAllotmentDetails = new HashMap<String, ConcurrentHashMap<String, Long>>();
        for (String tmName : parallelTaskManager.keySet()) {
            maxThreadAllotmentDetails.put(tmName, parallelTaskManager.get(tmName).getMaxThreadAllotmentDetails());
        }
        for (String tmName : seqTaskManager.keySet()) {
            maxThreadAllotmentDetails.put(tmName, seqTaskManager.get(tmName).getMaxThreadStats());
        }
        return maxThreadAllotmentDetails;
    }

    public static HashMap<String, ConcurrentHashMap<String, AtomicLong>> getCurrentThreadAllotmentDetails() {
        HashMap<String, ConcurrentHashMap<String, AtomicLong>> currentThreadAllotmentDetails = new HashMap<String, ConcurrentHashMap<String, AtomicLong>>();
        for (String tmName : parallelTaskManager.keySet()) {
            currentThreadAllotmentDetails.put(tmName, parallelTaskManager.get(tmName).getCurrentThreadAllotmentDetails());
        }
        for (String tmName : seqTaskManager.keySet()) {
            currentThreadAllotmentDetails.put(tmName, seqTaskManager.get(tmName).getCurrentThreadStats());
        }
        return currentThreadAllotmentDetails;
    }

    public static HashMap<String, HashMap<String, HashMap<String, Long>>> getIsolationDetails() {
        HashMap<String, HashMap<String, HashMap<String, Long>>> maxThreadAllotmentDetails = new HashMap<String, HashMap<String, HashMap<String, Long>>>();
        for (String tmName : seqTaskManager.keySet()) {
            maxThreadAllotmentDetails.put(tmName, seqTaskManager.get(tmName).getIsolationThreadStats());
        }
        return maxThreadAllotmentDetails;
    }

    public static HashMap<String, Integer> getCurrentThreadCount() {
        HashMap<String, Integer> currentThreadDetails = new HashMap<String, Integer>();
        for (String tmName : parallelTaskManager.keySet()) {
            currentThreadDetails.put(tmName, parallelTaskManager.get(tmName).getCurrentThreadCount());
        }
        for (String tmName : seqTaskManager.keySet()) {
            currentThreadDetails.put(tmName, seqTaskManager.get(tmName).getCurrentThreadCount());
        }
        return currentThreadDetails;
    }

    public static HashMap<String, Integer> getPoolSize() {
        HashMap<String, Integer> poolSizeMap = new HashMap<String, Integer>();
        for (String tmName : taskManager.keySet()) {
            poolSizeMap.put(tmName, taskManager.get(tmName).getPoolSize());
        }
        return poolSizeMap;
    }

    public static int getTotalPoolSize() {
        int totalPoolSize = 0;
        for (String tmName : taskManager.keySet()) {
            totalPoolSize += taskManager.get(tmName).getPoolSize();
        }
        return totalPoolSize;
    }

    public static int getPoolSize(String tmName) {
        return taskManager.get(tmName).getPoolSize();
    }

    public static Hashtable<String, Object> startThreads(String tmName, String teName, String threadID) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        if (tmName != null) {
            if (seqTaskManager.containsKey(tmName)) {
                table.put(tmName, seqTaskManager.get(tmName).startThreads(teName, threadID));
            } else {
                table.put(tmName, "invalid taskenginename");
            }
        } else {
            for (String tm : seqTaskManager.keySet()) {
                table.put(tmName, seqTaskManager.get(tmName).startThreads(teName, threadID));
            }
        }
        return table;
    }

    public static Hashtable<String, Object> getThreadStatus(String tmName, String teName) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        if (tmName != null) {
            if (seqTaskManager.containsKey(tmName)) {
                table.put(tmName, seqTaskManager.get(tmName).getThreadStatus(teName));
            } else {
                table.put(tmName, "invalid taskenginename");
            }
        } else {
            for (String tm : seqTaskManager.keySet()) {
                table.put(tmName, seqTaskManager.get(tmName).getThreadStatus(teName));
            }
        }
        return table;
    }

    public static LinkedHashMap<String, Object> getStatus() {
        LinkedHashMap<String, Object> taskManagerStatus = new LinkedHashMap<String, Object>();
        if (isInitialized) {
            taskManagerStatus.put("Number of Task Managers Running", taskManager.size());
            for (Map.Entry<String, AbsTaskManager> entry : taskManager.entrySet()) {
                taskManagerStatus.put(entry.getKey(), entry.getValue().getStatus());
            }
        } else {
            taskManagerStatus.put("Number of Task Managers Running", 0);
        }
        return taskManagerStatus;
    }

    public static LinkedHashMap<String, Object> getDetailedStatus() {
        LinkedHashMap<String, Object> taskManagerStatus = new LinkedHashMap<String, Object>();
        if (isInitialized) {
            for (Map.Entry<String, AbsTaskManager> entry : taskManager.entrySet()) {
                taskManagerStatus.put(entry.getKey(), entry.getValue().getDetailedStatus());
            }
        } else {
            taskManagerStatus.put("Number of Task Managers Running", 0);
        }
        return taskManagerStatus;
    }

    public static LinkedHashMap<String, Object> getDetailedStatus(String tmName) {
        if (!taskManager.containsKey(tmName)) {
            LinkedHashMap<String, Object> errorStatus = new LinkedHashMap<String, Object>();
            errorStatus.put("Error", "Invalid Task Manager Name");
            return errorStatus;
        }
        return taskManager.get(tmName).getDetailedStatus();
    }

    protected static Map<String, String> getShutdownProgress(boolean isDrain) {
        HashMap<String, String> progress = new HashMap<String, String>();
        if (isShutDownInProgress) {
            if (isDrain) {
                int count = 0;
                int queueSize = 0;
                int threads = 0;
                for (String tmName : taskManager.keySet()) {
                    queueSize += taskManager.get(tmName).getTotalQueueSize();
                    threads += taskManager.get(tmName).getActiveThreadCount();
                    if (taskManager.get(tmName).getTotalQueueSize() != 0 || taskManager.get(tmName).getActiveThreadCount() != 0) continue;
                    ++count;
                }
                try {
                    progress.put("Progress", Integer.toString(count / taskManager.size() * 100));
                    progress.put("Title", "TES Drain in progress pending events - " + (threads + queueSize));
                }
                catch (Exception e) {
                    progress.put("Progress", "100");
                    progress.put("Title", "TES Drain in progress ");
                }
            } else {
                int total = 0;
                for (Map.Entry<String, Integer> entry : shutdownStatus.entrySet()) {
                    total += entry.getValue().intValue();
                }
                int totalPoolSize = 0;
                int currentPoolSize = 0;
                if (isARInProgress) {
                    for (String tmName : taskManager.keySet()) {
                        if (!taskManager.get(tmName).isAREnabled()) continue;
                        totalPoolSize += taskManager.get(tmName).getPoolSize();
                        currentPoolSize += taskManager.get(tmName).getCurrentThreadCount();
                    }
                } else {
                    for (String tmName : taskManager.keySet()) {
                        totalPoolSize += taskManager.get(tmName).getPoolSize();
                        currentPoolSize += taskManager.get(tmName).getCurrentThreadCount();
                    }
                }
                try {
                    progress.put("Progress", Integer.toString(total / shutdownStatus.size() + 75 * (totalPoolSize - currentPoolSize) / totalPoolSize));
                    progress.put("Title", totalPoolSize - currentPoolSize + "/" + totalPoolSize + " threads Shutdown ");
                }
                catch (Exception e) {
                    progress.put("Progress", "0");
                    progress.put("Title", "TES Shutdown in progress");
                }
            }
        }
        return progress;
    }

    protected static Hashtable<String, Object> getShutdownStatus(boolean isDrain) {
        Hashtable<String, Object> status = new Hashtable<String, Object>();
        Hashtable<String, Integer> shutDownStatus = new Hashtable<String, Integer>();
        for (String tmName : taskManager.keySet()) {
            int totalPoolSize = taskManager.get(tmName).getPoolSize();
            int currentPoolSize = taskManager.get(tmName).getCurrentThreadCount();
            shutDownStatus.put(tmName, (totalPoolSize - currentPoolSize) / totalPoolSize);
        }
        if (isShutDownInProgress) {
            if (isDrain) {
                for (String tmName : taskManager.keySet()) {
                    status.put(tmName, taskManager.get(tmName).getTotalQueueSize());
                }
            } else {
                status.put("TaskManagers", shutdownStatus);
            }
            logger.info("TES_SD --> ShutdownStatus " + shutdownStatus);
        }
        return status;
    }

    protected static Hashtable<String, Object> getDetailedShutdownStatus(boolean isDrain) {
        Hashtable<String, Object> status = new Hashtable<String, Object>();
        if (isShutDownInProgress) {
            Hashtable table = new Hashtable();
            if (isDrain) {
                for (String tmName : taskManager.keySet()) {
                    Hashtable<String, Integer> tmdetails = new Hashtable<String, Integer>();
                    tmdetails.put("queue size", taskManager.get(tmName).getTotalQueueSize());
                    tmdetails.put("active threads", taskManager.get(tmName).getActiveThreadCount());
                    table.put(tmName, tmdetails);
                }
            } else if (isARInProgress) {
                for (String tmName : taskManager.keySet()) {
                    if (!taskManager.get(tmName).isAREnabled()) continue;
                    table.put(tmName, taskManager.get(tmName).getShutdownStatus());
                }
            } else {
                for (String tmName : taskManager.keySet()) {
                    table.put(tmName, taskManager.get(tmName).getShutdownStatus());
                }
            }
            status.put("TaskManagers", table);
            logger.info("TES_SD --> ShutdownStatus " + shutdownStatus);
        }
        return status;
    }

    static {
        prdstatsenabled = true;
        isInitialized = false;
        version = "";
        isShutDownInProgress = false;
        isARInProgress = false;
        shutDownLock = new ReentrantLock();
        shutDownCompleted = shutDownLock.newCondition();
        shutdownStatus = new Hashtable();
    }
}

