/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.backup.wdb;

import com.adventnet.wms.common.HttpDataWraper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;

public class BackupObject {
    private Hashtable<String, String> backupData = new Hashtable();
    private Hashtable<String, String> addlInfo = new Hashtable();
    private ArrayList<String> serviceList = new ArrayList();
    private static final long RECORD_VERSION = 1L;
    private static final String SERVERTYPE = "servertype";
    private static final String STORAGE = "storage";
    private static final String FOLDERNAME = "foldername";
    private static final String ENTITY_ID = "entityid";
    private static final String REMOTE_FILEPATH = "remotefilepath";
    private static final String BACKUP_TYPE = "backuptype";
    private static final String LAST_MODIFIED_TIME = "lastmodifiedtime";
    private static final String SERVICE_NAME = "servicename";
    private static final String REMOTE_IP = "remoteip";
    private static final String ADDL_INFO = "addlinfo";

    public long getRecordVersion() {
        return 1L;
    }

    public BackupObject(String serverType, String storage, String folderName, String entityID, String remoteFilePath, int backupType, long lastModifiedTime, String remoteIP) {
        this(serverType, storage, folderName, entityID, remoteFilePath, backupType, lastModifiedTime, remoteIP, null);
    }

    public BackupObject(String serverType, String storage, String folderName, String entityID, String remoteFilePath, int backupType, long lastModifiedTime, String remoteIP, Hashtable<String, String> addlInfo) {
        this(serverType, storage, folderName, entityID, remoteFilePath, backupType, lastModifiedTime, remoteIP, addlInfo, null);
    }

    public BackupObject(String serverType, String storage, String folderName, String entityID, String remoteFilePath, int backupType, long lastModifiedTime, String remoteIP, Hashtable<String, String> addlInfo, ArrayList<String> serviceList) {
        if (serviceList == null) {
            serviceList = new ArrayList();
            serviceList.add("DR");
        }
        if (serverType != null && entityID != null && remoteFilePath != null && remoteIP != null) {
            this.backupData.put(SERVERTYPE, serverType);
            this.backupData.put(STORAGE, storage);
            this.backupData.put(FOLDERNAME, folderName);
            this.backupData.put(ENTITY_ID, entityID);
            this.backupData.put(REMOTE_FILEPATH, remoteFilePath);
            this.backupData.put(BACKUP_TYPE, "" + backupType);
            this.backupData.put(LAST_MODIFIED_TIME, "" + lastModifiedTime);
            this.backupData.put(REMOTE_IP, remoteIP);
            this.backupData.put(SERVICE_NAME, HttpDataWraper.getString(serviceList));
            if (addlInfo != null) {
                this.addlInfo.putAll(addlInfo);
            }
            if (this.addlInfo.get("ctime") == null) {
                this.addlInfo.put("ctime", Long.toString(System.currentTimeMillis()));
            }
            this.backupData.put(ADDL_INFO, HttpDataWraper.getString(this.addlInfo));
        }
    }

    public BackupObject(String data) {
        if (data == "" || data == null) {
            data = "{}";
        }
        Hashtable stringData = (Hashtable)HttpDataWraper.getObject((String)data);
        String serverType = (String)stringData.get(SERVERTYPE);
        String storage = (String)stringData.get(STORAGE);
        String folderName = (String)stringData.get(FOLDERNAME);
        String entityID = (String)stringData.get(ENTITY_ID);
        String remoteFilePath = (String)stringData.get(REMOTE_FILEPATH);
        String remoteIP = (String)stringData.get(REMOTE_IP);
        String backupType = (String)stringData.get(BACKUP_TYPE);
        String lastModifiedTime = (String)stringData.get(LAST_MODIFIED_TIME);
        String serviceName = (String)stringData.get(SERVICE_NAME);
        String addlData = (String)stringData.get(ADDL_INFO);
        if (serverType != null && entityID != null && remoteFilePath != null && remoteIP != null && backupType != null && lastModifiedTime != null && serviceName != null && addlData != null) {
            this.backupData.put(SERVERTYPE, serverType);
            this.backupData.put(STORAGE, storage);
            this.backupData.put(FOLDERNAME, folderName);
            this.backupData.put(ENTITY_ID, entityID);
            this.backupData.put(REMOTE_FILEPATH, remoteFilePath);
            this.backupData.put(BACKUP_TYPE, backupType);
            this.backupData.put(LAST_MODIFIED_TIME, lastModifiedTime);
            this.backupData.put(REMOTE_IP, remoteIP);
            this.backupData.put(SERVICE_NAME, serviceName);
            this.backupData.put(ADDL_INFO, addlData);
        }
    }

    public ArrayList<String> getServiceList() {
        if (this.backupData.get(SERVICE_NAME) != null) {
            this.serviceList = (ArrayList)HttpDataWraper.getObject((String)this.backupData.get(SERVICE_NAME));
        }
        return this.serviceList;
    }

    public void setServiceList(ArrayList<String> data) {
        HashSet<String> set = new HashSet<String>(this.getServiceList());
        set.addAll(data);
        this.serviceList = new ArrayList<String>(set);
        this.backupData.put(SERVICE_NAME, HttpDataWraper.getString(this.serviceList));
    }

    public void addService(String data) {
        this.serviceList = this.getServiceList();
        if (!this.serviceList.contains(data)) {
            this.serviceList.add(data);
            this.backupData.put(SERVICE_NAME, HttpDataWraper.getString(this.serviceList));
        }
    }

    public String getBkpStringData() {
        return HttpDataWraper.getString(this.backupData);
    }

    public Hashtable<String, String> getBackupData() {
        return this.backupData;
    }

    public Hashtable<String, String> getAddlInfo() {
        if (this.backupData.get(ADDL_INFO) != null) {
            this.addlInfo = (Hashtable)HttpDataWraper.getObject((String)this.backupData.get(ADDL_INFO));
        }
        return this.addlInfo;
    }

    public String getAddlInfo(String key) {
        if (this.backupData.get(ADDL_INFO) != null) {
            this.addlInfo = (Hashtable)HttpDataWraper.getObject((String)this.backupData.get(ADDL_INFO));
        }
        return this.addlInfo.get(key);
    }

    public void addAddlInfo(String key, String value) {
        this.addlInfo = this.getAddlInfo();
        this.addlInfo.put(key, value);
        this.backupData.put(ADDL_INFO, HttpDataWraper.getString(this.addlInfo));
    }

    public void removeAddlInfo(String key) {
        this.addlInfo = this.getAddlInfo();
        this.addlInfo.remove(key);
        this.backupData.put(ADDL_INFO, HttpDataWraper.getString(this.addlInfo));
    }

    public void clearAddlInfo() {
        this.addlInfo = this.getAddlInfo();
        this.addlInfo.clear();
        this.backupData.put(ADDL_INFO, HttpDataWraper.getString(this.addlInfo));
    }

    public void addAllAddlInfo(Hashtable<String, String> addlInfo) {
        this.addlInfo = this.getAddlInfo();
        this.addlInfo.putAll(addlInfo);
        this.backupData.put(ADDL_INFO, HttpDataWraper.getString(addlInfo));
    }

    public String getServerType() {
        return this.backupData.get(SERVERTYPE);
    }

    public String getStorage() {
        return this.backupData.get(STORAGE);
    }

    public String getFolderName() {
        return this.backupData.get(FOLDERNAME);
    }

    public String getEntityID() {
        return this.backupData.get(ENTITY_ID);
    }

    public String getRemoteFilepath() {
        return this.backupData.get(REMOTE_FILEPATH);
    }

    public int getBackupType() {
        return this.backupData.get(BACKUP_TYPE) != null ? Integer.parseInt(this.backupData.get(BACKUP_TYPE)) : -1;
    }

    public long getLastModifiedTime() {
        return this.backupData.get(LAST_MODIFIED_TIME) != null ? Long.parseLong(this.backupData.get(LAST_MODIFIED_TIME)) : -1L;
    }

    public String getRemoteIP() {
        return this.backupData.get(REMOTE_IP);
    }
}

