/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.backup;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NBMObject {
    private static final Logger LOGGER = Logger.getLogger(NBMObject.class.getName());
    private List<String> bsSeedsList;
    private Map<String, List<String>> nodeNBMMap;

    public NBMObject(Map<String, List<String>> nbmObjectMap) {
        try {
            LOGGER.info("NS --> \"NBMObject - Constructor\" -----> started");
            this.bsSeedsList = nbmObjectMap.remove("bo");
            if (this.bsSeedsList == null) {
                LOGGER.severe("NS --> \"NBMObject - Constructor\" -----> bkpOrder not present in map");
            }
            this.nodeNBMMap = nbmObjectMap;
            LOGGER.info("NS --> \"NBMObject - Constructor\" -----> successfully created");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS --> Error in \"NBMObject - Constructor\" with map : " + nbmObjectMap, e);
        }
    }

    public List<String> getServers() {
        String machineIP = null;
        try {
            machineIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOGGER.log(Level.SEVERE, "NS --> \"NBMObject - getServers()\" ----> Error in etLocalHost().getHostAddress()");
        }
        return this.getServers(machineIP);
    }

    public List<String> getServers(String ip) {
        if (ip == null) {
            LOGGER.log(Level.SEVERE, "NS --> \"NBMObject - getServers(ip)\" ----> IP is null");
            return null;
        }
        if (this.nodeNBMMap != null) {
            return this.nodeNBMMap.get(ip);
        }
        LOGGER.log(Level.SEVERE, "NS --> \"NBMObject - getServers(ip)\" ----> nodeNBMMap is NULL for ip=" + ip);
        return null;
    }

    public String getNBMObjectServer() {
        String machineIP = null;
        try {
            machineIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOGGER.log(Level.SEVERE, "NS --> \"NBMObject - getNBMObjectServer()\" ----> Error in etLocalHost().getHostAddress()");
        }
        return this.getNBMObjectServer(machineIP);
    }

    public String getNBMObjectServer(String ip) {
        if (ip == null) {
            LOGGER.log(Level.SEVERE, "NS --> \"NBMObject - getNBMObjectServer(ip)\" ----> IP is null");
            return null;
        }
        if (this.nodeNBMMap != null) {
            for (Map.Entry<String, List<String>> entry : this.nodeNBMMap.entrySet()) {
                if (!entry.getValue().contains(ip)) continue;
                return entry.getKey();
            }
            return null;
        }
        LOGGER.log(Level.SEVERE, "NS --> \"NBMObject - getNBMObjectServer(ip)\" ----> nodeNBMMap is NULL for ip=" + ip);
        return null;
    }

    public List<String> getSeedsList() {
        return this.bsSeedsList;
    }
}

