/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.backup;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.common.exception.WMSException;
import com.adventnet.wms.servercommon.rocksdb.RocksDBManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BackupDB {
    private static final Logger LOGGER = Logger.getLogger(BackupDB.class.getName());
    private static final String FILETIMEMAPPER_COLUMNFAMILY = "filetimemapper";
    private static final String BACKUP_COLUMNFAMILY = "backup";

    public static void initialize() {
        new Thread(new TimeFileMapper.ResourceCleaner()).start();
    }

    public static final class ServerTimeBinding {
        private static final String PREFIX = "server:";

        public static void put(String serverip, long time) throws WMSException {
            RocksDBManager.put(BackupDB.BACKUP_COLUMNFAMILY, PREFIX + serverip, "" + time);
        }

        public static long get(String serverip) throws WMSException {
            try {
                String time = (String)RocksDBManager.get(BackupDB.BACKUP_COLUMNFAMILY, PREFIX + serverip);
                return Long.parseLong(time);
            }
            catch (WMSException wmse) {
                LOGGER.log(Level.SEVERE, "Error while getting server time binding", wmse);
                return -1L;
            }
        }
    }

    public static final class FileRecordBinding {
        private static final String PREFIX = "filerecord:";

        public static void put(String fileName, String key, String value) throws WMSException {
            Hashtable<String, String> record = FileRecordBinding.getFileRecord(fileName);
            if (record == null) {
                record = new Hashtable<String, String>();
            }
            record.put(key, value);
            RocksDBManager.put(BackupDB.BACKUP_COLUMNFAMILY, PREFIX + key, HttpDataWraper.getString(record));
        }

        public static void put(String fileName, String data) throws WMSException {
            Hashtable record = FileRecordBinding.getFileRecord(fileName);
            if (record == null) {
                record = new Hashtable();
            }
            Hashtable dataAsHashtable = (Hashtable)HttpDataWraper.getObject((String)data);
            Set keySet = dataAsHashtable.keySet();
            for (String key : keySet) {
                record.put(key, dataAsHashtable.get(key));
            }
            RocksDBManager.put(BackupDB.BACKUP_COLUMNFAMILY, PREFIX + fileName, HttpDataWraper.getString(record));
        }

        public static Hashtable getFileRecord(String fileName) throws WMSException {
            String data = (String)RocksDBManager.get(BackupDB.BACKUP_COLUMNFAMILY, PREFIX + fileName);
            return data == null ? null : (Hashtable)HttpDataWraper.getObject((String)data);
        }
    }

    public static final class KeyFileBinding {
        private static final String PREFIX = "key:";

        public static void put(String key, String fileName) throws WMSException {
            ArrayList<String> fileList;
            String value = (String)RocksDBManager.get(BackupDB.BACKUP_COLUMNFAMILY, PREFIX + key);
            if (value != null) {
                fileList = (ArrayList<String>)HttpDataWraper.getObject((String)value);
                fileList.add(fileName);
            } else {
                fileList = new ArrayList<String>();
                fileList.add(fileName);
            }
            RocksDBManager.put(BackupDB.BACKUP_COLUMNFAMILY, PREFIX + key, HttpDataWraper.getString(fileList));
        }

        public static ArrayList<String> get(String key) throws WMSException {
            String value = (String)RocksDBManager.get(BackupDB.BACKUP_COLUMNFAMILY, PREFIX + key);
            return value != null ? (ArrayList)HttpDataWraper.getObject((String)value) : null;
        }
    }

    public static final class TimeFileMapper {
        public static void put(long time, Path filePath) throws WMSException {
            RocksDBManager.put(BackupDB.FILETIMEMAPPER_COLUMNFAMILY, "" + time, "" + filePath.toString());
        }

        public static Hashtable getFilesToBeBackedup(long time, int count) {
            return new Hashtable();
        }

        public static class ResourceCleaner
        implements Runnable {
            @Override
            public void run() {
            }
        }
    }
}

