/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.backup;

import com.adventnet.wms.common.HttpConnection;
import com.adventnet.wms.servercommon.components.backup.BackupClientDB;
import com.adventnet.wms.servercommon.components.backup.BackupConfManager;
import com.adventnet.wms.servercommon.components.backup.wdb.BackupObject;
import com.adventnet.wms.servercommon.components.net.WCPDispatcher;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.rocksdb.RocksDBManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BackupClient {
    private static final Logger LOGGER = Logger.getLogger(BackupClient.class.getName());
    private static String serverip = null;
    private static final String BACKUP_CONNPOOL = "bks";
    private static final int RESTORE_READ_TIMEOUT = 5000;
    private static final int RESTORE_CONNECT_TIMEOUT = 5000;
    private static boolean shutdown = false;
    private static BackupClient client = null;

    private BackupClient() {
        try {
            WCPDispatcher.createWCPConnPool(BACKUP_CONNPOOL, DC.getServertype(), "bkpserver", null, "backupserver");
            shutdown = false;
            BackupConfManager.initialize();
            LOGGER.log(Level.INFO, "SM-->[BKPCLIENT] BackupClient Initialized at {0}", new Object[]{System.currentTimeMillis()});
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "SM-->[BKPEXCEPTION] Error while initializing BKPClient:{0}", new Object[]{e});
        }
    }

    public static boolean initialize() {
        if (client == null) {
            client = new BackupClient();
            if (!RocksDBManager.initialize(true)) {
                client = null;
            }
        }
        return client != null;
    }

    public static boolean isInitialized() {
        return client != null;
    }

    public static void close() {
        shutdown = true;
        client = null;
    }

    public static void setBkpServerIP(String serverIP) {
        serverip = serverIP;
    }

    public static String getBkpServerIP() {
        return serverip;
    }

    public static Hashtable<String, BackupObject> getBackupList(int count) {
        return BackupClientDB.getHeadFiles(count);
    }

    public static void notifyBackup(String filePath) {
        try {
            if (BackupClient.getBkpServerIP() != null) {
                WCPDispatcher.sendData(BACKUP_CONNPOOL, BackupClient.getBkpServerIP(), 1, filePath);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "SM-->[BKPEXCEPTION] Error while notify backup filepath:{0} :: Exception:{1} ", new Object[]{filePath, e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean restoreFileFromBackup(String entityID, String remoteFilePath, String destFilePath) {
        InputStream istream = null;
        try {
            if (remoteFilePath != null && BackupClient.getBkpServerIP() != null) {
                long startTime = System.currentTimeMillis();
                HttpConnection con = new HttpConnection("http://" + BackupClient.getBkpServerIP() + ":6060/restorefile", 5000, 5000);
                con.addHeader("x-req-origin", DC.getServertype());
                con.addParameter("entityid", (Object)entityID);
                con.addParameter("key", (Object)remoteFilePath);
                istream = con.getStream();
                if (con.getStatusCode() == 200) {
                    Files.deleteIfExists(Paths.get(destFilePath, new String[0]));
                    BackupClient.InStream(destFilePath, istream);
                    LOGGER.log(Level.INFO, "SM-->[BKPRESTORE] Binary File moved to restore dir from backup server, chid: {0} serverip: {1} remoteFilePath: {2} file size: {3} ", new Object[]{entityID, BackupClient.getBkpServerIP(), remoteFilePath, Files.size(Paths.get(destFilePath, new String[0]))});
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "SM-->[BKPRESTORE][BKPEXCEPTION] chid:{0}, remoteFilePath:{1} LR-Exception::{2}", new Object[]{entityID, remoteFilePath, e});
        }
        finally {
            try {
                istream.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private static void InStream(String filePath, InputStream istream) throws IOException {
        File filepath = new File(Paths.get(filePath, new String[0]).getParent().toString());
        if (!filepath.exists()) {
            filepath.mkdirs();
        }
        File file = new File(filePath);
        Files.deleteIfExists(Paths.get(filePath + ".tmp", new String[0]));
        File tmpFile = new File(filePath + ".tmp");
        file.renameTo(tmpFile);
        try (FileOutputStream fos = new FileOutputStream(file, true);){
            int bytesRead = -1;
            byte[] byteBuffer = new byte[BackupConfManager.getTransMaxBuffSize()];
            while ((bytesRead = istream.read(byteBuffer)) != -1) {
                fos.write(byteBuffer, 0, bytesRead);
            }
            if (file.length() >= tmpFile.length()) {
                Files.deleteIfExists(Paths.get(tmpFile.getAbsolutePath(), new String[0]));
            } else {
                File oldFile = new File(filePath + "." + System.currentTimeMillis());
                LOGGER.log(Level.INFO, "SM-->[AR] fileLength: {0} less than old filelength:{1}. oldfilePath:{2}", new Object[]{file.length(), tmpFile.length(), oldFile.getAbsolutePath()});
                tmpFile.renameTo(oldFile);
            }
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "SM-->[AR] Exception while writing file {0}.Ex{1}", new Object[]{file.getAbsolutePath(), ioe});
            Files.deleteIfExists(Paths.get(file.getAbsolutePath(), new String[0]));
            file = new File(filePath);
            tmpFile.renameTo(file);
            Files.deleteIfExists(Paths.get(tmpFile.getAbsolutePath(), new String[0]));
            throw ioe;
        }
    }

    static class RemainingFileStats
    extends Thread {
        private static RemainingFileStats instance = null;

        private RemainingFileStats() {
            this.start();
        }

        public static void initialize() {
            if (instance == null) {
                instance = new RemainingFileStats();
            }
        }

        @Override
        public void run() {
            while (!shutdown) {
                try {
                    Thread.sleep(60000L);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "SM-->[BKPEXCEPTION] Error while taking backupStats for filesremaining ::Exception:{0}", new Object[]{e});
                }
            }
            instance = null;
        }
    }
}

