/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.test;

import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import com.adventnet.wms.servercommon.cassandra.datastax.QueryExecutor;
import com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.UniqueKeyModel;
import com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.test.AbstractModelTest;
import com.adventnet.wms.servercommon.cassandra.datastax.validation.PartitionKeyValidator;
import com.adventnet.wms.servercommon.cassandra.datastax.validation.ValidatorException;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.logging.Logger;

class UniqueKeyModelTest
extends AbstractModelTest {
    private static final Logger LOGGER = Logger.getLogger(UniqueKeyModelTest.class.getName());
    private final UniqueKeyModel uniquekeymodel;
    private static final String INVALIDROWKEYCHARS = "!@#";

    public UniqueKeyModelTest(DatastaxSession dsession, boolean isthriftsupported, Integer preparetype) throws Exception {
        super(dsession, isthriftsupported, preparetype);
        this.dsession.register(this.table, new DatastaxSession.TableProps(ConsistencyLevel.LOCAL_QUORUM, null, 3, new PartitionKeyValidator(){

            public void validate(QueryExecutor.Operation opr, Object partitionkeyvalue) throws ValidatorException {
                if (("" + partitionkeyvalue).contains(UniqueKeyModelTest.INVALIDROWKEYCHARS)) {
                    throw new ValidatorException("Contains invalid chars");
                }
            }
        }));
        this.init();
        this.uniquekeymodel = preparetype == null ? UniqueKeyModel.build(this.dsession, this.table, "Key", "Column1", "Value") : UniqueKeyModel.build(this.dsession, this.table, "Key", "Column1", "Value", preparetype, UniqueKeyModel.allPreparableIds());
    }

    @Override
    protected String getCreateTableQuery() {
        return "create table \"" + this.table + "\" (\"Key\" text, \"Column1\" text, \"Value\" text, primary key (\"Key\", \"Column1\")) with COMPACT STORAGE;";
    }

    @Override
    protected void testAll() throws Exception {
        this.testGets();
        this.testPuts();
        this.testGetRange();
        this.testGetAllRows();
        this.testDeletes();
    }

    void testGets() throws Exception {
        LOGGER.info("Testing Gets..");
        String rowkey = "1234567_tg";
        String cname = UniqueKeyModelTest.getUUID();
        this.uniquekeymodel.putString(rowkey, cname, "{}", 86400, null);
        String value = this.uniquekeymodel.getString(rowkey, cname, null);
        UniqueKeyModelTest.dieUnless("{}".equals(value));
        Hashtable value2 = this.uniquekeymodel.get(rowkey, cname, ConsistencyLevel.ONE);
        UniqueKeyModelTest.dieUnless(value2 != null && value2 instanceof Hashtable);
        UniqueKeyModelTest.dieUnless(value2.size() == 0);
        String value3 = this.uniquekeymodel.getString(rowkey, "invalidkey", null);
        UniqueKeyModelTest.dieUnless(value3 == null);
        Hashtable value4 = this.uniquekeymodel.get("invalidrow", "invalidkey", null);
        UniqueKeyModelTest.dieUnless(value4 == null);
    }

    void testPuts() throws Exception {
        LOGGER.info("Testing Puts..");
        String rowkey = "1234567_tg";
        String cname = UniqueKeyModelTest.getUUID();
        Hashtable<String, Integer> test = new Hashtable<String, Integer>();
        test.put("abc", 1);
        this.uniquekeymodel.put(rowkey, cname, test, 86400, ConsistencyLevel.ONE);
        Hashtable value = this.uniquekeymodel.get(rowkey, cname);
        UniqueKeyModelTest.dieUnless(value != null && value instanceof Hashtable);
        UniqueKeyModelTest.dieUnless(value.size() == 1);
        UniqueKeyModelTest.dieUnless(value.get("abc") instanceof Integer);
        UniqueKeyModelTest.dieUnless(Integer.valueOf(1).equals(value.get("abc")));
        this.uniquekeymodel.putString(rowkey, cname, "{}", 86400, ConsistencyLevel.ONE);
        Hashtable value3 = this.uniquekeymodel.get(rowkey, cname, null);
        UniqueKeyModelTest.dieUnless(value3 != null && value3 instanceof Hashtable);
        UniqueKeyModelTest.dieUnless(value3.size() == 0);
        UniqueKeyModelTest.dieUnlessExceptionThrown(new AbstractModelTest.TestableCode<String>(new String[]{rowkey + INVALIDROWKEYCHARS, cname, "{}"}){

            @Override
            void test() throws Exception {
                UniqueKeyModelTest.this.uniquekeymodel.putString(((String[])this.args)[0], ((String[])this.args)[1], ((String[])this.args)[2], 86400);
            }
        }, ValidatorException.class);
        cname = UniqueKeyModelTest.getUUID();
        this.uniquekeymodel.putString(rowkey, cname, "{}", 86400, null, 2L);
        this.uniquekeymodel.putString(rowkey, cname, "[]", 86400, null, 1L);
        Hashtable value4 = this.uniquekeymodel.get(rowkey, cname, null);
        UniqueKeyModelTest.dieUnless(value4 != null && value4 instanceof Hashtable);
        UniqueKeyModelTest.dieUnless(value4.size() == 0);
    }

    void testGetRange() throws Exception {
        String uuid;
        LOGGER.info("Testing Range Gets..");
        String rowkey = "1234567_trg";
        int limit = 5;
        int maxcols = 10;
        ArrayList<String> uuids = new ArrayList<String>();
        for (int i = 0; i < maxcols; ++i) {
            uuid = UniqueKeyModelTest.getUUID();
            this.uniquekeymodel.put(rowkey, uuid, new Hashtable(), 86400, null);
            uuids.add(uuid);
        }
        ArrayList<Hashtable> arraylist = this.uniquekeymodel.getFirstN(rowkey, limit, null);
        UniqueKeyModelTest.dieUnless(!arraylist.equals(this.uniquekeymodel.getFirstN(rowkey, maxcols + 1, null)));
        UniqueKeyModelTest.dieUnless(this.uniquekeymodel.getFirstN("invalidrowkey", limit, null) == null);
        uuid = (String)arraylist.get(1).get("_sys.cname");
        UniqueKeyModelTest.dieUnless(uuid != null);
        UniqueKeyModelTest.dieUnless(uuids.contains(uuid));
        ArrayList<Hashtable> arraylist2 = this.uniquekeymodel.getNFromColumn(rowkey, uuid, limit, null);
        UniqueKeyModelTest.dieUnless(!arraylist2.equals(this.uniquekeymodel.getNFromColumn(rowkey, uuid, maxcols + 1, null)));
        UniqueKeyModelTest.dieUnless(this.uniquekeymodel.getNFromColumn(rowkey, "invaliduuid", maxcols + 1, null) == null);
        UniqueKeyModelTest.dieUnless(this.uniquekeymodel.getNFromColumn("invalidrowkey", "invaliduuid", maxcols + 1, null) == null);
        ArrayList<String> arraylist3 = this.uniquekeymodel.getColumnNames(rowkey, uuid, limit, null);
        UniqueKeyModelTest.dieUnless(arraylist3 != null && arraylist3.size() == limit);
        UniqueKeyModelTest.dieUnless(this.uniquekeymodel.getFirstNColumnNames(rowkey, limit, null).size() == limit);
        UniqueKeyModelTest.dieUnless(this.uniquekeymodel.getColumnNames(rowkey, "invaliduuid", limit, null) == null);
        UniqueKeyModelTest.dieUnless(this.uniquekeymodel.getColumnNames("invalidrowkey", "invaliduuid", limit, null) == null);
        String[] cnames = new String[]{(String)uuids.get(0), (String)uuids.get(3), (String)uuids.get(5)};
        ArrayList arraylist4 = this.uniquekeymodel.get(rowkey, cnames, null);
        UniqueKeyModelTest.dieUnless(arraylist4 != null && arraylist4.size() == 3);
        ArrayList<String> cnameslist = new ArrayList<String>(Arrays.asList(cnames));
        cnameslist.add("invaliduuid");
        String[] cnames2 = cnameslist.toArray(new String[0]);
        UniqueKeyModelTest.dieUnless(arraylist4.equals(this.uniquekeymodel.get(rowkey, cnames2, null)));
        UniqueKeyModelTest.dieUnless(this.uniquekeymodel.get(rowkey, new String[]{"invaliduuid"}, null) == null);
        UniqueKeyModelTest.dieUnless(this.uniquekeymodel.get("invalidrowkey", new String[]{"invaliduuid"}, null) == null);
    }

    void testDeletes() throws Exception {
        LOGGER.info("Testing Deletes..");
        String rowkey = "testdelete";
        String column = "testcolumn";
        int limit = 20;
        ArrayList[] uuids = new ArrayList[2];
        for (int rowindex = 0; rowindex <= 1; ++rowindex) {
            uuids[rowindex] = new ArrayList();
            for (int i = 0; i < limit; ++i) {
                String uuid = UniqueKeyModelTest.getUUID();
                this.uniquekeymodel.put(rowkey + rowindex, uuid, new Hashtable(), 86400, null);
                uuids[rowindex].add(uuid);
            }
        }
        UniqueKeyModelTest.dieUnless(this.uniquekeymodel.getColumnNames(rowkey + 0, null, limit, null).size() == uuids[0].size());
        String uuid1 = (String)uuids[0].remove(0);
        this.uniquekeymodel.deleteColumn(rowkey + 0, uuid1);
        UniqueKeyModelTest.dieUnless(this.uniquekeymodel.get(rowkey + 0, uuid1) == null);
        this.uniquekeymodel.deleteColumn(rowkey + 0, "invaliduuid");
        UniqueKeyModelTest.dieUnless(this.uniquekeymodel.getColumnNames(rowkey + 0, null, limit, null).size() == uuids[0].size());
        UniqueKeyModelTest.dieUnless(this.uniquekeymodel.getColumnNames(rowkey + 0, null, limit, null).size() == uuids[0].size());
        this.uniquekeymodel.deleteColumn(rowkey + 0, new ArrayList<String>(Arrays.asList((String)uuids[0].remove(0), (String)uuids[0].remove(0))));
        UniqueKeyModelTest.dieUnless(this.uniquekeymodel.getColumnNames(rowkey + 0, null, limit, null).size() == uuids[0].size());
        this.uniquekeymodel.deleteRow(rowkey + 0);
        UniqueKeyModelTest.dieUnless(this.uniquekeymodel.getColumnNames(rowkey + 0, null, limit, null) == null);
        UniqueKeyModelTest.dieUnless(this.uniquekeymodel.getColumnNames(rowkey + 1, null, limit, null).size() == uuids[1].size());
    }

    void testGetAllRows() throws Exception {
        LOGGER.info("Testing Get All rows..");
        String rowkey = "testgetallrows";
        String column = "testcolumn";
        int i = 0;
        for (int rowindex = 1; rowindex <= 3; ++rowindex) {
            this.uniquekeymodel.putString(rowkey + rowindex, column, "{}", 86400, null);
        }
        try {
            ResultSet resultset = this.uniquekeymodel.getAllRows(null, 1);
            for (Row row : resultset) {
                ++i;
            }
            UniqueKeyModelTest.dieUnless(i >= 3);
        }
        catch (UnsupportedOperationException e) {
            UniqueKeyModelTest.dieUnless(this.dsession.isProtocolVersionV1());
        }
    }
}

