/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.test;

import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import com.adventnet.wms.servercommon.cassandra.datastax.QueryExecutor;
import com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.CounterModel;
import com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.UniqueKeyModel;
import com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.test.AbstractModelTest;
import com.adventnet.wms.servercommon.cassandra.datastax.validation.PartitionKeyValidator;
import com.adventnet.wms.servercommon.cassandra.datastax.validation.ValidatorException;
import com.datastax.driver.core.ConsistencyLevel;
import java.util.logging.Logger;

public class CounterModelTest
extends AbstractModelTest {
    private static final Logger LOGGER = Logger.getLogger(CounterModelTest.class.getName());
    private static final String INVALIDROWKEYCHARS = "!@#";
    private CounterModel countermodel;

    public CounterModelTest(DatastaxSession dsession, boolean isthriftsupported, Integer preparetype) throws Exception {
        super(dsession, isthriftsupported, preparetype);
        this.dsession.register(this.table, new DatastaxSession.TableProps(ConsistencyLevel.LOCAL_QUORUM, null, 3, new PartitionKeyValidator(){

            public void validate(QueryExecutor.Operation opr, Object partitionkeyvalue) throws ValidatorException {
                if (opr == QueryExecutor.Operation.INCR && ("" + partitionkeyvalue).contains(CounterModelTest.INVALIDROWKEYCHARS)) {
                    throw new ValidatorException("Contains invalid chars");
                }
            }
        }));
        this.init();
        this.countermodel = preparetype == null ? CounterModel.build(this.dsession, this.table, "Key", "Column1", "Value") : CounterModel.build(this.dsession, this.table, "Key", "Column1", "Value", preparetype, UniqueKeyModel.allPreparableIds());
    }

    @Override
    protected String getCreateTableQuery() {
        return "create table \"" + this.table + "\" (\"Key\" text, \"Column1\" text, \"Value\" counter, primary key (\"Key\", \"Column1\")) with COMPACT STORAGE;";
    }

    @Override
    protected void testAll() throws Exception {
        this.testIncr();
    }

    private void testIncr() throws Exception {
        int i;
        LOGGER.info("Testing Incr..");
        String rowkey = "1234567_ti";
        String cname = CounterModelTest.getUUID();
        this.countermodel.increment(rowkey, cname);
        long value = this.countermodel.get(rowkey, cname);
        CounterModelTest.dieUnless(value == 1L);
        this.countermodel.increment(rowkey, cname, 2L);
        CounterModelTest.dieUnless(this.countermodel.get(rowkey, cname) == 3L);
        this.countermodel.increment(rowkey, cname, -2L);
        CounterModelTest.dieUnless(this.countermodel.get(rowkey, cname) == 1L);
        this.countermodel.deleteColumn(rowkey, cname);
        CounterModelTest.dieUnless(this.countermodel.get(rowkey, cname) == 0L);
        for (i = 1; i <= 3; ++i) {
            this.countermodel.increment(rowkey, cname + i, 20L);
        }
        this.countermodel.deleteRow(rowkey);
        for (i = 1; i <= 3; ++i) {
            CounterModelTest.dieUnless(this.countermodel.get(rowkey, cname + i) == 0L);
        }
        CounterModelTest.dieUnless(this.countermodel.get(rowkey, "invaliduuid") == 0L);
        CounterModelTest.dieUnless(this.countermodel.get("invalidrowkey", "invaliduuid") == 0L);
        boolean validated = false;
        try {
            this.countermodel.increment(rowkey + INVALIDROWKEYCHARS, cname);
            validated = true;
        }
        catch (ValidatorException e) {
            validated = true;
        }
        CounterModelTest.dieUnless(validated);
        CounterModelTest.dieUnless(this.countermodel.get(rowkey + INVALIDROWKEYCHARS, cname) == 0L);
    }
}

