/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.test;

import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import com.adventnet.wms.servercommon.cassandra.datastax.QueryExecutor;
import java.util.Arrays;
import java.util.UUID;
import java.util.logging.Logger;

public abstract class AbstractModelTest {
    protected final String table;
    protected final DatastaxSession dsession;
    protected final boolean isthriftsupported;
    protected final Integer preparetype;
    private boolean init;
    private static final Logger LOGGER = Logger.getLogger(AbstractModelTest.class.getName());

    public AbstractModelTest(DatastaxSession dsession, boolean isthriftsupported, Integer preparetype) {
        this.dsession = dsession;
        this.table = this.getClass().getSimpleName() + "_" + System.currentTimeMillis();
        this.preparetype = preparetype;
        this.isthriftsupported = isthriftsupported;
    }

    protected abstract void testAll() throws Exception;

    public void test() throws Exception {
        try {
            LOGGER.info("Testing all for table: " + this.table + " preparetype: " + this.preparetype + " hector tested?: " + this.isthriftsupported);
            this.init();
            this.testAll();
            LOGGER.info("Testing completed..");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.destroy();
            LOGGER.info("Cleanup success");
        }
    }

    protected void init() {
        if (this.init) {
            return;
        }
        try {
            String cql = this.getCreateTableQuery();
            LOGGER.info("INIT: " + cql);
            QueryExecutor.execute(this.dsession, cql, new Object[0]);
            this.init = true;
        }
        catch (Exception e) {
            LOGGER.warning("Exp: " + e.getMessage());
        }
    }

    protected abstract String getCreateTableQuery();

    private void destroy() {
        try {
            LOGGER.info("Dropping table " + this.table);
            QueryExecutor.execute(this.dsession, "drop table \"" + this.table + "\";", new Object[0]);
        }
        catch (Exception e) {
            LOGGER.warning("Exp: " + e.getMessage());
        }
    }

    public static void dieUnless(boolean expr) throws Exception {
        if (!expr) {
            String exp = Arrays.toString(Arrays.copyOfRange(Thread.currentThread().getStackTrace(), 0, 5)).replaceAll(",", "\n");
            LOGGER.severe("Testing failed at: " + exp + "\n\n\n\n");
            throw new Exception(exp);
        }
    }

    public static String getUUID() {
        return UUID.randomUUID().toString().toUpperCase();
    }

    protected static void dieUnlessExceptionThrown(TestableCode<?> code, Class<? extends Exception> clazz) throws Exception {
        boolean expthrown;
        block2: {
            expthrown = false;
            try {
                code.test();
            }
            catch (Exception e) {
                if (clazz != null && !clazz.isInstance(e)) break block2;
                expthrown = true;
            }
        }
        AbstractModelTest.dieUnless(expthrown);
    }

    protected static void dieUnlessExceptionThrown(TestableCode<?> code) throws Exception {
        AbstractModelTest.dieUnlessExceptionThrown(code, null);
    }

    protected static abstract class TestableCode<T> {
        protected T[] args;

        public TestableCode(T ... args) {
            this.args = args;
        }

        abstract void test() throws Exception;
    }
}

