/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.cassandra.datastax.tablemodels;

import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import com.adventnet.wms.servercommon.cassandra.datastax.QueryExecutor;
import com.adventnet.wms.servercommon.cassandra.datastax.QueryId;
import com.adventnet.wms.servercommon.cassandra.datastax.StatementBuilder;
import com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.AbstractThriftCompatibleTableModel;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Update;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CounterModel
extends AbstractThriftCompatibleTableModel {
    private static final Logger LOGGER = Logger.getLogger(CounterModel.class.getName());
    private final StatementBuilder.UpdateStatement update;

    public static QueryId[] allPreparableIds() {
        return CounterQuery.values();
    }

    public CounterModel(DatastaxSession dsession, String tablename, String name_rowkey, String name_column1, String name_value) {
        super(dsession, tablename, name_rowkey, name_column1, name_value);
        this.update = new StatementBuilder.UpdateStatement(dsession, tablename, name_rowkey, name_column1, name_value);
    }

    public static CounterModel build(DatastaxSession dsession, String tablename, String name_rowkey, String name_column1, String name_value) throws Exception {
        return new CounterModel(dsession, tablename, name_rowkey, name_column1, name_value);
    }

    public static CounterModel build(DatastaxSession dsession, String tablename, String name_rowkey, String name_column1, String name_value, int preparetype, QueryId ... queriestoprepare) throws Exception {
        CounterModel countermodel = new CounterModel(dsession, tablename, name_rowkey, name_column1, name_value);
        if (queriestoprepare != null) {
            for (QueryId query : queriestoprepare) {
                countermodel.prepareQuery(query, preparetype);
            }
        }
        return countermodel;
    }

    public static CounterModel build(DatastaxSession dsession, String tablename, String name_rowkey, String name_column1, String name_value, Map<QueryId, Integer> queriestoprepare) throws Exception {
        CounterModel countermodel = new CounterModel(dsession, tablename, name_rowkey, name_column1, name_value);
        countermodel.prepareQueries(queriestoprepare);
        return countermodel;
    }

    @Override
    protected RegularStatement getStatementToPrepareForQuery(QueryId querytoprepare) throws Exception {
        Update statement = null;
        if (querytoprepare == CounterQuery.GETONE) {
            statement = this.select.byFirstClusteringColumn(new String[]{this.name_value}, QueryBuilder.bindMarker(), this.name_column1, QueryBuilder.bindMarker());
        } else if (querytoprepare == CounterQuery.INCREMENT) {
            statement = this.update.incrementValueColumn(QueryBuilder.bindMarker((String)this.name_rowkey), QueryBuilder.bindMarker((String)this.name_column1), QueryBuilder.bindMarker((String)this.name_value));
        } else if (querytoprepare == CounterQuery.DELETEONE) {
            if (!this.dsession.isProtocolVersionV1()) {
                statement = this.delete.byFirstClusteringKey(null, QueryBuilder.bindMarker((String)this.name_rowkey), this.name_column1, QueryBuilder.bindMarker((String)this.name_column1));
            }
        } else if (querytoprepare == CounterQuery.DELETEFULLROW && !this.dsession.isProtocolVersionV1()) {
            statement = this.delete.byPartitionKey(null, QueryBuilder.bindMarker((String)this.name_rowkey));
        }
        return statement;
    }

    public void increment(String key, String cname) throws Exception {
        this.increment(key, cname, 1L, null);
    }

    public void increment(String key, String cname, long value) throws Exception {
        this.increment(key, cname, value, null);
    }

    public void increment(String key, String cname, long value, ConsistencyLevel consistencylevel) throws Exception {
        Object statement = null;
        try {
            statement = this.isPreparedQuery(CounterQuery.INCREMENT) ? this.getPreparedStatement(CounterQuery.INCREMENT).bind().setString(this.name_rowkey, this.validated(QueryExecutor.Operation.INCR, key)).setString(this.name_column1, cname).setLong(this.name_value, value) : this.update.incrementValueColumn(key, cname, value);
            if (consistencylevel != null) {
                statement.setConsistencyLevel(consistencylevel);
            }
            LOGGER.fine("CounterModel#increment for key: " + key + " cname: " + cname + " value: " + value + " cl: " + consistencylevel);
            QueryExecutor.execute(this.dsession, QueryExecutor.Operation.INCR, this.table, (Statement)statement);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in CounterModel#incr", e);
            throw e;
        }
    }

    public long get(String key, String cname) throws Exception {
        return this.get(key, cname, null);
    }

    public long get(String key, String cname, ConsistencyLevel consistencylevel) throws Exception {
        ResultSet resultset = null;
        Object statement = null;
        try {
            Row row;
            statement = this.isPreparedQuery(CounterQuery.GETONE) ? this.getPreparedStatement(CounterQuery.GETONE).bind(new Object[]{this.validated(QueryExecutor.Operation.GET, key), cname}) : this.select.byFirstClusteringColumn(new String[]{this.name_value}, key, this.name_column1, cname);
            if (consistencylevel != null) {
                statement.setConsistencyLevel(consistencylevel);
            }
            LOGGER.fine("CounterModel#get for key: " + key + " cname: " + cname + " cl: " + consistencylevel);
            resultset = QueryExecutor.execute(this.dsession, QueryExecutor.Operation.GET, this.table, (Statement)statement);
            if (resultset != null && (row = resultset.one()) != null) {
                return row.getLong(this.name_value);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in CounterModel#get", e);
            throw e;
        }
        return 0L;
    }

    @Override
    public void deleteColumn(String key, String cname) throws Exception {
        Object statement = null;
        try {
            statement = this.isPreparedQuery(CounterQuery.DELETEONE) ? this.getPreparedStatement(CounterQuery.DELETEONE).bind().setString(this.name_rowkey, this.validated(QueryExecutor.Operation.DEL, key)).setString(this.name_column1, cname) : this.delete.byFirstClusteringKey(null, key, this.name_column1, cname);
            LOGGER.fine("CounterModel#deleteColumn for key: " + key + " cname: " + cname);
            QueryExecutor.execute(this.dsession, QueryExecutor.Operation.DEL, this.table, (Statement)statement);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in CounterModel#deleteColumn", e);
            throw e;
        }
    }

    @Override
    public void deleteRow(String key) throws Exception {
        Object statement = null;
        try {
            statement = this.isPreparedQuery(CounterQuery.DELETEFULLROW) ? this.getPreparedStatement(CounterQuery.DELETEFULLROW).bind().setString(this.name_rowkey, this.validated(QueryExecutor.Operation.DEL, key)) : this.delete.byPartitionKey(null, key);
            LOGGER.fine("CounterModel#deleteRow for key: " + key);
            QueryExecutor.execute(this.dsession, QueryExecutor.Operation.DEL, this.table, (Statement)statement);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in CounterModel#deleteRow", e);
            throw e;
        }
    }

    public static enum CounterQuery implements QueryId
    {
        GETONE(true),
        INCREMENT(true),
        DELETEONE(true),
        DELETEFULLROW(true);

        private final boolean ispreparable;

        private CounterQuery() {
            this(false);
        }

        private CounterQuery(boolean ispreparable) {
            this.ispreparable = ispreparable;
        }

        @Override
        public boolean isPreparable() {
            return this.ispreparable;
        }

        @Override
        public String getIdentifier() {
            return this.name();
        }
    }
}

