/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.cassandra.datastax.tablemodels;

import com.adventnet.wms.servercommon.cassandra.CassandraIDGenerator;
import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import com.adventnet.wms.servercommon.cassandra.datastax.QueryExecutor;
import com.adventnet.wms.servercommon.cassandra.datastax.QueryId;
import com.adventnet.wms.servercommon.cassandra.datastax.StatementBuilder;
import com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.AbstractTableModel;
import com.adventnet.wms.servercommon.cassandra.datastax.validation.PartitionKeyValidator;
import com.adventnet.wms.servercommon.cassandra.datastax.validation.ValidatorException;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractThriftCompatibleTableModel
extends AbstractTableModel {
    private static final Logger LOGGER = Logger.getLogger(AbstractThriftCompatibleTableModel.class.getName());
    protected String name_rowkey;
    protected String name_column1;
    protected String name_value;
    protected final PartitionKeyValidator<String> pkvalidator;
    protected final StatementBuilder.SelectStatement select;
    protected final StatementBuilder.InsertStatement insert;
    protected final StatementBuilder.DeleteStatement delete;

    protected static QueryId[] allPreparableIds(QueryId ... subclassvalues) {
        ArrayList<QueryId> allpreparableids = new ArrayList<QueryId>(CommonQuery.values().length + subclassvalues.length);
        for (CommonQuery commonQuery : CommonQuery.values()) {
            if (!commonQuery.isPreparable()) continue;
            allpreparableids.add(commonQuery);
        }
        for (QueryId queryId : subclassvalues) {
            if (!queryId.isPreparable()) continue;
            allpreparableids.add(queryId);
        }
        return allpreparableids.toArray(new QueryId[0]);
    }

    public AbstractThriftCompatibleTableModel(DatastaxSession dsession, String table, String name_rowkey, String name_column1, String name_value) {
        super(dsession, table);
        this.name_rowkey = name_rowkey;
        this.name_column1 = name_column1;
        this.name_value = name_value;
        this.pkvalidator = dsession.getPartitionKeyValidator(table);
        this.select = StatementBuilder.select(dsession, table, name_rowkey);
        this.insert = StatementBuilder.insert(dsession, table, name_rowkey);
        this.delete = StatementBuilder.delete(dsession, table, name_rowkey);
    }

    protected String validated(QueryExecutor.Operation opr, String pkvalue) throws ValidatorException {
        if (this.pkvalidator != null) {
            this.pkvalidator.validate(opr, pkvalue);
        }
        return pkvalue;
    }

    protected void prepareQueries(Map<QueryId, Integer> queryidmap) throws Exception {
        for (QueryId queryid : queryidmap.keySet()) {
            this.prepareQuery(queryid, queryidmap.get(queryid));
        }
    }

    protected void prepareQuery(QueryId querytoprepare, Integer preparetype) throws Exception {
        RegularStatement statement = null;
        if (!querytoprepare.isPreparable()) {
            return;
        }
        if (querytoprepare == CommonQuery.DELETECOLUMN) {
            if (!this.dsession.isProtocolVersionV1()) {
                statement = this.delete.byFirstClusteringKey(QueryBuilder.bindMarker(), QueryBuilder.bindMarker((String)this.name_rowkey), this.name_column1, QueryBuilder.bindMarker((String)this.name_column1));
            }
        } else if (querytoprepare == CommonQuery.DELETEROW) {
            if (!this.dsession.isProtocolVersionV1()) {
                statement = this.delete.byPartitionKey(QueryBuilder.bindMarker(), QueryBuilder.bindMarker((String)this.name_rowkey));
            }
        } else {
            statement = this.getStatementToPrepareForQuery(querytoprepare);
        }
        if (statement != null) {
            this.registerPreparedQuery(querytoprepare, statement, preparetype);
        }
    }

    protected abstract RegularStatement getStatementToPrepareForQuery(QueryId var1) throws Exception;

    public void deleteColumn(String key, String cname) throws Exception {
        Object statement = null;
        try {
            statement = this.isPreparedQuery(CommonQuery.DELETECOLUMN) ? this.getPreparedStatement(CommonQuery.DELETECOLUMN).bind().setString(this.name_rowkey, this.validated(QueryExecutor.Operation.DEL, key)).setString(this.name_column1, cname).setLong("[timestamp]", CassandraIDGenerator.getTimeStamp()) : this.delete.byFirstClusteringKey(CassandraIDGenerator.getTimeStamp(), key, this.name_column1, cname);
            LOGGER.fine("Deleting column for key: " + key + " cname: " + cname);
            QueryExecutor.execute(this.dsession, QueryExecutor.Operation.DEL, this.table, (Statement)statement);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in AbstractThriftCompatibleTableModel#deleteColumn", e);
            throw e;
        }
    }

    public void deleteColumn(String key, ArrayList<String> cnames) throws Exception {
        for (String cname : cnames) {
            this.deleteColumn(key, cname);
        }
    }

    public void deleteRow(String key) throws Exception {
        Object statement = null;
        try {
            statement = this.isPreparedQuery(CommonQuery.DELETEROW) ? this.getPreparedStatement(CommonQuery.DELETEROW).bind().setString(this.name_rowkey, this.validated(QueryExecutor.Operation.DEL, key)).setLong("[timestamp]", CassandraIDGenerator.getTimeStamp()) : this.delete.byPartitionKey(CassandraIDGenerator.getTimeStamp(), key);
            LOGGER.fine("Deleting row for key: " + key);
            QueryExecutor.execute(this.dsession, QueryExecutor.Operation.DEL, this.table, (Statement)statement);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in AbstractThriftCompatibleTableModel#deleteRow", e);
            throw e;
        }
    }

    public static enum CommonQuery implements QueryId
    {
        DELETECOLUMN(true),
        DELETEROW(true);

        private final boolean ispreparable;

        private CommonQuery(boolean ispreparable) {
            this.ispreparable = ispreparable;
        }

        @Override
        public String getIdentifier() {
            return this.name();
        }

        @Override
        public boolean isPreparable() {
            return this.ispreparable;
        }
    }
}

