/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.cassandra.datastax;

import com.adventnet.wms.servercommon.cassandra.CassandraStats;
import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import com.adventnet.wms.servercommon.cassandra.datastax.WrappedResultSet;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import java.util.logging.Logger;

public class QueryExecutor {
    private static final Logger LOGGER = Logger.getLogger(QueryExecutor.class.getName());
    private static final String TABLE_UNSPECIFIED = "unspecified";

    private static ResultSet safeExecute(DatastaxSession dsession, String table, Object stmt_or_query, Object ... values) throws Exception {
        Statement statement = null;
        if (stmt_or_query instanceof Statement) {
            statement = (Statement)stmt_or_query;
        } else if (stmt_or_query instanceof String) {
            if (values != null && values.length > 0) {
                if (dsession.isProtocolVersionV1()) {
                    throw new UnsupportedOperationException("Parameterized statements not supported in V1");
                }
                statement = new SimpleStatement((String)stmt_or_query, values);
            } else {
                statement = new SimpleStatement((String)stmt_or_query);
            }
        } else {
            throw new IllegalArgumentException("Illegal argument passed: " + stmt_or_query);
        }
        DatastaxSession.TableProps props = dsession.getPropsFor(table);
        if (props != null) {
            if (statement.getConsistencyLevel() != null && props.consistencylevel != null) {
                LOGGER.finer("Setting table level consistencylevel: " + props.consistencylevel);
                statement.setConsistencyLevel(props.consistencylevel);
            }
            if (!dsession.isProtocolVersionV1() && statement.getFetchSize() <= 0 && props.fetchsize > 0) {
                LOGGER.finer("Setting table level fetchsize: " + props.fetchsize);
                statement.setFetchSize(props.fetchsize);
            }
            if (statement.getRetryPolicy() != null && props.retrypolicy != null) {
                LOGGER.finer("Setting table level retrypolicy: " + props.retrypolicy);
                statement.setRetryPolicy(props.retrypolicy);
            }
        }
        LOGGER.fine("QE executing statement: " + statement + " for table: " + table + " dsession: " + dsession);
        return new WrappedResultSet(dsession, dsession.getSession().execute(statement));
    }

    private static PreparedStatement safePrepare(DatastaxSession dsession, Object stmt_or_query) throws Exception {
        if (stmt_or_query instanceof RegularStatement) {
            LOGGER.fine("QE preparing statement: " + stmt_or_query + " for dsession: " + dsession);
            return dsession.getSession().prepare((RegularStatement)stmt_or_query);
        }
        if (stmt_or_query instanceof String) {
            LOGGER.fine("QE preparing query: " + stmt_or_query + " for dsession: " + dsession);
            return dsession.getSession().prepare((String)stmt_or_query);
        }
        throw new IllegalArgumentException("Illegal argument passed: " + stmt_or_query);
    }

    private static ResultSet instrumentAndExecute(DatastaxSession dsession, Operation opr, String table, Object stmt_or_query, Object ... values) throws Exception {
        long startTime = System.currentTimeMillis();
        Object statsref = null;
        ResultSet resultset = null;
        if (table == null) {
            table = TABLE_UNSPECIFIED;
        }
        if (opr == null) {
            opr = Operation.UNSPECIFIED;
        }
        try {
            statsref = CassandraStats.start(opr.value, table);
            resultset = QueryExecutor.safeExecute(dsession, table, stmt_or_query, values);
            CassandraStats.hit(opr.value, table, startTime, statsref);
        }
        catch (Exception e) {
            CassandraStats.hitFailure(opr.value, table, startTime, statsref);
            throw e;
        }
        return resultset;
    }

    private static PreparedStatement instrumentAndPrepare(DatastaxSession dsession, String table, Object stmt_or_query) throws Exception {
        long startTime = System.currentTimeMillis();
        Object statsref = null;
        PreparedStatement preparedstatement = null;
        if (table == null) {
            table = TABLE_UNSPECIFIED;
        }
        try {
            statsref = CassandraStats.start(Operation.PREPARE.value, table);
            preparedstatement = QueryExecutor.safePrepare(dsession, stmt_or_query);
            CassandraStats.hit(Operation.PREPARE.value, table, startTime, statsref);
        }
        catch (Exception e) {
            CassandraStats.hitFailure(Operation.PREPARE.value, table, startTime, statsref);
            throw e;
        }
        return preparedstatement;
    }

    public static ResultSet execute(DatastaxSession dsession, Statement statement) throws Exception {
        return QueryExecutor.execute(dsession, null, null, statement);
    }

    public static ResultSet execute(DatastaxSession dsession, String query, Object ... values) throws Exception {
        return QueryExecutor.execute(dsession, null, null, query, values);
    }

    public static PreparedStatement prepare(DatastaxSession dsession, String query) throws Exception {
        return QueryExecutor.prepare(dsession, null, query);
    }

    public static PreparedStatement prepare(DatastaxSession dsession, RegularStatement statement) throws Exception {
        return QueryExecutor.prepare(dsession, null, statement);
    }

    public static ResultSet execute(DatastaxSession dsession, Operation opr, String table, Statement statement) throws Exception {
        return dsession.isInstrumentationEnabled() ? QueryExecutor.instrumentAndExecute(dsession, opr, table, statement, new Object[0]) : QueryExecutor.safeExecute(dsession, table, statement, new Object[0]);
    }

    public static ResultSet execute(DatastaxSession dsession, Operation opr, String table, String query, Object ... values) throws Exception {
        return dsession.isInstrumentationEnabled() ? QueryExecutor.instrumentAndExecute(dsession, opr, table, query, values) : QueryExecutor.safeExecute(dsession, table, query, values);
    }

    public static PreparedStatement prepare(DatastaxSession dsession, String table, String query) throws Exception {
        return dsession.isInstrumentationEnabled() ? QueryExecutor.instrumentAndPrepare(dsession, table, query) : QueryExecutor.safePrepare(dsession, query);
    }

    public static PreparedStatement prepare(DatastaxSession dsession, String table, RegularStatement statement) throws Exception {
        return dsession.isInstrumentationEnabled() ? QueryExecutor.instrumentAndPrepare(dsession, table, statement) : QueryExecutor.safePrepare(dsession, statement);
    }

    public static enum Operation {
        PUT("put"),
        GET("get"),
        DEL("del"),
        INCR("incr"),
        PREPARE("prepare"),
        UNSPECIFIED("unspecified");

        private final String value;

        private Operation(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

