/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.cassandra.datastax;

import com.adventnet.wms.servercommon.cassandra.CassandraStatsInterface;
import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.LatencyTracker;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryLogger;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.DefaultRetryPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.Policies;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatastaxManager {
    private static final Logger LOGGER = Logger.getLogger(DatastaxManager.class.getName());
    private static final Map<String, Cluster> CLUSTERMAP = new HashMap<String, Cluster>();
    private static final Map<String, DatastaxSession> CLUSTERSESSIONMAP = new HashMap<String, DatastaxSession>();
    private static String datacenter = "DC1";
    private static CassandraStatsInterface stats = null;
    private static DatastaxSession defaultsession = null;
    public static String server;
    private static final Hashtable<ClusterProp, Object> DEFAULTPROPS;

    public static DatastaxSession getDatastaxSession(String clusterid, String keyspacename) {
        return CLUSTERSESSIONMAP.get(clusterid + "." + keyspacename);
    }

    public static Hashtable<QueryLoggerProp, Object> getDefaultQueryLoggerProps() {
        Hashtable<QueryLoggerProp, Object> defaultqueryloggerprops = new Hashtable<QueryLoggerProp, Object>();
        defaultqueryloggerprops.put(QueryLoggerProp.SLOW_QUERY_THRESHOLD_MS, 5000L);
        defaultqueryloggerprops.put(QueryLoggerProp.MAX_QUERY_STRING_LENGTH, 500);
        defaultqueryloggerprops.put(QueryLoggerProp.MAX_PARAMETER_VALUE_LENGTH, 50);
        defaultqueryloggerprops.put(QueryLoggerProp.MAX_LOGGED_PARAMETERS, 50);
        return defaultqueryloggerprops;
    }

    private static Object getProp(Hashtable<ClusterProp, Object> props, ClusterProp prop) {
        return props != null && props.containsKey((Object)prop) ? props.get((Object)prop) : DEFAULTPROPS.get((Object)prop);
    }

    public static DatastaxSession initialize(String clusterid, String keyspacename, Hashtable<ClusterProp, Object> clusterprops, boolean isdefault) throws Exception {
        datacenter = System.getProperty("datacenter.name", datacenter);
        server = System.getProperty("server.type", server);
        DatastaxManager.setConsistency(clusterprops);
        DatastaxSession dsession = DatastaxManager.getDatastaxSession(clusterid, keyspacename);
        if (dsession != null) {
            return dsession;
        }
        Cluster cluster = CLUSTERMAP.get(clusterid);
        if (cluster == null) {
            LOGGER.info("Initializing cluster " + clusterid + " with props : " + clusterprops);
            LOGGER.info("[JAVEED] Testing" + DatastaxManager.getProp(clusterprops, ClusterProp.CLUSTERNAME));
            cluster = Cluster.builder().addContactPoints((String[])DatastaxManager.getProp(clusterprops, ClusterProp.CONTACTPOINTS)).withClusterName((String)DatastaxManager.getProp(clusterprops, ClusterProp.CLUSTERNAME)).withAuthProvider((AuthProvider)DatastaxManager.getProp(clusterprops, ClusterProp.AUTHPROVIDER)).withQueryOptions((QueryOptions)DatastaxManager.getProp(clusterprops, ClusterProp.QUERYOPTIONS)).withRetryPolicy((RetryPolicy)DatastaxManager.getProp(clusterprops, ClusterProp.RETRYPOLICY)).withLoadBalancingPolicy((LoadBalancingPolicy)DatastaxManager.getProp(clusterprops, ClusterProp.LOADBALANCINGPOLICY)).withReconnectionPolicy((ReconnectionPolicy)DatastaxManager.getProp(clusterprops, ClusterProp.RECONNECTIONPOLICY)).withCompression((ProtocolOptions.Compression)DatastaxManager.getProp(clusterprops, ClusterProp.COMPRESSION)).withProtocolVersion((ProtocolVersion)DatastaxManager.getProp(clusterprops, ClusterProp.PROTOCOLVERSION)).withPoolingOptions((PoolingOptions)DatastaxManager.getProp(clusterprops, ClusterProp.POOLINGOPTIONS)).build();
            LOGGER.log(Level.INFO, "Connected to cluster: {0}\n", clusterid);
            CLUSTERMAP.put(clusterid, cluster);
            DatastaxManager.registerQueryLogger(cluster, (Hashtable)DatastaxManager.getProp(clusterprops, ClusterProp.QUERYLOGGER));
        }
        LOGGER.info("Connecting to cluster: " + cluster + " keyspace: " + keyspacename);
        Session session = cluster.connect(keyspacename);
        LOGGER.info("[JAVEED] before creating Datastax session ==>" + session.getCluster().getClusterName());
        dsession = new DatastaxSession(cluster, session);
        LOGGER.info("[JAVEED] After creating Datastax session ==>" + dsession.getClusterName());
        CLUSTERSESSIONMAP.put(clusterid + "." + keyspacename, dsession);
        if (defaultsession == null || isdefault) {
            defaultsession = dsession;
        }
        LOGGER.info("Initialized Datastax for cluster: " + cluster + " keyspace: " + keyspacename + " isdefault: " + isdefault);
        LOGGER.info("[JAVEED] BF ret " + dsession.getClusterName());
        return dsession;
    }

    private static void setConsistency(Hashtable<ClusterProp, Object> clusterprops) {
        String consistencyLevel = System.getProperty("cassandra.consistency");
        if (consistencyLevel != null) {
            try {
                clusterprops.put(ClusterProp.QUERYOPTIONS, new QueryOptions().setConsistencyLevel(ConsistencyLevel.valueOf((String)consistencyLevel)));
            }
            catch (Exception ex) {
                clusterprops.put(ClusterProp.QUERYOPTIONS, new QueryOptions().setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM));
            }
        }
    }

    public static String getDatacenter() {
        return datacenter;
    }

    public static void registerQueryLogger(Cluster cluster, Hashtable<QueryLoggerProp, Object> queryloggerprops) {
        if (queryloggerprops == null) {
            return;
        }
        QueryLogger queryLogger = QueryLogger.builder().withConstantThreshold(((Long)queryloggerprops.get((Object)QueryLoggerProp.SLOW_QUERY_THRESHOLD_MS)).longValue()).withMaxQueryStringLength(((Integer)queryloggerprops.get((Object)QueryLoggerProp.MAX_QUERY_STRING_LENGTH)).intValue()).withMaxParameterValueLength(((Integer)queryloggerprops.get((Object)QueryLoggerProp.MAX_PARAMETER_VALUE_LENGTH)).intValue()).withMaxLoggedParameters(((Integer)queryloggerprops.get((Object)QueryLoggerProp.MAX_LOGGED_PARAMETERS)).intValue()).build();
        queryLogger.onRegister(cluster);
        cluster.register((LatencyTracker)queryLogger);
    }

    public static DatastaxSession getDefaultSession() {
        return defaultsession;
    }

    public static CassandraStatsInterface getStatsHandler() {
        return stats;
    }

    public static void setStatsHandler(CassandraStatsInterface statsimpl) {
        stats = statsimpl;
    }

    public static void destroy() {
        for (DatastaxSession bean : CLUSTERSESSIONMAP.values()) {
            try {
                LOGGER.info("Destroying session for keyspace: " + bean.getKeyspace());
                bean.getSession().close();
            }
            catch (Exception exception) {}
        }
        for (Cluster cluster : CLUSTERMAP.values()) {
            try {
                LOGGER.info("Destroying cluster: " + cluster.getClusterName());
                cluster.close();
            }
            catch (Exception exception) {}
        }
    }

    static {
        DEFAULTPROPS = new Hashtable<ClusterProp, Object>(){
            {
                this.put(ClusterProp.CONTACTPOINTS, "localhost".split(","));
                this.put(ClusterProp.CLUSTERNAME, "ACS");
                this.put(ClusterProp.QUERYOPTIONS, new QueryOptions().setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM));
                this.put(ClusterProp.RETRYPOLICY, DefaultRetryPolicy.INSTANCE);
                this.put(ClusterProp.LOADBALANCINGPOLICY, new TokenAwarePolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().withLocalDc("DC1").build()));
                this.put(ClusterProp.RECONNECTIONPOLICY, Policies.defaultReconnectionPolicy());
                this.put(ClusterProp.COMPRESSION, ProtocolOptions.Compression.LZ4);
                this.put(ClusterProp.POOLINGOPTIONS, new PoolingOptions());
                this.put(ClusterProp.AUTHPROVIDER, AuthProvider.NONE);
                this.put(ClusterProp.PROTOCOLVERSION, ProtocolVersion.NEWEST_SUPPORTED);
            }
        };
    }

    public static enum QueryLoggerProp {
        SLOW_QUERY_THRESHOLD_MS,
        MAX_QUERY_STRING_LENGTH,
        MAX_PARAMETER_VALUE_LENGTH,
        MAX_LOGGED_PARAMETERS;

    }

    public static enum ClusterProp {
        CONTACTPOINTS,
        CLUSTERNAME,
        QUERYOPTIONS,
        RETRYPOLICY,
        LOADBALANCINGPOLICY,
        RECONNECTIONPOLICY,
        COMPRESSION,
        PROTOCOLVERSION,
        POOLINGOPTIONS,
        AUTHPROVIDER,
        QUERYLOGGER;

    }
}

