/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.cassandra;

import com.adventnet.wms.servercommon.WMSServerTypes;
import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxManager;
import java.util.logging.Logger;

public class WMSBaseCF {
    private static final Logger LOGGER = Logger.getLogger(WMSBaseCF.class.getName());
    protected static final int THREE_YEARS = 94608000;
    protected static final String RSERVER = "RS";
    protected static final String PSERVER = "PS";
    protected static final String AWSSERVER = "AW";
    protected static final String XMPPSERVER = "XM";
    protected static final String MPSERVER = "MP";
    protected static final String ACSERVER = "AC";
    protected static final String IRSERVER = "IR";
    protected static final String DAVSERVER = "DV";
    protected static final String MSSERVER = "MS";
    protected static final String HSSERVER = "HS";
    protected static final String NRSERVER = "NR";

    public static String getRowKey(String key) {
        return WMSBaseCF.getKeyPrefix(DatastaxManager.getDatacenter()) + "_" + key;
    }

    private static String getKeyPrefix(String datacenter) {
        return datacenter.concat(DatastaxManager.server != null ? "_" + DatastaxManager.server : "");
    }

    public static String getRSRowKey(String key) {
        return DatastaxManager.getDatacenter() + "_" + RSERVER + "_" + key;
    }

    public static String getPSRowKey(String key) {
        return DatastaxManager.getDatacenter() + "_" + PSERVER + "_" + key;
    }

    public static String getAWSRowKey(String key) {
        return DatastaxManager.getDatacenter() + "_" + AWSSERVER + "_" + key;
    }

    public static String getXMPPSRowKey(String key) {
        return DatastaxManager.getDatacenter() + "_" + XMPPSERVER + "_" + key;
    }

    public static String getACSRowKey(String key) {
        return DatastaxManager.getDatacenter() + "_" + ACSERVER + "_" + key;
    }

    public static String getMPSRowKey(String key) {
        return DatastaxManager.getDatacenter() + "_" + MPSERVER + "_" + key;
    }

    public static String getIRSRowKey(String key) {
        return DatastaxManager.getDatacenter() + "_" + IRSERVER + "_" + key;
    }

    public static String getDAVRowKey(String key) {
        return DatastaxManager.getDatacenter() + "_" + DAVSERVER + "_" + key;
    }

    public static String getNRSRowKey(String key) {
        return DatastaxManager.getDatacenter() + "_" + NRSERVER + "_" + key;
    }

    public static String getMSSRowKey(String key) {
        return DatastaxManager.getDatacenter() + "_" + MSSERVER + "_" + key;
    }

    public static String getHSSRowKey(String key) {
        return DatastaxManager.getDatacenter() + "_" + HSSERVER + "_" + key;
    }

    public static String getServerKey(String type, String key) {
        if (type == null) {
            return WMSBaseCF.getRowKey(key);
        }
        if (type.equals(WMSServerTypes.RSERVER.toString())) {
            return WMSBaseCF.getRSRowKey(key);
        }
        if (type.equals(WMSServerTypes.PSERVER.toString())) {
            return WMSBaseCF.getPSRowKey(key);
        }
        if (type.equals(WMSServerTypes.AWSERVER.toString())) {
            return WMSBaseCF.getAWSRowKey(key);
        }
        if (type.equals(WMSServerTypes.XMPPSERVER.toString())) {
            return WMSBaseCF.getXMPPSRowKey(key);
        }
        if (type.equals(WMSServerTypes.ACSERVER.toString())) {
            return WMSBaseCF.getACSRowKey(key);
        }
        if (type.equals(WMSServerTypes.MPSERVER.toString())) {
            return WMSBaseCF.getMPSRowKey(key);
        }
        if (type.equals(WMSServerTypes.IRSERVER.toString())) {
            return WMSBaseCF.getIRSRowKey(key);
        }
        if (type.equals(WMSServerTypes.DAVSERVER.toString())) {
            return WMSBaseCF.getDAVRowKey(key);
        }
        if (type.equals(WMSServerTypes.NRSERVER.toString())) {
            return WMSBaseCF.getNRSRowKey(key);
        }
        if (type.equals(WMSServerTypes.MSSERVER.toString())) {
            return WMSBaseCF.getMSSRowKey(key);
        }
        if (type.equals(WMSServerTypes.HSSERVER.toString())) {
            return WMSBaseCF.getHSSRowKey(key);
        }
        return null;
    }
}

