/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.bbpool;

import com.adventnet.wms.servercommon.bbpool.BBPoolConfManager;
import com.adventnet.wms.servercommon.bbpool.WMSBBPoolUtil;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.nio.ch.DirectBuffer;

public class WMSBBPool {
    private Logger logger = Logger.getLogger(WMSBBPool.class.getName());
    private ByteBuffer masterbuffer;
    private int size;
    private int chunks;
    private int chunksize;
    private BitSet bitset;
    private boolean isDirect;
    private boolean isBestFit;
    private Object bufferlock = new Object();
    private AtomicInteger activebuffersize = new AtomicInteger();
    private AtomicInteger allocatedsize = new AtomicInteger();
    private AtomicInteger allocatedno = new AtomicInteger();
    private AtomicInteger deallocatedsize = new AtomicInteger();
    private AtomicInteger deallocatedno = new AtomicInteger();
    private AtomicInteger fatalerrorno = new AtomicInteger();
    private AtomicInteger unpooledbuffersize = new AtomicInteger();
    private AtomicLong alloctime = new AtomicLong();
    private long masterhash = -1L;

    public WMSBBPool(long v_chunks, long v_chunksize, boolean v_isDirect, boolean v_isBestFit) throws Exception {
        this.chunks = (int)v_chunks;
        this.chunksize = (int)v_chunksize;
        this.isDirect = v_isDirect;
        this.isBestFit = v_isBestFit;
        this.size = this.chunks * this.chunksize;
        if (this.isDirect) {
            this.masterbuffer = ByteBuffer.allocateDirect(this.size);
            this.masterhash = WMSBBPoolUtil.computeHash(this.masterbuffer);
        } else {
            this.masterbuffer = ByteBuffer.allocate(this.size);
            this.masterhash = WMSBBPoolUtil.computeHash(this.masterbuffer.array());
        }
        this.bitset = new BitSet(this.chunks);
        this.modifyBitSet(0, this.chunks, true);
        this.logger.info("[WMSBBPool INIT][" + this.masterhash + "][SIZE][" + this.size + "][CHUNK SIZE][" + this.chunksize + "][CHUNKS][" + this.chunks + "][BUFFER SIZE ALLOCATED][" + this.masterbuffer.limit() + "][ISDIRECT][" + this.isDirect + "][ISBESTFIT][" + this.isBestFit + "]");
        if (!BBPoolConfManager.isLoggerDisabled()) {
            Thread t = new Thread(new BBPoolLogger());
            t.start();
        }
    }

    public void modifyBitSet(int start, int end, boolean bool) {
        for (int i = start; i < end; ++i) {
            if (bool) {
                this.bitset.set(i);
                continue;
            }
            this.bitset.clear(i);
        }
    }

    public void reset() {
        this.modifyBitSet(0, this.chunks, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer get(int requiredsize) {
        int requiredchunks = requiredsize / this.chunksize;
        int startchunk = -1;
        int endchunk = -1;
        int start = -1;
        int end = -1;
        if (requiredsize <= 0) {
            return null;
        }
        if (requiredsize % this.chunksize != 0) {
            ++requiredchunks;
        }
        Object object = this.bufferlock;
        synchronized (object) {
            long starttime = System.nanoTime();
            startchunk = this.getStartIndex(requiredchunks);
            if (startchunk >= 0) {
                endchunk = startchunk + requiredchunks;
                start = startchunk * this.chunksize;
                end = start + requiredsize;
                this.modifyBitSet(startchunk, endchunk, false);
                try {
                    this.masterbuffer.limit(end);
                    this.masterbuffer.position(start);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ByteBuffer resbuff = this.masterbuffer.slice();
                this.activebuffersize.addAndGet(resbuff.capacity());
                this.allocatedsize.addAndGet(resbuff.capacity());
                this.allocatedno.getAndIncrement();
                long timetaken = System.nanoTime() - starttime;
                this.alloctime.addAndGet(timetaken);
                return resbuff;
            }
            this.fatalerrorno.getAndIncrement();
            this.unpooledbuffersize.addAndGet(requiredsize);
            return null;
        }
    }

    public boolean checkAllocationGap() {
        return true;
    }

    public long getMasterBufferHash() {
        return this.masterhash;
    }

    public long hash(Object obj) {
        return System.identityHashCode(obj);
    }

    public boolean validateBuffer(ByteBuffer buffer) {
        if (buffer == null || buffer.isDirect() != this.isDirect) {
            return false;
        }
        if (WMSBBPoolUtil.getParentHash(buffer) != this.getMasterBufferHash()) {
            this.logger.info("[WMSBBPOOL][FATAL][RETURNED UNPOOLED BUFFER TO POOLED][MASTER HASH][" + this.masterhash + "][BUFFER PARENT HASH][" + WMSBBPoolUtil.getParentHash(buffer) + "]");
            return false;
        }
        return true;
    }

    public long getParentIndex(ByteBuffer buffer) {
        if (this.isDirect) {
            DirectBuffer directbuffer = (DirectBuffer)((Object)buffer);
            DirectBuffer parentbuffer = (DirectBuffer)directbuffer.attachment();
            long offset = directbuffer.address() - parentbuffer.address();
            return offset;
        }
        return buffer.arrayOffset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(ByteBuffer buffer) {
        int start = -1;
        int end = -1;
        int startchunk = -1;
        int endchunk = -1;
        if (buffer == null) {
            return false;
        }
        if (!this.validateBuffer(buffer)) {
            return false;
        }
        buffer.clear();
        start = (int)this.getParentIndex(buffer);
        end = start + buffer.capacity();
        startchunk = start / this.chunksize;
        endchunk = end / this.chunksize;
        if (end % this.chunksize != 0) {
            ++endchunk;
        }
        Object object = this.bufferlock;
        synchronized (object) {
            this.modifyBitSet(startchunk, endchunk, true);
            int bufferlen = end - start;
            int deallocbufflen = this.activebuffersize.get() - bufferlen;
            int chunklen = endchunk - startchunk;
            this.activebuffersize.set(deallocbufflen);
            this.deallocatedsize.addAndGet(bufferlen);
            this.deallocatedno.getAndIncrement();
        }
        return true;
    }

    public int getStartIndex(int requiredchunks) {
        if (this.isBestFit) {
            return this.getBestFitStartIndex(requiredchunks);
        }
        return this.getFirstFitStartIndex(requiredchunks);
    }

    public int getBestFitStartIndex(int requiredchunks) {
        int start = 0;
        int end = 0;
        int diff = Integer.MAX_VALUE;
        int selectedStart = -1;
        while ((start = this.bitset.nextSetBit(start)) >= 0) {
            end = this.bitset.nextClearBit(start);
            if (end - start == requiredchunks) {
                return start;
            }
            if (end - start > requiredchunks && end - start < diff) {
                diff = end - start;
                selectedStart = start;
            }
            start = end + 1;
        }
        return selectedStart;
    }

    public int getFirstFitStartIndex(int requiredchunks) {
        int start = 0;
        int end = 0;
        while ((start = this.bitset.nextSetBit(start)) >= 0) {
            end = this.bitset.nextClearBit(start);
            if (end - start >= requiredchunks) {
                return start;
            }
            start = end + 1;
        }
        return -1;
    }

    public int getActiveChunks() {
        return this.chunks - this.getFreeChunks();
    }

    public int getFreeChunks() {
        return this.bitset.cardinality();
    }

    public float getAllocPercentage() {
        int freechunks = this.getFreeChunks();
        float allocpercent = 100.0f - (float)freechunks / (float)this.chunks * 100.0f;
        return allocpercent;
    }

    public class BBPoolLogger
    implements Runnable {
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(1000 * BBPoolConfManager.getLogInterval());
                        int freechunks = WMSBBPool.this.getFreeChunks();
                        int activechunks = WMSBBPool.this.getActiveChunks();
                        int allocatedcount = WMSBBPool.this.allocatedno.get();
                        float allocpercent = WMSBBPool.this.getAllocPercentage();
                        float avgalloctime = 0.0f;
                        if (allocatedcount > 0) {
                            avgalloctime = (float)(WMSBBPool.this.alloctime.get() / (long)allocatedcount) / 100.0f;
                        }
                        WMSBBPool.this.logger.info("[WMSBBPool STATS][" + WMSBBPool.this.getMasterBufferHash() + "][ALLOCATED SIZE][" + WMSBBPool.this.allocatedsize.get() + " / " + WMSBBPool.this.allocatedno.get() + "][DEALLOCATED SIZE][" + WMSBBPool.this.deallocatedsize.get() + " / " + WMSBBPool.this.deallocatedno.get() + "][ACTIVE BUFFER SIZE][" + WMSBBPool.this.activebuffersize.get() + "][ACTIVE CHUNKS][" + activechunks + "][FREE CHUNKS][" + freechunks + "][AVG ALLOC TIME][" + avgalloctime + "][ALLOC PERCENT][" + allocpercent + "]");
                        StatsDB.addData("bbpoolstats", WMSBBPool.this.fatalerrorno.get(), WMSBBPool.this.allocatedsize.get(), WMSBBPool.this.allocatedno.get(), WMSBBPool.this.deallocatedsize.get(), WMSBBPool.this.deallocatedno.get(), WMSBBPool.this.unpooledbuffersize.get(), (long)avgalloctime, (long)allocpercent);
                        WMSBBPool.this.allocatedsize.set(0);
                        WMSBBPool.this.allocatedno.set(0);
                        WMSBBPool.this.deallocatedsize.set(0);
                        WMSBBPool.this.deallocatedno.set(0);
                        WMSBBPool.this.fatalerrorno.set(0);
                        WMSBBPool.this.unpooledbuffersize.set(0);
                        WMSBBPool.this.alloctime.set(0L);
                    }
                }
                catch (Exception e) {
                    WMSBBPool.this.logger.log(Level.SEVERE, "Error inside BBPoolLogger Thread.", e);
                    continue;
                }
                break;
            }
        }
    }
}

