/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.bbpool;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.servercommon.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BBPoolConfManager {
    private static Logger logger = Logger.getLogger(BBPoolConfManager.class.getName());
    private static String serverHome = null;
    private static String bbpoolPropfile;
    private static Properties bbpoolProp;
    private static boolean enablebbpool;
    private static boolean isdirectbb;
    private static boolean isbestfitbb;
    private static int loginterval;
    private static int maxallocpercentage;
    private static ArrayList poolconfigurations;
    private static boolean sessionpoolenabled;
    private static int sessionpoolchunkcount;
    private static int sessionpoolchunksize;
    private static boolean directsessionpoolenabled;
    private static int directsessionpoolchunkcount;
    private static int directsessionpoolchunksize;
    private static boolean disablelogger;

    public static boolean initialize() throws Exception {
        try {
            bbpoolProp = BBPoolConfManager.retrieveUpdatedConf(bbpoolPropfile, null);
            enablebbpool = Boolean.parseBoolean(bbpoolProp.getProperty("enablebbpool", "" + enablebbpool));
            disablelogger = Boolean.parseBoolean(bbpoolProp.getProperty("disablelogger", "" + disablelogger));
            isdirectbb = Boolean.parseBoolean(bbpoolProp.getProperty("isdirectbb", "" + isdirectbb));
            poolconfigurations = CommonUtil.getList((String)bbpoolProp.getProperty("poolconfigurations"));
            isbestfitbb = Boolean.parseBoolean(bbpoolProp.getProperty("isbestfitbb", "" + isbestfitbb));
            loginterval = Integer.parseInt(bbpoolProp.getProperty("loginterval", "" + loginterval));
            sessionpoolenabled = Boolean.parseBoolean(bbpoolProp.getProperty("sessionpoolenabled", "" + sessionpoolenabled));
            sessionpoolchunkcount = Integer.parseInt(bbpoolProp.getProperty("sessionpoolchunkcount", "" + sessionpoolchunkcount));
            sessionpoolchunksize = Integer.parseInt(bbpoolProp.getProperty("sessionpoolchunksize", "" + sessionpoolchunksize));
            directsessionpoolenabled = Boolean.parseBoolean(bbpoolProp.getProperty("directsessionpoolenabled", "" + directsessionpoolenabled));
            directsessionpoolchunkcount = Integer.parseInt(bbpoolProp.getProperty("directsessionpoolchunkcount", "" + directsessionpoolchunkcount));
            directsessionpoolchunksize = Integer.parseInt(bbpoolProp.getProperty("directsessionpoolchunksize", "" + directsessionpoolchunksize));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "[ERROR INITIALIZING BBPOOL CONF][DISABLING BB POOL]", e);
            BBPoolConfManager.disableBBPool();
            return false;
        }
        return true;
    }

    public static int getMaxAllocPercentage() {
        return maxallocpercentage;
    }

    public static boolean enableBBPool() {
        logger.info("[WMS BBPOOL CONFMANAGER][ENABLING BYTE BUFFER POOL]");
        enablebbpool = true;
        return enablebbpool;
    }

    public static boolean disableBBPool() {
        enablebbpool = false;
        logger.info("[WMS BBPOOL CONFMANAGER][DISABLING BYTE BUFFER POOL]");
        return enablebbpool;
    }

    public static boolean disableBestFitBB() {
        logger.info("[WMS BBPOOL CONFMANAGER][DISABLING BEST FIT ALOGRITHM ALLOCATION]");
        isbestfitbb = false;
        return isbestfitbb;
    }

    public static boolean enableBestFitBB() {
        logger.info("[WMS BBPOOL CONFMANAGER][ENABLING BEST FIT ALOGRITHM ALLOCATION]");
        isbestfitbb = true;
        return isbestfitbb;
    }

    public static ArrayList getBBPoolConfigurations() {
        return poolconfigurations;
    }

    public static boolean isBBPoolEnabled() {
        return enablebbpool;
    }

    public static boolean isLoggerDisabled() {
        return disablelogger;
    }

    public static boolean isDirectBBPool() {
        return isdirectbb;
    }

    public static boolean isBestFitBB() {
        return isbestfitbb;
    }

    public static int getLogInterval() {
        return loginterval;
    }

    public static boolean isSessionPoolEnabled() {
        return sessionpoolenabled;
    }

    public static int getSessionPoolChunkCount() {
        return sessionpoolchunkcount;
    }

    public static int getSessionPoolChunkSize() {
        return sessionpoolchunksize;
    }

    public static boolean isDirectSessionPoolEnabled() {
        return directsessionpoolenabled;
    }

    public static int getDirectSessionPoolChunkCount() {
        return directsessionpoolchunkcount;
    }

    public static int getDirectSessionPoolChunkSize() {
        return directsessionpoolchunksize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties retrieveUpdatedConf(String filePath, Object dbdata) {
        Properties props = FileUtil.getFileAsProperties(filePath);
        if (dbdata != null) {
            FileOutputStream fos = null;
            try {
                props.putAll((Map<?, ?>)((Hashtable)dbdata));
                fos = new FileOutputStream(filePath);
                props.store(fos, "$Id$");
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error while saving BBPool Conf in file. filePath=" + filePath, e);
            }
            finally {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
        return props;
    }

    static {
        serverHome = System.getProperty("server.home");
        bbpoolPropfile = serverHome + File.separator + "conf" + File.separator + "bbpool.properties";
        enablebbpool = true;
        isdirectbb = false;
        isbestfitbb = false;
        loginterval = 30;
        maxallocpercentage = 80;
        poolconfigurations = new ArrayList();
        sessionpoolenabled = false;
        sessionpoolchunkcount = 300;
        sessionpoolchunksize = 750;
        directsessionpoolenabled = false;
        directsessionpoolchunkcount = 300;
        directsessionpoolchunksize = 750;
        disablelogger = false;
    }
}

