/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.exception.WMSException;
import com.adventnet.wms.servercommon.WMSConfigTypes;
import com.adventnet.wms.servercommon.cassandra.WMSConfigCF;
import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;

public class WMSConfManager {
    private static String key = "Config_KEY";
    private static String wcv_keys = "wcvkeys";
    private static Logger logger = Logger.getLogger(WMSConfManager.class.getName());

    public static Hashtable get(DatastaxSession session, WMSConfigTypes type, String sertype) {
        try {
            return WMSConfigCF.get(session, key, type.toString(), sertype);
        }
        catch (Exception w) {
            logger.severe("unable to perform get operation on Configuration database-location not available");
            return new Hashtable();
        }
    }

    public static Hashtable get(DatastaxSession session, WMSConfigTypes type) throws Exception {
        return WMSConfManager.get(session, type, null);
    }

    public static void put(DatastaxSession session, WMSConfigTypes type, Hashtable data, String sertype) throws Exception {
        try {
            Hashtable confTable = WMSConfigCF.get(session, key, type.toString(), sertype);
            if (confTable == null) {
                logger.severe("Null data --> initializing database");
                confTable = data;
                if (data.get(wcv_keys) != null && confTable.get("wcv") == null) {
                    confTable.put("wcv", "0");
                }
                WMSConfigCF.put(session, key, type.toString(), sertype, data);
            } else {
                if (confTable.get(wcv_keys) != null) {
                    Hashtable validkeyhash = CommonUtil.getHash((String)((String)confTable.get(wcv_keys)));
                    Enumeration en = data.keys();
                    while (en.hasMoreElements()) {
                        if (!validkeyhash.containsKey(en.nextElement())) continue;
                        long wcv = 0L;
                        if (confTable.get("wcv") != null) {
                            wcv = Long.parseLong((String)confTable.get("wcv"));
                        }
                        data.remove("wcv");
                        confTable.put("wcv", "" + ++wcv);
                        break;
                    }
                }
                confTable.putAll(data);
                WMSConfigCF.put(session, key, type.toString(), sertype, confTable);
            }
        }
        catch (WMSException w) {
            logger.severe("Unable to perform put operation on Configuration database");
        }
    }

    public static void put(DatastaxSession session, WMSConfigTypes type, String prop, Object val, String sertype) throws Exception {
        try {
            Hashtable validkeyhash;
            Hashtable<String, Object> confTable = WMSConfigCF.get(session, key, type.toString(), sertype);
            if (confTable == null) {
                logger.severe("Null data --> initializing database");
                confTable = new Hashtable<String, Object>();
            } else if (confTable.get(wcv_keys) != null && (validkeyhash = CommonUtil.getHash((String)((String)confTable.get(wcv_keys)))).containsKey(prop)) {
                long wcv = 0L;
                if (confTable.get("wcv") != null) {
                    wcv = Long.parseLong((String)confTable.get("wcv"));
                }
                confTable.put("wcv", "" + ++wcv);
            }
            confTable.put(prop, val);
            WMSConfigCF.put(session, key, type.toString(), sertype, confTable);
        }
        catch (WMSException w) {
            logger.severe("Unable to perform put operation on Configuration database");
        }
    }

    public static void setWCVKeys(String wcvkeys) {
        wcv_keys = wcvkeys;
    }

    public static void delete(DatastaxSession session, WMSConfigTypes type, String prop, String sertype) throws Exception {
        try {
            Hashtable confTable = WMSConfigCF.get(session, key, type.toString(), sertype);
            if (confTable != null) {
                confTable.remove(prop);
                WMSConfigCF.put(session, key, type.toString(), sertype, confTable);
            }
        }
        catch (WMSException w) {
            logger.severe("unable to perform remove operation on configuration database");
        }
    }
}

