/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon;

import com.adventnet.wms.common.CommonUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class TraceLogConfManager {
    private static Logger logger = Logger.getLogger(TraceLogConfManager.class.getName());
    private static String serverHome = System.getProperty("server.home");
    private static String traceLogConf = serverHome + File.separator + "conf" + File.separator + "msgtracedebug.properties";
    private static ConcurrentHashMap<String, ArrayList> zuidDebugStatusMap = new ConcurrentHashMap();

    public static void initialize() {
        try {
            Properties traceLogConfProps = TraceLogConfManager.getProperties(traceLogConf);
            TraceLogConfManager.formatDebugStatusProps(traceLogConfProps);
        }
        catch (Exception ex) {
            logger.warning("Unable to initialize TraceLogConfManager " + ex.getMessage());
        }
    }

    private static void formatDebugStatusProps(Properties props) {
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String taskName = (String)en.nextElement();
            String zuids = props.getProperty(taskName);
            ArrayList list = CommonUtil.getList((String)zuids);
            zuidDebugStatusMap.put(taskName, list);
        }
    }

    private static Properties getProperties(String propsFile) {
        try {
            logger.info("Loading props " + propsFile);
            Properties props = new Properties();
            props.load(new FileInputStream(propsFile));
            return props;
        }
        catch (Exception exp) {
            logger.severe("Unable to load conf file " + propsFile);
            exp.printStackTrace();
            return null;
        }
    }

    public static void addZuidForDebug(String taskName, String zuids) {
        if (zuids == null || taskName == null) {
            return;
        }
        ArrayList list = CommonUtil.getList((String)zuids);
        if (!zuidDebugStatusMap.contains(taskName)) {
            zuidDebugStatusMap.put(taskName, list);
        } else {
            zuidDebugStatusMap.get(taskName).addAll(list);
        }
    }

    public static boolean isDebugEnabled(String taskName, String zuid) {
        if (taskName == null || zuid == null) {
            return false;
        }
        if (!zuidDebugStatusMap.containsKey(taskName)) {
            return false;
        }
        ArrayList zuidList = CommonUtil.getList((String)zuid);
        int size = zuidList.size();
        zuidList.removeAll(zuidDebugStatusMap.get(taskName));
        return zuidList.size() < size;
    }
}

