/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon;

import com.adventnet.wms.servercommon.FixedHashMap;
import java.util.HashMap;

public class TimedFixedMap<K, V>
extends FixedHashMap<K, V> {
    private long age = 300000L;

    public TimedFixedMap(int maxsize, long agesecs) {
        super(maxsize);
        this.age = agesecs * 1000L;
    }

    @Override
    public V get(Object key) {
        HashMap m = (HashMap)super.get(key);
        if (m == null) {
            return null;
        }
        if (System.currentTimeMillis() - (Long)m.get("time") > this.age) {
            this.remove(key);
            return null;
        }
        return m.get("data");
    }

    @Override
    public V put(K key, V value) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("time", System.currentTimeMillis());
        map.put("data", (Long)value);
        return (V)super.put(key, map);
    }
}

