/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TimeOutListener
extends Thread {
    private static Logger logger = Logger.getLogger(TimeOutListener.class.getName());
    private final Integer PUT = new Integer(1);
    private final Integer REMOVE = new Integer(2);
    private LinkedBlockingQueue<HashMap<String, Object>> queue = new LinkedBlockingQueue();
    private LinkedHashMap lru = new LinkedHashMap(100, 0.75f, true);
    private String threadName;
    private Tracker tracker;

    protected TimeOutListener(String thdName, long interval, long startdelay) {
        super("TimeOutListener/" + thdName + "-queue");
        this.threadName = thdName;
        this.start();
        this.tracker = new Tracker(thdName + "-tracker", interval, startdelay);
        this.tracker.start();
    }

    protected TimeOutListener(String thdName, long interval) {
        this(thdName, interval, interval);
    }

    public abstract boolean isExpired(Object var1);

    public abstract void handleExpired(ArrayList<Object> var1);

    public void touch(Object obj) {
        try {
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("obj", obj);
            entry.put("opr", this.PUT);
            this.queue.put(entry);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error queueing in TimeOutListener - touch;; ThreadName=" + this.threadName, e);
        }
    }

    public void remove(Object obj) {
        try {
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("obj", obj);
            entry.put("opr", this.REMOVE);
            this.queue.put(entry);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error queueing in TimeOutListener - remove;; ThreadName=" + this.threadName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    HashMap<String, Object> entry = this.queue.take();
                    LinkedHashMap linkedHashMap = this.lru;
                    synchronized (linkedHashMap) {
                        if ((Integer)entry.get("opr") == this.PUT) {
                            this.lru.put(entry.get("obj"), entry.get("obj"));
                        } else {
                            this.lru.remove(entry.get("obj"));
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error inside run thread of in TimeOutListener;; ThreadName=" + this.threadName, e);
                continue;
            }
            break;
        }
    }

    class Tracker
    extends Thread {
        private String thdName;
        private long interval;
        private long startdelay;

        public Tracker(String thdName, long interval, long startdelay) {
            super(thdName);
            this.interval = 0L;
            this.startdelay = 0L;
            this.thdName = thdName;
            this.interval = interval;
            this.startdelay = startdelay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.sleep(this.startdelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (true) {
                try {
                    while (true) {
                        ArrayList<Object> expList = new ArrayList<Object>();
                        LinkedHashMap linkedHashMap = TimeOutListener.this.lru;
                        synchronized (linkedHashMap) {
                            Iterator it = TimeOutListener.this.lru.values().iterator();
                            while (it.hasNext()) {
                                Object obj = it.next();
                                try {
                                    if (!TimeOutListener.this.isExpired(obj)) break;
                                    expList.add(obj);
                                    it.remove();
                                }
                                catch (Exception e1) {
                                    logger.log(Level.SEVERE, "Error inside Tracker for loop of listener =" + this.thdName, e1);
                                }
                            }
                        }
                        if (expList.size() > 0) {
                            TimeOutListener.this.handleExpired(expList);
                        }
                        Thread.sleep(this.interval);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error inside Tracker of listener =" + this.thdName, e);
                    continue;
                }
                break;
            }
        }
    }
}

