/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon;

import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;

public abstract class PersistableTimeOutListener
extends Thread {
    private static Logger logger = Logger.getLogger(PersistableTimeOutListener.class.getName());
    private static final Integer PUT = new Integer(1);
    private static final Integer PUTANDPERSIST = new Integer(2);
    private static final Integer REMOVE = new Integer(3);
    private static final String folder = ServerUtil.dataHome + "timeoutqueue" + File.separator;
    private LinkedBlockingQueue<HashMap> queue = new LinkedBlockingQueue();
    private LinkedHashMap<TouchObject, TouchObject> lru = new LinkedHashMap(100, 0.75f, true);
    private Tracker tracker;
    private String filepath;

    protected PersistableTimeOutListener(String thdName, long interval) {
        super("PersistableTimeOutListener/" + thdName + "-queue");
        this.start();
        this.tracker = new Tracker(thdName + "-tracker", interval);
        this.tracker.start();
        this.filepath = folder + thdName.toLowerCase() + ".tmt";
        File dir = new File(folder);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.loadQueueFromFile();
    }

    private void loadQueueFromFile() {
        try {
            logger.info("loading queue from file " + this.filepath);
            if (!FileUtil.isFileExists(this.filepath)) {
                return;
            }
            Properties props = ServerUtil.getProperties(this.filepath);
            Properties validprops = new Properties();
            if (props == null) {
                return;
            }
            Enumeration<Object> en = props.keys();
            while (en.hasMoreElements()) {
                String chid = (String)en.nextElement();
                boolean add = Boolean.parseBoolean(props.getProperty(chid));
                if (!add) continue;
                this.add(chid);
                validprops.setProperty(chid, "" + add);
            }
            validprops.store(new FileOutputStream(this.filepath), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void crunchFile() {
        try {
            Properties props = ServerUtil.getProperties(this.filepath);
            Properties validprops = new Properties();
            if (props == null) {
                return;
            }
            Enumeration<Object> en = props.keys();
            while (en.hasMoreElements()) {
                String chid = (String)en.nextElement();
                boolean add = Boolean.parseBoolean(props.getProperty(chid));
                if (!add) continue;
                validprops.setProperty(chid, "" + add);
            }
            validprops.store(new FileOutputStream(this.filepath), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addtoFile(String touchstr, boolean addorremove) {
        try {
            Properties props = ServerUtil.getProperties(this.filepath);
            if (props == null) {
                props = new Properties();
            }
            props.setProperty(touchstr, "" + addorremove);
            props.store(new FileOutputStream(this.filepath), null);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public abstract boolean isExpired(String var1, long var2);

    public abstract void handleExpired(ArrayList var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, Long> getLRUStats() {
        long current_time = System.currentTimeMillis();
        Hashtable<String, Long> stats = new Hashtable<String, Long>();
        stats.put("0", 0L);
        stats.put("5", 0L);
        stats.put("10", 0L);
        stats.put("15", 0L);
        stats.put("20", 0L);
        stats.put("25", 0L);
        LinkedHashMap<TouchObject, TouchObject> linkedHashMap = this.lru;
        synchronized (linkedHashMap) {
            for (TouchObject to : this.lru.values()) {
                long time = current_time - to.getTouchedTime();
                try {
                    long key = Math.round(Math.floor((time /= 60000L) / 5L) * 5.0);
                    if (key > 25L) continue;
                    stats.put("" + key, stats.get("" + key) + 1L);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            stats.put("total", new Long(this.lru.size()));
        }
        return stats;
    }

    protected static final void init() {
    }

    private void add(String touchstr) {
        try {
            TouchObject to = new TouchObject(touchstr);
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("obj", to);
            entry.put("opr", PUT);
            this.queue.put(entry);
        }
        catch (Exception e) {
            logger.warning("Error queueing in TimeOutListener - add");
        }
    }

    public void touch(String touchstr) {
        try {
            TouchObject to = new TouchObject(touchstr);
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("obj", to);
            entry.put("opr", PUTANDPERSIST);
            this.queue.put(entry);
        }
        catch (Exception e) {
            logger.warning("Error queueing in TimeOutListener - touch");
        }
    }

    public void remove(String touchstr) {
        try {
            TouchObject to = new TouchObject(touchstr);
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("obj", to);
            entry.put("opr", REMOVE);
            this.queue.put(entry);
        }
        catch (Exception e) {
            logger.warning("Error queueing in TimeOutListener - remove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                HashMap entry = this.queue.take();
                LinkedHashMap<TouchObject, TouchObject> linkedHashMap = this.lru;
                synchronized (linkedHashMap) {
                    TouchObject to = (TouchObject)entry.get("obj");
                    int opr = (Integer)entry.get("opr");
                    if (opr == PUTANDPERSIST) {
                        TouchObject val = this.lru.put(to, to);
                        if (val == null) {
                            this.addtoFile(to.getString(), true);
                        }
                    } else if (opr == PUT) {
                        this.lru.put(to, to);
                    } else {
                        this.lru.remove(to);
                        this.addtoFile(to.getString(), false);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    static class TouchObject {
        String touchstr = null;
        long touchtime = -1L;

        public TouchObject(String touchstr) {
            this.touchstr = touchstr;
            this.touchtime = System.currentTimeMillis();
        }

        public void updateTime() {
            this.touchtime = System.currentTimeMillis();
        }

        public long getTouchedTime() {
            return this.touchtime;
        }

        public String getString() {
            return this.touchstr;
        }

        public boolean equals(Object to) {
            if (to instanceof TouchObject) {
                return this.touchstr.equals(((TouchObject)to).getString());
            }
            return false;
        }

        public int hashCode() {
            return this.touchstr.hashCode();
        }

        public String toString() {
            return "touchstr=" + this.touchstr + "|touchtime=" + this.touchtime;
        }
    }

    class Tracker
    extends Thread {
        private long interval;

        public Tracker(String thdName, long interval) {
            super(thdName);
            this.interval = 0L;
            this.interval = interval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Tracker.sleep(this.interval);
                        ArrayList<String> expList = new ArrayList<String>();
                        LinkedHashMap linkedHashMap = PersistableTimeOutListener.this.lru;
                        synchronized (linkedHashMap) {
                            Iterator it = PersistableTimeOutListener.this.lru.values().iterator();
                            while (it.hasNext()) {
                                TouchObject to = (TouchObject)it.next();
                                long touchtime = to.getTouchedTime();
                                String touchstr = to.getString();
                                try {
                                    if (!PersistableTimeOutListener.this.isExpired(touchstr, touchtime)) break;
                                    expList.add(touchstr);
                                    PersistableTimeOutListener.this.addtoFile(touchstr, false);
                                    it.remove();
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                        if (expList.size() <= 0) continue;
                        PersistableTimeOutListener.this.handleExpired(expList);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

