/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon;

import java.util.logging.Logger;

public class IPUtil {
    private static int radix = 29;
    private static Logger logger = Logger.getLogger(IPUtil.class.getName());

    public static String encode(String ipstr) {
        String ip = IPUtil.reformIP(ipstr);
        logger.fine("Given :: " + ipstr + " Reformed IP " + ip);
        long l = Long.parseLong(ip);
        String encoded = Long.toString(l, radix);
        logger.fine("Given :: " + ipstr + " Encoded :: " + encoded);
        return encoded;
    }

    public static String decode(String hash) {
        String decoded = (Long.valueOf(hash, radix) + "").replaceFirst("3", "");
        logger.fine("Hash :: " + hash + " Decoded :: " + decoded);
        StringBuffer decIP = new StringBuffer();
        String tempdec = decoded.trim();
        while (tempdec.length() >= 3) {
            decIP.append(Integer.parseInt(tempdec.substring(0, 3)));
            if (tempdec.length() > 3) {
                decIP.append(".");
            }
            tempdec = tempdec.substring(3, tempdec.length());
        }
        logger.fine("Hash :: " + hash + " Return IP :: " + decIP.toString());
        return decIP.toString();
    }

    public static String reformIP(String ip) {
        String[] s = ip.trim().split("\\.");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length; ++i) {
            String temp = s[i];
            while (temp.length() < 3) {
                temp = "0" + temp;
            }
            sb.append(temp);
        }
        String reformedIP = "3" + sb.toString();
        return reformedIP;
    }
}

