/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;

public abstract class ConstantTimeOutListener
extends Thread {
    private static Logger logger = Logger.getLogger(ConstantTimeOutListener.class.getName());
    private final Integer put = new Integer(1);
    private final Integer remove = new Integer(2);
    private LinkedBlockingQueue<HashMap> queue = new LinkedBlockingQueue();
    private LinkedHashMap lru = new LinkedHashMap(100, 0.75f, true);
    private Tracker tracker;

    protected ConstantTimeOutListener(String thdName, long interval, long startdelay) {
        super("ConstantTimeOutListener/" + thdName + "-queue");
        this.start();
        this.tracker = new Tracker(thdName + "-tracker", interval, startdelay);
        this.tracker.start();
    }

    protected ConstantTimeOutListener(String thdName, long interval) {
        this(thdName, interval, interval);
    }

    public abstract void handleExpired(ArrayList var1);

    public void touch(String key) {
        try {
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("obj", key);
            entry.put("opr", this.put);
            this.queue.put(entry);
        }
        catch (Exception e) {
            logger.warning("Error queueing in TimeOutListener - touch");
        }
    }

    public void remove(String key) {
        try {
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("obj", key);
            entry.put("opr", this.remove);
            this.queue.put(entry);
        }
        catch (Exception e) {
            logger.warning("Error queueing in TimeOutListener - remove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    HashMap entry = this.queue.take();
                    LinkedHashMap linkedHashMap = this.lru;
                    synchronized (linkedHashMap) {
                        if ((Integer)entry.get("opr") == this.put) {
                            if (!this.lru.containsKey(entry.get("obj"))) {
                                this.lru.put(entry.get("obj"), System.currentTimeMillis());
                            }
                        } else {
                            this.lru.remove(entry.get("obj"));
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    class Tracker
    extends Thread {
        private long interval;
        private long startdelay;

        public Tracker(String thdName, long interval, long startdelay) {
            super(thdName);
            this.interval = 0L;
            this.startdelay = 0L;
            this.interval = interval;
            this.startdelay = startdelay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Tracker.sleep(this.startdelay);
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (true) {
                try {
                    while (true) {
                        ArrayList expList = new ArrayList();
                        LinkedHashMap linkedHashMap = ConstantTimeOutListener.this.lru;
                        synchronized (linkedHashMap) {
                            Iterator it = ConstantTimeOutListener.this.lru.entrySet().iterator();
                            while (it.hasNext()) {
                                Map.Entry entry = it.next();
                                try {
                                    if (System.currentTimeMillis() - (Long)entry.getValue() < this.startdelay) break;
                                    expList.add(entry.getKey());
                                    it.remove();
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                        if (expList.size() > 0) {
                            ConstantTimeOutListener.this.handleExpired(expList);
                        }
                        Tracker.sleep(this.interval);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

