/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon;

import com.adventnet.wms.common.util.CommonWMSUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BufferedQueue {
    private static Logger logger = Logger.getLogger(BufferedQueue.class.getName());
    private Vector inQ;
    private Vector outQ;
    private int qSize;
    private int dataFilesStartCount = 0;
    private int dataFilesEndCount = 0;
    private String fileName;
    private File directory;
    private long incounter = 0L;
    private long outcounter = 0L;
    private long previncounter = 0L;
    private long prevoutcounter = 0L;
    private boolean freezeQ = false;
    private final int DEFAULT_SIZE = 500;
    private boolean clearStats = false;
    private int createdfiles = 0;
    private int proccesdfiles = 0;
    private long savetofiletime = 0L;
    private long loadfromfiletime = 0L;

    public BufferedQueue(String strDir, String fileName, int qSize) {
        this.inQ = new Vector(qSize);
        this.qSize = qSize > 0 ? qSize : 500;
        this.directory = new File(strDir + File.separator);
        if (!this.directory.isDirectory()) {
            this.directory.mkdirs();
        }
        if (!this.directory.exists()) {
            throw new IllegalArgumentException(strDir + " temp directory does not exist");
        }
        this.fileName = fileName;
        this.resetFileCounts();
        File memFile = this.getMemFile();
        if (memFile.exists()) {
            this.outQ = this.loadFromFile(memFile);
        }
        while (this.outQ == null && this.dataFilesEndCount > this.dataFilesStartCount) {
            this.outQ = this.loadFromFile(this.getNextReadFile());
        }
        if (this.outQ == null) {
            this.outQ = new Vector(qSize);
        }
    }

    public synchronized boolean add(Object obj) {
        if (this.freezeQ) {
            return false;
        }
        if (this.inQ.size() >= this.qSize) {
            int tryCount;
            for (tryCount = 0; !this.saveToFile(this.inQ, this.getNextWriteFile()) && tryCount < 10; ++tryCount) {
            }
            if (tryCount == 10) {
                return false;
            }
            this.inQ.removeAllElements();
        }
        ++this.incounter;
        this.inQ.add(obj);
        return true;
    }

    public synchronized Object get() {
        if (this.freezeQ) {
            return null;
        }
        if (this.outQ.size() == 0) {
            if (this.dataFilesEndCount > this.dataFilesStartCount) {
                this.outQ = this.loadFromFile(this.getNextReadFile());
                while (this.outQ == null && this.dataFilesEndCount > this.dataFilesStartCount) {
                    this.outQ = this.loadFromFile(this.getNextReadFile());
                }
                if (this.outQ == null) {
                    this.outQ = this.inQ;
                    this.inQ = new Vector(this.qSize);
                    if (this.outQ.size() == 0) {
                        return null;
                    }
                }
            } else {
                this.outQ = this.inQ;
                this.inQ = new Vector(this.qSize);
                if (this.outQ.size() == 0) {
                    return null;
                }
            }
        }
        ++this.outcounter;
        return this.outQ.remove(0);
    }

    public Vector getNextBatch() {
        throw new UnsupportedOperationException("Allowed only for Buffers of type BATCH");
    }

    public synchronized void close() {
        this.freezeQ = true;
        if (this.inQ.size() > 0) {
            this.saveToFile(this.inQ, this.getNextWriteFile());
        }
        if (this.outQ.size() > 0) {
            this.saveToFile(this.outQ, this.getMemFile());
        }
        this.inQ.removeAllElements();
        this.outQ.removeAllElements();
    }

    public synchronized void open() {
        this.freezeQ = false;
    }

    public synchronized boolean isEmpty() {
        if (this.freezeQ) {
            return true;
        }
        return this.inQ.size() <= 0 && this.outQ.size() <= 0 && this.dataFilesEndCount <= this.dataFilesStartCount;
    }

    public synchronized int size() {
        if (this.freezeQ) {
            return 0;
        }
        return this.inQ.size() + this.outQ.size() + (this.dataFilesEndCount - this.dataFilesStartCount) * this.qSize;
    }

    public Hashtable getStats() {
        Hashtable<String, String> stats = new Hashtable<String, String>();
        stats.put("in", "" + this.incounter);
        stats.put("out", "" + this.outcounter);
        stats.put("bqname", this.fileName);
        int cursize = this.size();
        stats.put("size", "" + cursize);
        stats.put("overflow", "" + (cursize > this.qSize));
        return stats;
    }

    public Hashtable getWmsQStats() {
        Hashtable<String, String> stats = new Hashtable<String, String>();
        stats.put("in", "" + Math.abs(this.incounter - this.previncounter));
        stats.put("out", "" + Math.abs(this.outcounter - this.prevoutcounter));
        stats.put("bqname", this.fileName);
        int cursize = this.size();
        stats.put("size", "" + cursize);
        stats.put("overflow", "" + (cursize > this.qSize));
        stats.put("createdfiles", "" + this.createdfiles);
        stats.put("proccesdfiles", "" + this.proccesdfiles);
        stats.put("remainingfiles", "" + (this.dataFilesEndCount - this.dataFilesStartCount));
        stats.put("savetofiletime", "" + this.savetofiletime);
        stats.put("loadfromfiletime", "" + this.loadfromfiletime);
        if (this.clearStats) {
            this.incounter = 0L;
            this.outcounter = 0L;
            this.clearStats = false;
        }
        this.createdfiles = 0;
        this.proccesdfiles = 0;
        this.savetofiletime = 0L;
        this.loadfromfiletime = 0L;
        this.previncounter = this.incounter;
        this.prevoutcounter = this.outcounter;
        return stats;
    }

    public void clearStats() {
        this.clearStats = true;
    }

    private synchronized File getNextWriteFile() {
        File file = new File(this.directory, this.fileName + this.dataFilesEndCount + ".dmp");
        ++this.dataFilesEndCount;
        return file;
    }

    private synchronized File getNextReadFile() {
        File file = new File(this.directory, this.fileName + this.dataFilesStartCount + ".dmp");
        ++this.dataFilesStartCount;
        return file;
    }

    private synchronized File getMemFile() {
        File file = new File(this.directory, "MEMORY.dmp");
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean saveToFile(Vector persistV, File file) {
        FileOutputStream fout = null;
        ObjectOutputStream out = null;
        long stime = System.currentTimeMillis();
        try {
            fout = new FileOutputStream(file);
            out = new ObjectOutputStream(fout);
            out.writeObject(persistV);
            out.flush();
            ++this.createdfiles;
        }
        catch (NotSerializableException nse) {
            logger.severe("Not Serializable error occurred while writing to back up file in Queue. Queue Size : " + persistV.size());
            try {
                Iterator it = persistV.iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (CommonWMSUtil.isSerializable(obj)) continue;
                    it.remove();
                    logger.info("Non Serializable Element which caused the NotSerializable error while writing in file" + obj);
                }
                logger.info("After removing non serializable elements: Queue Size :" + persistV.size());
                try {
                    if (fout != null) {
                        fout.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                fout = new FileOutputStream(file);
                out = new ObjectOutputStream(fout);
                out.writeObject(persistV);
                out.flush();
                ++this.createdfiles;
            }
            catch (Exception exp) {
                logger.log(Level.SEVERE, "Unable to write the data in File from Queue after two tries", exp);
                exp.printStackTrace();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to write the vector to file", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        out = null;
        fout = null;
        this.savetofiletime += System.currentTimeMillis() - stime;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Vector loadFromFile(File file) {
        FileInputStream fin = null;
        ObjectInputStream oin = null;
        Vector persistV = null;
        long stime = System.currentTimeMillis();
        try {
            fin = new FileInputStream(file);
            oin = new ObjectInputStream(fin);
            persistV = (Vector)oin.readObject();
            ++this.proccesdfiles;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (oin != null) {
                    oin.close();
                }
                if (fin != null) {
                    fin.close();
                }
                this.deleteFile(file);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        this.loadfromfiletime += System.currentTimeMillis() - stime;
        return persistV;
    }

    public synchronized void deleteFile(File file) {
        if (file.exists()) {
            file.delete();
        }
    }

    private synchronized void resetFileCounts() {
        int min = -1;
        int max = -1;
        File[] fileList = this.directory.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            String currFile = fileList[i].getName();
            if (!currFile.startsWith(this.fileName)) continue;
            String baseName = currFile.substring(this.fileName.length(), currFile.length() - 4);
            int currVal = Integer.parseInt(baseName);
            if (currVal <= min || min == -1) {
                min = currVal;
            }
            if (currVal < max && max != -1) continue;
            max = currVal + 1;
        }
        if (min != -1) {
            this.dataFilesStartCount = min;
        }
        if (max != -1) {
            this.dataFilesEndCount = max;
        }
    }
}

