/*
 * Decompiled with CFR 0.152.
 */
package avaya.com.zohocorp.zoho.ztiimpl.utils;

import avaya.com.zohocorp.zoho.ztiimpl.utils.CallUtilities;
import com.avaya.jtapi.tsapi.ITsapiConnIDPrivate;
import com.avaya.jtapi.tsapi.LucentCallInfo;
import com.avaya.jtapi.tsapi.LucentV5CallInfo;
import com.avaya.jtapi.tsapi.UserToUserInfo;
import com.zohocorp.zoho.ztiadapter.ZTIAdapter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.telephony.Call;
import javax.telephony.CallEvent;
import javax.telephony.ConnectionEvent;
import javax.telephony.Event;
import javax.telephony.MultiCallMetaEvent;
import javax.telephony.TerminalConnectionEvent;
import javax.telephony.callcontrol.CallControlConnectionEvent;
import javax.telephony.callcontrol.CallControlTerminalConnectionEvent;

public class ZTICallUtil {
    private static Logger logger = Logger.getLogger(ZTICallUtil.class.getName());

    public static int getStateNo(CallControlConnectionEvent arg0) throws Exception {
        return arg0.getConnection().getState();
    }

    public static int getStateNo(ConnectionEvent arg0) throws Exception {
        return arg0.getConnection().getState();
    }

    public static int getStateNo(TerminalConnectionEvent arg0) throws Exception {
        return arg0.getTerminalConnection().getState();
    }

    public static int getStateNo(CallControlTerminalConnectionEvent arg0) throws Exception {
        return arg0.getTerminalConnection().getState();
    }

    public static int getStateNo(CallEvent arg0) throws Exception {
        return arg0.getCall().getState();
    }

    public static String getAESCallId(CallControlTerminalConnectionEvent arg0) throws Exception {
        return CallUtilities.getCallID(arg0.getCall()) + "";
    }

    public static String getAESCallId(CallControlConnectionEvent arg0) throws Exception {
        return CallUtilities.getCallID(arg0.getCall()) + "";
    }

    public static String getAESCallId(ConnectionEvent arg0) throws Exception {
        return CallUtilities.getCallID(arg0.getCall()) + "";
    }

    public static String getAESCallId(TerminalConnectionEvent arg0) throws Exception {
        return CallUtilities.getCallID(arg0.getCall()) + "";
    }

    public static String getAESCallId(CallEvent arg0) throws Exception {
        return CallUtilities.getCallID(arg0.getCall()) + "";
    }

    public static String getAESCallId(MultiCallMetaEvent arg0) throws Exception {
        return CallUtilities.getCallID(arg0.getNewCall()) + "";
    }

    public static String getAESCallId(Call arg0) throws Exception {
        return CallUtilities.getCallID(arg0) + "";
    }

    public static void printSendNotification(String aesCallId, String fromNumber, String toNumber, String callState) {
        logger.log(Level.INFO, "AESCallId_" + aesCallId + " = " + callState + "-->" + fromNumber + " && " + toNumber);
    }

    public static String generateCallRefId(String aesCallId) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = new Date();
        String dateStr = dateFormat.format(date);
        String callRefId = aesCallId + "_" + dateStr;
        return callRefId;
    }

    public static String checkAndGenerateCallRefID(String callrefid, String fromNumber, String toNumber) {
        try {
            if (callrefid == null || Long.parseLong(callrefid) == 0L) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                Date date = new Date();
                String dateval = dateFormat.format(date);
                callrefid = fromNumber + "_" + toNumber + "_" + dateval;
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error in generating callrefid. Error =>" + e);
        }
        logger.log(Level.INFO, "checkandgen callrefid - " + callrefid);
        return callrefid;
    }

    public static String getCallRefId(LucentV5CallInfo event) {
        String callrefid = "";
        if (event instanceof LucentV5CallInfo) {
            callrefid = event.getUCID();
            logger.log(Level.INFO, "getCallRefId - UCID of the Call is : " + callrefid);
        }
        return callrefid;
    }

    public static boolean checkNotNull(Object obj) {
        return obj != null && !"null".equals(obj) && !"".equals(obj);
    }

    public static void printCallRefIds(LucentV5CallInfo event) {
        int eventId = 0;
        String ucId = "";
        String uui = "";
        try {
            UserToUserInfo avayaUUI = null;
            if (event instanceof Event) {
                eventId = ((Event)event).getID();
            }
            if (event instanceof LucentV5CallInfo) {
                ucId = event.getUCID();
            }
            if (event instanceof ITsapiConnIDPrivate) {
                logger.log(Level.INFO, "Callid ==>" + ((ITsapiConnIDPrivate)event).getTsapiConnectionID().getCallID());
            }
            if (event instanceof LucentCallInfo) {
                avayaUUI = event.getUserToUserInfo();
                uui = avayaUUI != null ? "  UUI ==> " + avayaUUI.getString() + "\n\n" : "  UUI: <none>";
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "print ucid, Exception ==>" + e);
        }
        logger.log(Level.INFO, "==============print for UID=====================eventid=" + eventId + ", uui=" + uui + ", ucid=" + ucId);
    }

    public Hashtable<String, String> decideCallType(String fromNumber, String toNumber) {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        String fromzuid = ZTIAdapter.getUserforExtension((String)fromNumber);
        String tozuid = ZTIAdapter.getUserforExtension((String)toNumber);
        if (fromzuid != null) {
            if (tozuid != null) {
                return null;
            }
            ht.put("calltype", "outgoing");
            ht.put("zuid", fromzuid);
            return ht;
        }
        if (tozuid != null) {
            ht.put("calltype", "incoming");
            ht.put("zuid", tozuid);
            return ht;
        }
        return null;
    }
}

