/*
 * Decompiled with CFR 0.152.
 */
package avaya.com.zohocorp.zoho.ztiimpl.utils;

import avaya.com.zohocorp.zoho.ztiimpl.utils.JsonSimpleReadExample;
import avaya.com.zohocorp.zoho.ztiimpl.utils.JsonSimpleWriteExample;
import avaya.com.zohocorp.zoho.ztiimpl.utils.LRUCache;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class FileHandler<K, V> {
    private static String homeDir = "../logs/ZDCalls";
    private static String fileFmt = ".json";
    private static int maxHrs = 4;
    private static String createdDir = "";
    private static Hashtable<String, String> callIdVsFileName = new Hashtable();
    private LRUCache<String, Integer> retryIdVsCount = new LRUCache(10);
    private static int maxRetry = 3;
    private static Logger logger = Logger.getLogger(FileHandler.class.getName());

    public FileHandler(String homeDir, int maxHrs) {
        FileHandler.homeDir = homeDir;
        FileHandler.maxHrs = maxHrs;
        this.updateDirs();
    }

    public void updateCallDetails(String aesCallId, JSONObject obj) {
        String fileName;
        this.checkAndDeleteOldDir();
        int currentHrs = Calendar.getInstance().get(11);
        if (callIdVsFileName.containsKey(aesCallId)) {
            fileName = callIdVsFileName.get(aesCallId);
        } else {
            long currentTimeInMS = Calendar.getInstance().getTimeInMillis();
            fileName = aesCallId + "_" + currentTimeInMS + fileFmt;
        }
        callIdVsFileName.put(aesCallId, fileName);
        this.createDir(homeDir + "/" + currentHrs);
        try {
            JsonSimpleWriteExample.writeFile(homeDir + "/" + currentHrs + "/", fileName, obj);
        }
        catch (IOException e) {
            this.updateDirs();
            this.retry(aesCallId, obj);
            logger.log(Level.WARNING, "Exception occuried in updateCallDetails", e);
        }
    }

    private void retry(String aesCallId, JSONObject obj) {
        int count;
        int n = count = this.retryIdVsCount.containsKey(aesCallId) ? (Integer)this.retryIdVsCount.get(aesCallId) : 0;
        if (count < maxRetry) {
            this.retryIdVsCount.put(aesCallId, count++);
            this.updateCallDetails(aesCallId, obj);
        }
    }

    public String getCallDetailsString(String aesCallId) {
        String callDetails = null;
        Calendar cal = Calendar.getInstance();
        for (int i = 0; i < maxHrs; ++i) {
            cal.add(10, -i);
            int currentHrs = cal.get(11);
            String dirName = homeDir + "/" + currentHrs;
            if (!createdDir.contains(dirName)) continue;
            String fileName = callIdVsFileName.get(aesCallId);
            if (fileName != null) {
                callDetails = JsonSimpleReadExample.getFileString(dirName, fileName);
            }
            if (callDetails == null) continue;
            logger.log(Level.INFO, "File exists ..." + callDetails);
            break;
        }
        return callDetails;
    }

    private File createDir(String name) {
        if (!createdDir.contains(name)) {
            File directory = new File(name);
            if (directory.exists()) {
                createdDir = createdDir + directory + "#";
                logger.log(Level.INFO, directory + " Directory already exists ...");
                return directory;
            }
            logger.log(Level.INFO, "Directory doesn't exists, creating now");
            if (directory.mkdir()) {
                createdDir = createdDir + directory + "#";
                logger.log(Level.INFO, "Successfully created new directory :" + directory);
                return directory;
            }
            logger.log(Level.WARNING, "Failed to create new directory : " + directory);
            return directory;
        }
        return null;
    }

    private void updateDirs() {
        createdDir = "";
        File homeDirFile = this.createDir(homeDir);
        this.removeOldDirs(homeDirFile);
    }

    private void removeOldDirs(File oldDirs) {
        if (oldDirs != null && oldDirs.exists()) {
            Calendar cal = Calendar.getInstance();
            ArrayList<String> dontRemoveDirList = new ArrayList<String>(maxHrs);
            for (int i = 0; i < maxHrs; ++i) {
                int currentHrs = cal.get(11);
                dontRemoveDirList.add(currentHrs + "");
                cal.add(10, -1);
            }
            for (File sub : oldDirs.listFiles()) {
                if (!sub.isDirectory()) continue;
                String dirName = sub.getName();
                if (!dontRemoveDirList.contains(dirName)) {
                    this.deleteDirWithFiles(sub);
                    continue;
                }
                createdDir = createdDir + homeDir + "/" + dirName + "#";
            }
        }
    }

    private boolean checkAndDeleteOldDir() {
        Calendar cal = Calendar.getInstance();
        cal.add(10, -maxHrs);
        int currentHrs = cal.get(11);
        String dirName = homeDir + "/" + currentHrs;
        if (createdDir.contains(dirName)) {
            File oldDir = new File(dirName);
            this.deleteDirWithFiles(oldDir);
        }
        return Boolean.TRUE;
    }

    private boolean deleteDirWithFiles(File element) {
        if (element.isDirectory()) {
            for (File sub : element.listFiles()) {
                String fileName = sub.getName();
                callIdVsFileName.remove(fileName.split("_")[0]);
                this.deleteDirWithFiles(sub);
            }
            logger.log(Level.INFO, "Successfully deleted Directory :" + element);
        } else {
            logger.log(Level.INFO, "Successfully deleted File :" + element);
        }
        createdDir = createdDir.replaceAll(element.getName() + "#", "");
        element.delete();
        return Boolean.TRUE;
    }

    public void updateCallDetails(K key, V value) {
        try {
            if (value != null) {
                this.updateCallDetails((String)key, new JSONObject(value.toString()));
            }
        }
        catch (JSONException e) {
            logger.log(Level.WARNING, "exception occured in updateCallDetails ", e);
        }
    }
}

