/*
 * Decompiled with CFR 0.152.
 */
package avaya.com.zohocorp.zoho.ztiimpl.utils;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfManager {
    private static Logger logger = Logger.getLogger(ConfManager.class.getName());
    private static String serverConfFile = "";
    private static String servername = null;
    private static String username = null;
    private static String passwd = null;
    private static String port = null;
    private static String homeDir = "../logs/ZDCalls";
    private static boolean debug = Boolean.FALSE;
    private static int lruCacheSize = 11;
    private static int maxCallLoggingHrs = 4;
    private static int totalNoOfServers = 1;
    private static boolean retryWhenPBXDown = Boolean.TRUE;
    private static int retryInterval = 60000;
    private static String allServerIP_port;

    public static boolean initialize(String confpath) {
        return ConfManager.initialize(confpath, 0);
    }

    public static boolean initialize(String confpath, int serverIdx) {
        serverConfFile = confpath + File.separator + "conf" + File.separator + "avaya.properties";
        try {
            Properties serverConf = ConfManager.getProperties(serverConfFile);
            ConfManager.setTotalNoOfServers(serverConf.getProperty("avaya.server.totalcount") == null || Integer.valueOf(serverConf.getProperty("avaya.server.totalcount")) < 1 ? ConfManager.getTotalNoOfServers() : Integer.valueOf(serverConf.getProperty("avaya.server.totalcount")));
            serverIdx = serverIdx < ConfManager.getTotalNoOfServers() ? serverIdx : 0;
            String serverIdxStr = serverIdx == 0 ? "" : "." + serverIdx;
            int tempServerIdx = serverIdx + 1;
            logger.log(Level.INFO, "Loading server({0}) props & totalNoOfServers : {1}", new Object[]{tempServerIdx, ConfManager.getTotalNoOfServers()});
            servername = serverConf.getProperty("avaya.server" + serverIdxStr);
            username = serverConf.getProperty("avaya.manager.username" + serverIdxStr);
            passwd = serverConf.getProperty("avaya.manager.password" + serverIdxStr);
            port = serverConf.getProperty("avaya.port" + serverIdxStr);
            homeDir = serverConf.getProperty("avaya.calls.directory") == null ? homeDir : serverConf.getProperty("avaya.calls.directory");
            debug = Boolean.valueOf(serverConf.getProperty("avaya.debug"));
            lruCacheSize = serverConf.getProperty("avaya.calls.maxcallspermins") == null ? lruCacheSize : Integer.valueOf(serverConf.getProperty("avaya.calls.maxcallspermins"));
            lruCacheSize = lruCacheSize <= 5 ? 11 : lruCacheSize;
            int n = maxCallLoggingHrs = serverConf.getProperty("avaya.calls.maxcalllogginghrs") == null ? maxCallLoggingHrs : Integer.valueOf(serverConf.getProperty("avaya.calls.maxcalllogginghrs"));
            maxCallLoggingHrs = maxCallLoggingHrs < 4 ? 4 : (maxCallLoggingHrs >= 12 ? 12 : maxCallLoggingHrs);
            ConfManager.setRetryWhenPBXDown(Boolean.valueOf(serverConf.getProperty("avaya.server.down.retry.interval")));
            ConfManager.setRetryInterval(serverConf.getProperty("avaya.server.down.retry.interval") == null ? ConfManager.getRetryInterval() : Integer.valueOf(serverConf.getProperty("avaya.server.down.retry.interval")) * 1000);
            ConfManager.setRetryInterval(ConfManager.getRetryInterval() < 30000 ? 30000 : ConfManager.getRetryInterval());
            ConfManager.setAllServerIP_port(ConfManager.generateAllServerIP_port(ConfManager.getTotalNoOfServers(), serverConf));
            logger.log(Level.INFO, "Loaded server({0}) - IP Address [{1}], User Name [{2}], Password [{3}],port [{4}]", new Object[]{tempServerIdx, servername, username, passwd, port});
            return true;
        }
        catch (Exception exp) {
            logger.log(Level.WARNING, "*****ConfManger.initialize method error*****", exp);
            return false;
        }
    }

    private static String generateAllServerIP_port(int totalNoOfServers, Properties serverConf) {
        String allServerIP_port = "";
        for (int i = 0; i < totalNoOfServers; ++i) {
            String serverIdxStr = i == 0 ? "" : "." + i;
            String servername = serverConf.getProperty("avaya.server" + serverIdxStr);
            String port = serverConf.getProperty("avaya.port" + serverIdxStr);
            allServerIP_port = allServerIP_port + servername + ":" + port + ",";
        }
        return allServerIP_port;
    }

    public static Properties getProperties(String propsFile) {
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(propsFile));
            return props;
        }
        catch (Exception exp) {
            logger.log(Level.WARNING, "Unable to load conf file : " + propsFile);
            logger.log(Level.WARNING, "*****ConfManger.initialize method error*****", exp);
            return null;
        }
    }

    public static String getServerName() {
        return servername;
    }

    public static String getManagerUserName() {
        return username;
    }

    public static String getManagerPasswd() {
        return passwd;
    }

    public static String getPort() {
        return port;
    }

    public static boolean getDebug() {
        return debug;
    }

    public static String getHomeDir() {
        return homeDir;
    }

    public static int getLRUCacheSize() {
        return lruCacheSize;
    }

    public static int getMaxHrs() {
        return maxCallLoggingHrs;
    }

    public static int getTotalNoOfServers() {
        return totalNoOfServers;
    }

    public static void setTotalNoOfServers(int totalNoOfServers) {
        ConfManager.totalNoOfServers = totalNoOfServers;
    }

    public static boolean isRetryWhenPBXDown() {
        return retryWhenPBXDown;
    }

    public static void setRetryWhenPBXDown(boolean retryWhenPBXDown) {
        ConfManager.retryWhenPBXDown = retryWhenPBXDown;
    }

    public static int getRetryInterval() {
        return retryInterval;
    }

    public static void setRetryInterval(int retryInterval) {
        ConfManager.retryInterval = retryInterval;
    }

    public static String getAllServerIP_port() {
        return allServerIP_port;
    }

    public static void setAllServerIP_port(String allServerIP_port) {
        ConfManager.allServerIP_port = allServerIP_port;
    }
}

