/*
 * Decompiled with CFR 0.152.
 */
package avaya.com.zohocorp.zoho.ztiimpl.utils;

import com.avaya.jtapi.tsapi.ITsapiCallIDPrivate;
import com.avaya.jtapi.tsapi.LucentCallInfo;
import com.avaya.jtapi.tsapi.LucentV7CallInfo;
import com.avaya.jtapi.tsapi.V7DeviceHistoryEntry;
import javax.telephony.Call;
import javax.telephony.callcenter.ACDAddress;

public class CallUtilities {
    public static String getCallACDAddressName(Call call) {
        if (call instanceof LucentCallInfo) {
            LucentCallInfo lucentCall = (LucentCallInfo)call;
            ACDAddress address = lucentCall.getDeliveringACDAddress();
            return address != null ? address.getName() : null;
        }
        return null;
    }

    public static short getCallEventCause(Call call) {
        if (call instanceof LucentV7CallInfo) {
            LucentV7CallInfo lucentCall = (LucentV7CallInfo)call;
            V7DeviceHistoryEntry[] deviceHistory = lucentCall.getDeviceHistory();
            if (deviceHistory == null || deviceHistory[0] == null) {
                return -1;
            }
            return deviceHistory[0].getEventCause();
        }
        return -1;
    }

    public static long getCallID(Call c) {
        return c == null ? 0 : ((ITsapiCallIDPrivate)c).getTsapiCallID();
    }

    public static long getOldCallID(Call call) {
        if (call instanceof LucentV7CallInfo) {
            LucentV7CallInfo lucentCall = (LucentV7CallInfo)call;
            V7DeviceHistoryEntry[] deviceHistory = lucentCall.getDeviceHistory();
            try {
                if (deviceHistory.length == 0 || deviceHistory[0].getOldConnectionID() == null) {
                    return 0L;
                }
                return deviceHistory[0].getOldConnectionID().getCallID();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public static String getOldDeviceID(Call call) {
        if (call instanceof LucentV7CallInfo) {
            LucentV7CallInfo lucentCall = (LucentV7CallInfo)call;
            V7DeviceHistoryEntry[] deviceHistory = lucentCall.getDeviceHistory();
            try {
                return deviceHistory[0].getOldDeviceID();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }
}

