/*
 * Decompiled with CFR 0.152.
 */
package avaya.com.zohocorp.zoho.ztiimpl.listener;

import avaya.com.zohocorp.zoho.ztiimpl.handlers.CTICallsHandler2;
import avaya.com.zohocorp.zoho.ztiimpl.utils.ZTICallUtil;
import com.avaya.jtapi.tsapi.adapters.CallControlTerminalConnectionListenerAdapter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.telephony.Call;
import javax.telephony.CallEvent;
import javax.telephony.Connection;
import javax.telephony.ConnectionEvent;
import javax.telephony.MetaEvent;
import javax.telephony.MultiCallMetaEvent;
import javax.telephony.TerminalConnectionEvent;
import javax.telephony.callcontrol.CallControlConnectionEvent;
import javax.telephony.callcontrol.CallControlTerminalConnectionEvent;

public class CCTCEventsListener
extends CallControlTerminalConnectionListenerAdapter {
    private static Logger logger = Logger.getLogger(CCTCEventsListener.class.getName());
    private CTICallsHandler2 callsHandler;
    private static boolean debug = Boolean.FALSE;

    public CCTCEventsListener() {
        this.callsHandler = new CTICallsHandler2();
    }

    public CCTCEventsListener(boolean debug) {
        CCTCEventsListener.debug = debug;
        this.callsHandler = new CTICallsHandler2();
    }

    public CCTCEventsListener(CTICallsHandler2 callsHandler, boolean debug) {
        CCTCEventsListener.debug = debug;
        this.callsHandler = callsHandler;
    }

    public void connectionAlerting(CallControlConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "Ringing", "3C1");
    }

    public void connectionDialing(CallControlConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "Ringing", "3C2");
    }

    public void connectionInitiated(CallControlConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "Ringing", "3C3");
    }

    public void connectionNetworkAlerting(CallControlConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "Ringing", "3C4");
    }

    public void connectionNetworkReached(CallControlConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "Ringing", "3C5");
    }

    public void connectionEstablished(CallControlConnectionEvent arg0) {
        try {
            CCTCEventsListener.printLog(arg0, "Ringing & Answered", "3C6", (boolean)Boolean.TRUE);
            String aesCallId = ZTICallUtil.getAESCallId(arg0);
            if (this.callsHandler.getCallReceivedTime(aesCallId) == 0L) {
                String callState = "callreceived";
                String fromNumber = arg0.getCallingAddress().getName();
                String toNumber = arg0.getCalledAddress().getName();
                this.callsHandler.updateFromToNumbers(aesCallId, fromNumber, toNumber).handleCallStateChange(aesCallId, callState);
            } else {
                this.triggerCallAnsweredActions(aesCallId);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception 3C6E--> ", e);
        }
    }

    public void connectionOffered(CallControlConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "??????", "3C7");
    }

    public void connectionQueued(CallControlConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "??????", "3C8");
    }

    public void connectionUnknown(CallControlConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "??????", "3C9");
    }

    public void connectionDisconnected(CallControlConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "Hungup", "3C10");
    }

    public void connectionFailed(CallControlConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "Hungup", "3C11");
    }

    public void callActive(CallEvent arg0) {
        try {
            CCTCEventsListener.printLog(arg0, "Ringing", "CL1", (boolean)Boolean.TRUE);
            Connection[] tsapiConn = arg0.getCall().getConnections();
            String aesCallId = ZTICallUtil.getAESCallId(arg0);
            String fromNumber = tsapiConn[0].getAddress().getName();
            if (tsapiConn.length == 2) {
                String toNumber = tsapiConn[1].getAddress().getName();
                logger.log(Level.INFO, "Ringing ~~~~~> CL1-Inbound ----->" + aesCallId);
                logger.log(Level.INFO, "AESCallId => From & To : " + aesCallId + " => " + fromNumber + " ===> " + toNumber);
                this.callsHandler.updateFromToNumbers(aesCallId, fromNumber, toNumber);
            } else {
                logger.log(Level.INFO, "Ringing ~~~~~> CL1-Outbound ----->" + aesCallId);
                logger.log(Level.INFO, "AESCallId => From & To : " + aesCallId + " => " + fromNumber + " ===> null");
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception CL1E--> ", e);
        }
    }

    public void callEventTransmissionEnded(CallEvent arg0) {
        try {
            CCTCEventsListener.printLog(arg0, "Hungup", "CL2", (boolean)Boolean.TRUE);
            String aesCallId = ZTICallUtil.getAESCallId(arg0);
            this.callsHandler.deleteCallDetails(aesCallId);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception CL2E--> ", e);
        }
    }

    public void callInvalid(CallEvent arg0) {
        CCTCEventsListener.printLog(arg0, "??????", "CL3");
    }

    public void multiCallMetaMergeEnded(MetaEvent arg0) {
        try {
            MultiCallMetaEvent mcme = (MultiCallMetaEvent)arg0;
            String aesCallId_newCall = ZTICallUtil.getAESCallId(mcme);
            String aesCallId_oldCall = null;
            this.callsHandler.addToConferenceCall(aesCallId_newCall);
            Call[] oldCalls = mcme.getOldCalls();
            if (oldCalls != null) {
                for (int i = 0; i < oldCalls.length; ++i) {
                    Call oldCall = oldCalls[i];
                    String aesCallId_oldCall1 = ZTICallUtil.getAESCallId(oldCall);
                    if (aesCallId_newCall.equals(aesCallId_oldCall1)) continue;
                    aesCallId_oldCall = aesCallId_oldCall1;
                    this.callsHandler.addToConferenceCall(aesCallId_oldCall1);
                }
            }
            if (aesCallId_newCall != null && aesCallId_oldCall != null && !aesCallId_newCall.equals(aesCallId_oldCall)) {
                logger.log(Level.WARNING, "Call Merged ended -> {0} to {1} ", new Object[]{aesCallId_oldCall, aesCallId_newCall});
                this.callsHandler.updateConferenceJoined(aesCallId_newCall, aesCallId_oldCall);
                this.callsHandler.handleConferenceCall(aesCallId_newCall, aesCallId_oldCall);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception multiCallMetaMergeEnded--> ", e);
        }
    }

    public void multiCallMetaMergeStarted(MetaEvent arg0) {
        try {
            MultiCallMetaEvent mcme = (MultiCallMetaEvent)arg0;
            String aesCallId_newCall = ZTICallUtil.getAESCallId(mcme);
            String aesCallId_oldCall = null;
            this.callsHandler.addToConferenceCall(aesCallId_newCall);
            Call[] oldCalls = mcme.getOldCalls();
            if (oldCalls != null) {
                for (int i = 0; i < oldCalls.length; ++i) {
                    Call oldCall = oldCalls[i];
                    String aesCallId_oldCall1 = ZTICallUtil.getAESCallId(oldCall);
                    if (aesCallId_newCall.equals(aesCallId_oldCall1)) continue;
                    aesCallId_oldCall = aesCallId_oldCall1;
                    this.callsHandler.addToConferenceCall(aesCallId_oldCall1);
                }
            }
            if (aesCallId_newCall != null && aesCallId_oldCall != null && !aesCallId_newCall.equals(aesCallId_oldCall)) {
                logger.log(Level.WARNING, "Call Merged started -> {0} to {1} ", new Object[]{aesCallId_oldCall, aesCallId_newCall});
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception multiCallMetaMergeStarted--> ", e);
        }
    }

    public void multiCallMetaTransferEnded(MetaEvent arg0) {
        try {
            MultiCallMetaEvent mcme = (MultiCallMetaEvent)arg0;
            String aesCallId_newCall = ZTICallUtil.getAESCallId(mcme);
            String aesCallId_oldCall = null;
            this.callsHandler.addToTransferCall(aesCallId_newCall);
            Call[] oldCalls = mcme.getOldCalls();
            if (oldCalls != null) {
                for (int i = 0; i < oldCalls.length; ++i) {
                    Call oldCall = oldCalls[i];
                    String aesCallId_oldCall1 = ZTICallUtil.getAESCallId(oldCall);
                    if (aesCallId_newCall.equals(aesCallId_oldCall1)) continue;
                    aesCallId_oldCall = aesCallId_oldCall1;
                    this.callsHandler.addToTransferCall(aesCallId_oldCall1);
                }
            }
            if (aesCallId_newCall != null && aesCallId_oldCall != null && !aesCallId_newCall.equals(aesCallId_oldCall)) {
                logger.log(Level.WARNING, "Call transfered ended -> {0} to {1} ", new Object[]{aesCallId_oldCall, aesCallId_newCall});
                this.callsHandler.updateTransferCompleted(aesCallId_newCall, aesCallId_oldCall);
                this.callsHandler.handleTransferCall(aesCallId_newCall, aesCallId_oldCall);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception multiCallMetaTransferEnded--> ", e);
        }
    }

    public void multiCallMetaTransferStarted(MetaEvent arg0) {
        try {
            MultiCallMetaEvent mcme = (MultiCallMetaEvent)arg0;
            String aesCallId_newCall = ZTICallUtil.getAESCallId(mcme);
            String aesCallId_oldCall = null;
            this.callsHandler.addToTransferCall(aesCallId_newCall);
            Call[] oldCalls = mcme.getOldCalls();
            if (oldCalls != null) {
                for (int i = 0; i < oldCalls.length; ++i) {
                    Call oldCall = oldCalls[i];
                    String aesCallId_oldCall1 = ZTICallUtil.getAESCallId(oldCall);
                    if (aesCallId_newCall.equals(aesCallId_oldCall1)) continue;
                    aesCallId_oldCall = aesCallId_oldCall1;
                    this.callsHandler.addToTransferCall(aesCallId_oldCall1);
                }
            }
            if (aesCallId_newCall != null && aesCallId_oldCall != null && !aesCallId_newCall.equals(aesCallId_oldCall)) {
                logger.log(Level.WARNING, "Call transfered started -> {0} to {1} ", new Object[]{aesCallId_oldCall, aesCallId_newCall});
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception multiCallMetaTransferStarted--> ", e);
        }
    }

    public void singleCallMetaProgressEnded(MetaEvent arg0) {
    }

    public void singleCallMetaProgressStarted(MetaEvent arg0) {
    }

    public void singleCallMetaSnapshotEnded(MetaEvent arg0) {
    }

    public void singleCallMetaSnapshotStarted(MetaEvent arg0) {
    }

    public void connectionAlerting(ConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "Ringing", "C1");
    }

    public void connectionCreated(ConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "Ringing", "C2");
    }

    public void connectionConnected(ConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "Ringing & Answered", "C3");
    }

    public void connectionInProgress(ConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "Ringing", "C4");
    }

    public void connectionUnknown(ConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "?????", "C5");
    }

    public void connectionDisconnected(ConnectionEvent arg0) {
        try {
            CCTCEventsListener.printLog(arg0, "Hungup", "C6", (boolean)Boolean.TRUE);
            String aesCallId = ZTICallUtil.getAESCallId(arg0);
            this.triggerCallEndActions(aesCallId);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception C6E--> ", e);
        }
    }

    public void connectionFailed(ConnectionEvent arg0) {
        try {
            CCTCEventsListener.printLog(arg0, "Hungup", "C7", (boolean)Boolean.TRUE);
            String aesCallId = ZTICallUtil.getAESCallId(arg0);
            this.triggerCallEndActions(aesCallId);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception C7E--> ", e);
        }
    }

    public void terminalConnectionRinging(TerminalConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "Ringing", "TC1");
    }

    public void terminalConnectionCreated(TerminalConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "Ringing", "TC2");
    }

    public void terminalConnectionActive(TerminalConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "Ringing & Answered", "TC3");
    }

    public void terminalConnectionUnknown(TerminalConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "??????", "TC4");
    }

    public void terminalConnectionDropped(TerminalConnectionEvent arg0) {
        try {
            CCTCEventsListener.printLog(arg0, "Hungup", "TC5", (boolean)Boolean.TRUE);
            String aesCallId = ZTICallUtil.getAESCallId(arg0);
            this.triggerCallEndActions(aesCallId);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception TC5E--> ", e);
        }
    }

    public void terminalConnectionPassive(TerminalConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "??????", "TC6");
    }

    public void terminalConnectionRinging(CallControlTerminalConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "Ringing", "CCTC1");
    }

    public void terminalConnectionBridged(CallControlTerminalConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "Ringing", "CCTC2");
    }

    public void terminalConnectionTalking(CallControlTerminalConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "Ringing & Answered", "CCTC3");
    }

    public void terminalConnectionHeld(CallControlTerminalConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "Hold", "CCTC4", true);
    }

    public void terminalConnectionUnknown(CallControlTerminalConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "??????", "CCTC5");
    }

    public void terminalConnectionDropped(CallControlTerminalConnectionEvent arg0) {
        try {
            CCTCEventsListener.printLog(arg0, "Hungup", "CCTC6", (boolean)Boolean.TRUE);
            String aesCallId = ZTICallUtil.getAESCallId(arg0);
            this.triggerCallEndActions(aesCallId);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception CCTC6E--> ", e);
        }
    }

    public void terminalConnectionInUse(CallControlTerminalConnectionEvent arg0) {
        CCTCEventsListener.printLog(arg0, "??????", "CCTC7");
    }

    private void triggerCallAnsweredActions(String aesCallId) {
        if (this.callsHandler.getCallAnsweredTime(aesCallId) == 0L) {
            String callState = "callconnected";
            this.callsHandler.handleCallStateChange(aesCallId, callState);
        } else {
            logger.log(Level.INFO, "Tried to trigger duplicate notifiation triggerCallAnsweredActions -->" + aesCallId);
        }
    }

    private void triggerCallEndActions(String aesCallId) {
        boolean isCallInConf = this.callsHandler.isCallInConference(aesCallId);
        if (this.callsHandler.getCallHungupTime(aesCallId) == 0L && !isCallInConf) {
            String callState = "callended";
            this.callsHandler.handleConferenceCallEnd(aesCallId);
            this.callsHandler.handleCallStateChange(aesCallId, callState).deleteCallDetails(aesCallId);
        } else {
            logger.log(Level.INFO, "Tried to trigger duplicate notifiation triggerCallEndActions -->" + aesCallId);
        }
    }

    private static void printLog(CallControlTerminalConnectionEvent arg0, String state, String eventId) {
        CCTCEventsListener.printLog(arg0, state, eventId, debug);
    }

    private static void printLog(CallControlTerminalConnectionEvent arg0, String state, String eventId, boolean track) {
        if (track) {
            try {
                logger.log(Level.INFO, state + " ~~~~~> " + eventId + " ----->" + ZTICallUtil.getStateNo(arg0));
                if (arg0.getCalledAddress() != null && arg0.getCallingAddress() != null) {
                    logger.log(Level.INFO, "AESCallId => From & To : {0} => {1} ===> {2}", new Object[]{ZTICallUtil.getAESCallId(arg0), arg0.getCallingAddress().getName(), arg0.getCalledAddress().getName()});
                } else if (arg0.getCallingAddress() != null) {
                    logger.log(Level.INFO, "AESCallId => From {0} => {1}", new Object[]{ZTICallUtil.getAESCallId(arg0), arg0.getCallingAddress().getName()});
                } else if (arg0.getCalledAddress() != null) {
                    logger.log(Level.INFO, "AESCallId => From {0} => {1}", new Object[]{ZTICallUtil.getAESCallId(arg0), arg0.getCalledAddress().getName()});
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception --> ", e);
            }
        }
    }

    private static void printLog(CallEvent arg0, String state, String eventId) {
        CCTCEventsListener.printLog(arg0, state, eventId, debug);
    }

    private static void printLog(CallEvent arg0, String state, String eventId, boolean track) {
        if (track) {
            try {
                logger.log(Level.INFO, state + " ~~~~~> " + eventId + " ----->" + ZTICallUtil.getStateNo(arg0));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception --> ", e);
            }
        }
    }

    private static void printLog(ConnectionEvent arg0, String state, String eventId) {
        CCTCEventsListener.printLog(arg0, state, eventId, debug);
    }

    private static void printLog(ConnectionEvent arg0, String state, String eventId, boolean track) {
        if (track) {
            try {
                String from_to = arg0.getConnection().getAddress().getName();
                logger.log(Level.INFO, state + " ~~~~~> " + eventId + " ----->" + ZTICallUtil.getStateNo(arg0));
                logger.log(Level.INFO, "AESCallId => From & To : " + ZTICallUtil.getAESCallId(arg0) + " => " + from_to + " ===> " + from_to);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception --> ", e);
            }
        }
    }

    private static void printLog(TerminalConnectionEvent arg0, String state, String eventId) {
        CCTCEventsListener.printLog(arg0, state, eventId, debug);
    }

    private static void printLog(TerminalConnectionEvent arg0, String state, String eventId, boolean track) {
        if (track) {
            try {
                logger.log(Level.INFO, state + " ~~~~~> " + eventId + " ----->" + ZTICallUtil.getStateNo(arg0));
                logger.log(Level.INFO, "AESCallId => From & To : " + ZTICallUtil.getAESCallId(arg0) + " => " + arg0.getTerminalConnection().getConnection().getAddress().getName() + " ===> " + arg0.getTerminalConnection().getTerminal().getName());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception --> ", e);
            }
        }
    }

    private static void printLog(CallControlConnectionEvent arg0, String state, String eventId) {
        CCTCEventsListener.printLog(arg0, state, eventId, debug);
    }

    private static void printLog(CallControlConnectionEvent arg0, String state, String eventId, boolean track) {
        if (track) {
            try {
                logger.log(Level.INFO, state + " ~~~~~> " + eventId + " ----->" + ZTICallUtil.getStateNo(arg0));
                if (arg0.getCalledAddress() != null && arg0.getCallingAddress() != null) {
                    logger.log(Level.INFO, "AESCallId => From & To : " + ZTICallUtil.getAESCallId(arg0) + " => " + arg0.getCallingAddress().getName() + " ===> " + arg0.getCalledAddress().getName());
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception --> ", e);
            }
        }
    }
}

