/*
 * Decompiled with CFR 0.152.
 */
package avaya.com.zohocorp.zoho.ztiimpl.handlers;

import avaya.com.zohocorp.zoho.ztiimpl.handlers.CTICallsHandler2;
import avaya.com.zohocorp.zoho.ztiimpl.handlers.ZTIProvider;
import avaya.com.zohocorp.zoho.ztiimpl.listener.CCTCEventsListener;
import avaya.com.zohocorp.zoho.ztiimpl.utils.ConfManager;
import com.avaya.jtapi.tsapi.TsapiResourceUnavailableException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.telephony.Address;
import javax.telephony.Call;
import javax.telephony.CallListener;
import javax.telephony.Connection;
import javax.telephony.PlatformException;
import javax.telephony.Terminal;
import javax.telephony.TerminalConnection;
import javax.telephony.callcontrol.CallControlTerminalConnection;

public class ZTITerminal {
    private static Logger logger = Logger.getLogger(ZTITerminal.class.getName());
    private ZTIProvider ztiProvider;
    private Terminal myTerminal;
    private CTICallsHandler2 callsHandler;
    private Address myAddress;
    private int extnBatchSize = 20;

    public ZTITerminal() {
        this._init(new ZTIProvider());
    }

    public ZTITerminal(ZTIProvider ztiProvider) {
        this._init(ztiProvider);
    }

    public void addTerminalListeners(Hashtable userextns) throws Exception {
        logger.log(Level.INFO, "addTerminalListeners - Extensions configured in Zoho ==>{0} ", userextns);
        logger.log(Level.INFO, "provider state = {0}", this.getZtiProvider().getProvider().getState());
        if (userextns.size() < this.extnBatchSize) {
            String callingExt = null;
            Enumeration ext_keys = userextns.keys();
            while (ext_keys.hasMoreElements()) {
                callingExt = (String)ext_keys.nextElement();
                this.addTerminalListeners(callingExt);
            }
        } else {
            this.batchUpdation_addTerminalListeners(userextns);
        }
    }

    public void addTerminalListeners(String extn) {
        logger.log(Level.INFO, "Extn to add terminal listener ==> {0}", extn);
        try {
            this.myAddress = this.getZtiProvider().getProvider().getAddress(extn);
            logger.log(Level.INFO, "provider.getAddress success = {0}", this.myAddress);
            this.myTerminal = this.getZtiProvider().getProvider().getTerminal(extn);
            logger.log(Level.INFO, "provider.getTerminal success = {0}", this.myTerminal);
            logger.log(Level.INFO, "Address & Terminal created successfully for extn = {0}", extn);
            this.myTerminal.addCallListener((CallListener)new CCTCEventsListener(this.callsHandler, ConfManager.getDebug()));
        }
        catch (TsapiResourceUnavailableException te) {
            logger.log(Level.INFO, "Please verify that extension {0} is correct:: ### EXCEPTION OCCURED ###  error code = {1} & error type = {2} {3}", new Object[]{extn, te.getErrorCode(), te.getErrorType(), te});
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Please verify that extension {0} is correct:: {1}", new Object[]{extn, e});
        }
    }

    public void removeTerminalListeners(Hashtable userextns) throws Exception {
        Enumeration ext_keys = userextns.keys();
        while (ext_keys.hasMoreElements()) {
            String callingExt = (String)ext_keys.nextElement();
            try {
                this.myTerminal = this.getZtiProvider().getProvider().getTerminal(callingExt);
                Object[] listeners = this.myTerminal.getCallListeners();
                logger.log(Level.INFO, "removeTerminalListeners => {0}", listeners);
                if (listeners == null) continue;
                for (int i = 0; i < listeners.length; ++i) {
                    logger.log(Level.INFO, "Going to remove the Listener for terminal => {0}", listeners[i]);
                    this.myTerminal.removeCallListener((CallListener)listeners[i]);
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Error in remove Terminal Listener => {0} & Error Message: {1} ", new Object[]{e, e.getMessage()});
            }
        }
    }

    public boolean makeCall(String fromNumber, String toNumber, Hashtable attachments) {
        logger.log(Level.INFO, "New code - Going to make outgoing call from {0} to {1}. Attachments => {2}", new Object[]{fromNumber, toNumber, attachments});
        String myExtension = fromNumber;
        String dialCode = "";
        try {
            dialCode = (String)attachments.get("dialCode");
            if (dialCode != null && !"null".equals(dialCode)) {
                toNumber = dialCode + toNumber;
                logger.log(Level.INFO, "Prefix Dialcode to be added = {0}", dialCode);
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error in getting dialcode {0}", e);
        }
        try {
            logger.log(Level.INFO, "We already added call listener to the terminal so getting terminal only");
            Terminal myTerminal1 = this.getZtiProvider().getProvider().getTerminal(myExtension);
            Call call = this.getZtiProvider().getProvider().createCall();
            logger.log(Level.INFO, "myTerminal = {0}, myTerminal1.getAddresses() = {1}, otherExtension = {2}", new Object[]{myTerminal1, myTerminal1.getAddresses()[0], toNumber});
            call.connect(myTerminal1, myTerminal1.getAddresses()[0], toNumber);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error in createCall - call connect - ### EXCEPTION OCCURED #### {0}", e);
            return false;
        }
        return true;
    }

    public void disconnect() {
        TerminalConnection[] terminalConnections = null;
        boolean found = false;
        Connection connection = null;
        try {
            terminalConnections = this.myTerminal.getTerminalConnections();
            if (terminalConnections != null) {
                if (terminalConnections.length == 1) {
                    connection = terminalConnections[0].getConnection();
                    this.disconnect(connection);
                } else {
                    for (int i = 0; i < terminalConnections.length; ++i) {
                        if (((CallControlTerminalConnection)terminalConnections[i]).getCallControlState() != 98) continue;
                        found = true;
                        connection = terminalConnections[i].getConnection();
                        this.disconnect(connection);
                    }
                    if (!found) {
                        logger.log(Level.INFO, "There are no Connections in the Talking state");
                    }
                }
            }
        }
        catch (PlatformException e) {
            logger.log(Level.WARNING, " Terminal.getTerminalConnections() caught PlatformException {0}", e);
        }
    }

    private void disconnect(Connection connection) {
        if (connection != null) {
            try {
                connection.disconnect();
                logger.log(Level.INFO, "Successfully disconnected connection at address {0}", connection.getAddress().getName());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Connection.disconnect() caught {0}", e);
                return;
            }
        }
    }

    private void _init(ZTIProvider ztiProvider) {
        this.setZtiProvider(ztiProvider);
        this.getZtiProvider().addProviderListener();
        this.callsHandler = new CTICallsHandler2();
    }

    public ZTIProvider getZtiProvider() {
        return this.ztiProvider;
    }

    public void setZtiProvider(ZTIProvider ztiProvider) {
        this.ztiProvider = ztiProvider;
    }

    private void batchUpdation_addTerminalListeners(Hashtable userextns) {
        List<List<String>> extnsBatch = this.splitIntoSeparateBatch(userextns);
        logger.log(Level.INFO, "extnsBatch {0}", extnsBatch);
        for (List<String> batch : extnsBatch) {
            AddTerminalListeners_Batch thread = new AddTerminalListeners_Batch(batch);
            thread.start();
        }
    }

    private List<List<String>> splitIntoSeparateBatch(Hashtable userextns) {
        int batchSize = this.extnBatchSize;
        ArrayList<List<String>> extnsBatch = new ArrayList<List<String>>();
        Enumeration ext_keys = userextns.keys();
        int j = 0;
        while (ext_keys.hasMoreElements()) {
            if (j != 1 && j % batchSize == 0) {
                extnsBatch.add(new ArrayList());
            }
            int batchNo = Integer.parseInt(j / batchSize + "");
            List batch = (List)extnsBatch.get(batchNo);
            String extn = (String)ext_keys.nextElement();
            batch.add(extn);
            ++j;
        }
        return extnsBatch;
    }

    class AddTerminalListeners_Batch
    extends Thread {
        List<String> batch;

        public AddTerminalListeners_Batch(List<String> batch) {
            super("AddTerminalListeners_Batch");
            this.batch = batch;
        }

        @Override
        public void run() {
            try {
                logger.log(Level.INFO, "Thread {0} is running for the Batch {1}", new Object[]{Thread.currentThread().getId(), this.batch});
                for (String extn : this.batch) {
                    logger.log(Level.INFO, "Add Terminal Listener for the Extn - {0} via the thread {1}", new Object[]{extn, Thread.currentThread().getId()});
                    ZTITerminal.this.addTerminalListeners(extn);
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Exception in Multithreading via addTerminalListeners");
            }
        }
    }
}

