/*
 * Decompiled with CFR 0.152.
 */
package avaya.com.zohocorp.zoho.ztiimpl.handlers;

import avaya.com.zohocorp.zoho.ztiimpl.listener.ZTIProviderListener;
import avaya.com.zohocorp.zoho.ztiimpl.utils.ConfManager;
import com.zohocorp.zoho.ztiadapter.TeleAdapterEngine;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.telephony.JtapiPeer;
import javax.telephony.JtapiPeerFactory;
import javax.telephony.JtapiPeerUnavailableException;
import javax.telephony.Provider;
import javax.telephony.ProviderListener;

public class ZTIProvider {
    private static Logger logger = Logger.getLogger(ZTIProviderListener.class.getName());
    private Provider provider;
    private JtapiPeer jtapiPeer;

    public ZTIProvider() {
        try {
            if (ConfManager.isRetryWhenPBXDown()) {
                TeleAdapterEngine.stopMonitoring();
            }
            TeleAdapterEngine.setTotalNoOfServers((int)ConfManager.getTotalNoOfServers());
            TeleAdapterEngine.setRetryIntravelTime((int)ConfManager.getRetryInterval());
            this.jtapiPeer = this.getJTAPIPeer();
            this.provider = this.jtapiPeer.getProvider(this.getProviderStr());
            logger.log(Level.INFO, "Got provider");
        }
        catch (Exception e) {
            TeleAdapterEngine.startRetry();
            logger.log(Level.WARNING, "Exception in getProvider or addProviderListener ==> ", e);
        }
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void addProviderListener() {
        ZTIProviderListener listener = new ZTIProviderListener();
        this.addProviderListener(listener);
    }

    public void addProviderListener(ProviderListener listener) {
        logger.log(Level.INFO, "going to add providerlistener ...");
        try {
            this.getProvider().addProviderListener(listener);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception in getProvider or addProviderListener ==> ", e);
        }
    }

    private JtapiPeer getJTAPIPeer() throws Exception {
        JtapiPeer peer = null;
        try {
            peer = JtapiPeerFactory.getJtapiPeer(null);
        }
        catch (JtapiPeerUnavailableException e) {
            try {
                peer = JtapiPeerFactory.getJtapiPeer((String)"com.avaya.jtapi.tsapi.TsapiPeer");
            }
            catch (JtapiPeerUnavailableException e2) {
                logger.log(Level.WARNING, "JtapiPeerFactory.getJtapiPeer: caught JtapiPeerUnavailableException", e2);
                logger.log(Level.WARNING, "Error: JtapiPeer could not be created.  Verify your Jtapi client install");
                throw e2;
            }
        }
        logger.log(Level.INFO, "Created Peer ==> " + peer);
        return peer;
    }

    private String getTSAPILinkName() throws Exception {
        Object tsapiLinkname = null;
        try {
            System.setProperty("com.avaya.jtapi.tsapi.servers", ConfManager.getAllServerIP_port());
            Object[] services = this.jtapiPeer.getServices();
            logger.log(Level.INFO, "Services List got from JtapiPeer ===>{0} && its length ==> {1}", new Object[]{Arrays.toString(services), services.length});
            if (services.length == 0) {
                logger.log(Level.INFO, "Services list is empty, so can't get Tsapi link name ...");
                logger.log(Level.INFO, "Unable to get Tsapi Link name");
            } else {
                tsapiLinkname = services[0];
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception Block ==============> Unable to get Services List from JtapiPeer.");
            logger.log(Level.WARNING, "*****ZTIAvayaImpl.newlogin error*****", e);
            throw e;
        }
        logger.log(Level.INFO, "Using TSAPI link " + (String)tsapiLinkname);
        if ("".equals(tsapiLinkname)) {
            logger.log(Level.INFO, "tsapilink is empty, could not continue, exit ...");
            throw new Exception("tsapilink is empty");
        }
        return tsapiLinkname;
    }

    private String getProviderStr() throws Exception {
        String fmt = "%s;loginID=%s;passwd=%s";
        String tsapiLinkname = this.getTSAPILinkName();
        String providerStr = String.format(fmt, tsapiLinkname, ConfManager.getManagerUserName() + "", ConfManager.getManagerPasswd() + "");
        logger.log(Level.INFO, "Using Provider String ==>" + providerStr);
        return providerStr;
    }
}

