/*
 * Decompiled with CFR 0.152.
 */
package avaya.com.zohocorp.zoho.ztiimpl.handlers;

import avaya.com.zohocorp.zoho.ztiimpl.handlers.ZTINotifier;
import avaya.com.zohocorp.zoho.ztiimpl.utils.ConfManager;
import avaya.com.zohocorp.zoho.ztiimpl.utils.FileHandler;
import avaya.com.zohocorp.zoho.ztiimpl.utils.LRUCache;
import avaya.com.zohocorp.zoho.ztiimpl.utils.ZTICallUtil;
import com.zohocorp.zoho.ztiadapter.ZTIAdapter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class CTICallsHandler2 {
    private static Logger logger = Logger.getLogger(CTICallsHandler2.class.getName());
    private static final HashMap<String, Integer> ZTI_CALLSTATE = new HashMap();
    private static final int IDX_CALLREFID = 0;
    private static final int IDX_FROMNUMBER = 1;
    private static final int IDX_TONUMBER = 2;
    private static final int IDX_CALLSTATE = 3;
    private static final int IDX_CALLTYPE = 4;
    private static final int IDX_RINGINGSTARTEDTIME = 5;
    private static final int IDX_ANSWEREDTIME = 6;
    private static final int IDX_HUNGUPTIME = 7;
    private static final int IDX_CALLDURATION = 8;
    private static final int IDX_OLD_AES_CALLIDS = 9;
    private static final int LRUCACHE_SIZE = ConfManager.getLRUCacheSize();
    private static final int LRUCACHE_SIZE_COMPLETEDCALLS = 100;
    private static final int LRUCACHE_SIZE_TRANFERCALLS = 1000;
    private static final int LRUCACHE_SIZE_CONFERENCECALLS = 1000;
    private static final String HOMEDIR = ConfManager.getHomeDir();
    private static final int MAXHRS = ConfManager.getMaxHrs();
    private LRUCache<String, Hashtable<Integer, String>> aes_CallIdVsCallDetails;
    private LRUCache<String, Hashtable<Integer, String>> aes_CallIdVsCompletedCallDetils;
    private LRUCache<String, Hashtable<Integer, String>> aes_CallIdVsConferenceCallDetils;
    private LRUCache<String, Hashtable<Integer, String>> aes_CallIdVsTransferCallDetils;
    private ZTINotifier zohoNotifier;
    private FileHandler<String, Hashtable<Integer, String>> fileHandler = new FileHandler(HOMEDIR, MAXHRS);

    public CTICallsHandler2() {
        this.aes_CallIdVsCallDetails = new LRUCache<String, Hashtable<Integer, String>>(LRUCACHE_SIZE, this.fileHandler);
        this.aes_CallIdVsCompletedCallDetils = new LRUCache<String, Hashtable<Integer, String>>(100, this.fileHandler);
        this.aes_CallIdVsConferenceCallDetils = new LRUCache(1000);
        this.aes_CallIdVsTransferCallDetils = new LRUCache(1000);
        this.zohoNotifier = new ZTINotifier();
    }

    public String getCallState(String aesCallId) {
        return this.getCallDetails(aesCallId).get(3);
    }

    public long getCallReceivedTime(String aesCallId) {
        String callReceivedTime = this.getCallDetails(aesCallId).get(5);
        return callReceivedTime != null && Long.valueOf(callReceivedTime) > 0L ? Long.valueOf(callReceivedTime) : 0L;
    }

    public long getCallAnsweredTime(String aesCallId) {
        String callAnsweredTime = this.getCallDetails(aesCallId).get(6);
        return callAnsweredTime != null && Long.valueOf(callAnsweredTime) > 0L ? Long.valueOf(callAnsweredTime) : 0L;
    }

    public long getCallHungupTime(String aesCallId) {
        String callHungupTime = this.getCallDetails(aesCallId).get(7);
        return callHungupTime != null && Long.valueOf(callHungupTime) > 0L ? Long.valueOf(callHungupTime) : 0L;
    }

    public boolean isCallInConference(String aesCallId) {
        return this.aes_CallIdVsConferenceCallDetils.containsKey(aesCallId);
    }

    public CTICallsHandler2 updateCallDetails(String aesCallId, String fromNumber, String toNumber, String callState) {
        if (ZTICallUtil.checkNotNull(fromNumber) && ZTICallUtil.checkNotNull(toNumber) && !fromNumber.equals(toNumber)) {
            String fromZuid = ZTIAdapter.getUserforExtension((String)fromNumber);
            String toZuid = ZTIAdapter.getUserforExtension((String)toNumber);
            if (fromZuid != null || toZuid != null && (fromZuid == null || toZuid == null)) {
                Hashtable<Integer, String> callDetails = this.getCallDetails(aesCallId);
                callDetails.put(1, fromNumber);
                callDetails.put(2, toNumber);
                callDetails.put(3, callState);
                callDetails.put(4, fromZuid == null ? "incoming" : "outgoing");
            }
        }
        return this;
    }

    public CTICallsHandler2 updateFromToNumbers(String aesCallId, String fromNumber, String toNumber) {
        if (ZTICallUtil.checkNotNull(fromNumber) && ZTICallUtil.checkNotNull(toNumber) && !fromNumber.equals(toNumber)) {
            String fromZuid = ZTIAdapter.getUserforExtension((String)fromNumber);
            String toZuid = ZTIAdapter.getUserforExtension((String)toNumber);
            if (fromZuid != null || toZuid != null && (fromZuid == null || toZuid == null)) {
                Hashtable<Integer, String> callDetails = this.getCallDetails(aesCallId);
                callDetails.put(1, fromNumber);
                callDetails.put(2, toNumber);
                callDetails.put(4, fromZuid == null ? "incoming" : "outgoing");
            }
        }
        return this;
    }

    public void updateFromNumber(String aesCallId, String fromNumber) {
        if (ZTICallUtil.checkNotNull(fromNumber) && ZTIAdapter.getUserforExtension((String)fromNumber) != null) {
            Hashtable<Integer, String> callDetails = this.getCallDetails(aesCallId);
            callDetails.put(1, fromNumber);
        }
    }

    public void updateToNumber(String aesCallId, String toNumber) {
        if (ZTICallUtil.checkNotNull(toNumber) && ZTIAdapter.getUserforExtension((String)toNumber) != null) {
            Hashtable<Integer, String> callDetails = this.getCallDetails(aesCallId);
            callDetails.put(2, toNumber);
        }
    }

    private void updateCallState(String aesCallId, String callState) {
        Hashtable<Integer, String> callDetails = this.getCallDetails(aesCallId);
        long currentTime = System.currentTimeMillis();
        if ("callreceived".equals(callState)) {
            callDetails.put(5, currentTime + "");
        } else if ("callconnected".equals(callState)) {
            callDetails.put(6, currentTime + "");
        } else if ("callended".equals(callState)) {
            String callAnsweredTime = callDetails.get(6);
            Long answeredTime = callAnsweredTime != null ? Long.valueOf(callAnsweredTime) : currentTime;
            long callDuration = (currentTime - answeredTime) / 1000L;
            callDetails.put(7, currentTime + "");
            callDetails.put(8, callDuration + "");
        }
        callDetails.put(3, callState);
    }

    public void updateCallType(String aesCallId, String callType) {
        Hashtable<Integer, String> callDetails = this.getCallDetails(aesCallId);
        callDetails.put(4, callType);
    }

    public void deleteCallDetails(String aesCallId) {
        this.removeCallDetails(aesCallId);
    }

    public void addToTransferCall(String aesCallId) {
        if (!this.aes_CallIdVsTransferCallDetils.containsKey(aesCallId)) {
            this.aes_CallIdVsTransferCallDetils.put(aesCallId, this.getCallDetails(aesCallId));
        }
    }

    public void addToConferenceCall(String aesCallId) {
        if (!this.aes_CallIdVsConferenceCallDetils.containsKey(aesCallId)) {
            this.aes_CallIdVsConferenceCallDetils.put(aesCallId, this.getCallDetails(aesCallId));
        }
    }

    public void updateTransferCompleted(String newAESCallId, String oldAESCallId) {
        if (this.aes_CallIdVsTransferCallDetils.containsKey(newAESCallId)) {
            Hashtable callDetails = (Hashtable)this.aes_CallIdVsTransferCallDetils.get(newAESCallId);
            callDetails.put(9, oldAESCallId);
        }
    }

    public void updateConferenceJoined(String newAESCallId, String oldAESCallId) {
        if (this.aes_CallIdVsConferenceCallDetils.containsKey(newAESCallId)) {
            Hashtable callDetails = (Hashtable)this.aes_CallIdVsConferenceCallDetils.get(newAESCallId);
            String oldCallIds = (String)callDetails.get(9);
            callDetails.put(9, null == oldCallIds || "".equals(oldCallIds) ? "" : oldCallIds + "," + oldAESCallId);
        }
    }

    public void handleTransferCall(String newAESCallId, String oldAESCallId) {
        if (this.aes_CallIdVsTransferCallDetils.containsKey(newAESCallId) && this.aes_CallIdVsTransferCallDetils.containsKey(oldAESCallId)) {
            Hashtable newCallDetails = (Hashtable)this.aes_CallIdVsTransferCallDetils.get(newAESCallId);
            if ("callreceived".equals(newCallDetails.get(3))) {
                newCallDetails.put(6, "0");
                newCallDetails.put(8, "0");
                newCallDetails.put(7, "0");
                this.handleCallStateChange(newAESCallId, "callconnected");
                this.aes_CallIdVsTransferCallDetils.remove(oldAESCallId);
            } else {
                long currentTime = System.currentTimeMillis();
                Hashtable oldCallDetails = (Hashtable)this.aes_CallIdVsTransferCallDetils.get(oldAESCallId);
                String fromNumber = (String)oldCallDetails.get(1);
                String callType = (String)oldCallDetails.get(4);
                newCallDetails.put(1, fromNumber);
                newCallDetails.put(3, "callreceived");
                newCallDetails.put(5, currentTime + "");
                newCallDetails.put(4, callType);
                this.aes_CallIdVsCallDetails.put(newAESCallId, newCallDetails);
            }
        }
    }

    public void handleConferenceCall(String newAESCallId, String oldAESCallId) {
        if (this.aes_CallIdVsConferenceCallDetils.containsKey(newAESCallId) && this.aes_CallIdVsConferenceCallDetils.containsKey(oldAESCallId)) {
            long currentTime = System.currentTimeMillis();
            Hashtable newCallDetails = (Hashtable)this.aes_CallIdVsConferenceCallDetils.get(newAESCallId);
            Hashtable oldCallDetails = (Hashtable)this.aes_CallIdVsConferenceCallDetils.get(oldAESCallId);
            String fromNumber = (String)oldCallDetails.get(1);
            String callType = (String)oldCallDetails.get(4);
            newCallDetails.put(1, fromNumber);
            newCallDetails.put(3, "callreceived");
            newCallDetails.put(5, currentTime + "");
            newCallDetails.put(4, callType);
            newCallDetails.put(6, "0");
            newCallDetails.put(7, "0");
            newCallDetails.put(8, "0");
            this.aes_CallIdVsCallDetails.put(newAESCallId, newCallDetails);
            this.handleCallStateChange(newAESCallId, "callconnected");
            this.aes_CallIdVsConferenceCallDetils.remove(newAESCallId);
            this.aes_CallIdVsTransferCallDetils.remove(oldAESCallId);
        }
    }

    public void handleConferenceCallEnd(String aesCallId) {
    }

    public CTICallsHandler2 handleCallStateChange(String aesCallId) {
        return this.handleCallStateChange(aesCallId, this.getCallState(aesCallId));
    }

    public CTICallsHandler2 handleCallStateChange(String aesCallId, String callState) {
        Hashtable<Integer, String> preState_callDetails = this.getCallDetails(aesCallId);
        String preCallState = preState_callDetails.get(3);
        int previousStateInNumber = preCallState != null ? ZTI_CALLSTATE.get(preCallState) : 0;
        int currentStateInNumber = ZTI_CALLSTATE.get(callState);
        if (currentStateInNumber > previousStateInNumber) {
            this.updateCallState(aesCallId, callState);
            Hashtable<Integer, String> callDetails = this.getCallDetails(aesCallId);
            String callRefId = this.getCallRefId(aesCallId);
            String fromNumber = callDetails.get(1);
            String toNumber = callDetails.get(2);
            String callType = callDetails.get(4);
            String billablesec = callDetails.containsKey(8) ? callDetails.get(8) : "0";
            String fromZuid = ZTIAdapter.getUserforExtension((String)fromNumber);
            String toZuid = ZTIAdapter.getUserforExtension((String)toNumber);
            if (fromZuid == null && toZuid != null || fromZuid != null && toZuid == null && (fromZuid != null || toZuid != null)) {
                this.zohoNotifier.notifyEvent(callRefId, fromNumber, toNumber, callState, callType, billablesec);
            } else {
                logger.log(Level.INFO, "Internal group agent call - {0} toZuid - {1}", new Object[]{fromZuid, toZuid});
                logger.log(Level.INFO, "fromZuid - {0}, fromNumber - {1}", new Object[]{fromZuid, fromNumber});
                logger.log(Level.INFO, "toZuid - {0}, toNumber - {1}", new Object[]{toZuid, toNumber});
            }
        } else {
            logger.log(Level.INFO, "previousStateInNumber - ", previousStateInNumber);
            logger.log(Level.INFO, "currentStateInNumber - ", currentStateInNumber);
        }
        return this;
    }

    private String getCallRefId(String aesCallId) {
        Hashtable<Integer, String> callDetails = this.getCallDetails(aesCallId);
        String callRefId = callDetails.get(0);
        if (callRefId == null) {
            callRefId = ZTICallUtil.generateCallRefId(aesCallId);
            callDetails.put(0, callRefId);
        }
        return callRefId;
    }

    private Hashtable<Integer, String> getCallDetails(String aesCallId) {
        Hashtable callDetails = null;
        if (this.aes_CallIdVsCallDetails.containsKey(aesCallId)) {
            callDetails = (Hashtable)this.aes_CallIdVsCallDetails.get(aesCallId);
        } else if (this.aes_CallIdVsCompletedCallDetils.containsKey(aesCallId)) {
            callDetails = (Hashtable)this.aes_CallIdVsCompletedCallDetils.get(aesCallId);
        } else {
            try {
                String callDetailsStr = this.fileHandler.getCallDetailsString(aesCallId);
                callDetails = ZTICallUtil.checkNotNull(callDetailsStr) ? CTICallsHandler2.parseJSON2Map(callDetailsStr) : new Hashtable();
            }
            catch (JSONException e) {
                callDetails = new Hashtable();
                e.printStackTrace();
            }
            this.aes_CallIdVsCallDetails.put(aesCallId, callDetails);
        }
        return callDetails;
    }

    private void removeCallDetails(String aesCallId) {
        if (this.aes_CallIdVsCallDetails.containsKey(aesCallId)) {
            Hashtable removedCallDetails = (Hashtable)this.aes_CallIdVsCallDetails.get(aesCallId);
            this.aes_CallIdVsCompletedCallDetils.put(aesCallId, removedCallDetails);
            this.aes_CallIdVsCallDetails.remove(aesCallId);
            logger.log(Level.INFO, "aes_CallIdVsCallDetails & aes_CallIdVsCompletedCallDetils size ---> {0} & {1} ", new Object[]{this.aes_CallIdVsCallDetails.size(), this.aes_CallIdVsCompletedCallDetils.size()});
            logger.log(Level.INFO, "removedCallDetails ---> {0}", removedCallDetails);
        }
    }

    private static Hashtable<Integer, String> parseJSON2Map(String jsonString) throws JSONException {
        if (ZTICallUtil.checkNotNull(jsonString)) {
            JSONObject jsonObject = new JSONObject(jsonString);
            return CTICallsHandler2.parseJSON2Map(jsonObject);
        }
        return null;
    }

    private static Hashtable<Integer, String> parseJSON2Map(JSONObject jsonObj) throws JSONException {
        Hashtable<Integer, String> result = new Hashtable<Integer, String>();
        if (ZTICallUtil.checkNotNull(jsonObj)) {
            Iterator keys = jsonObj.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = jsonObj.getString(key);
                result.put(Integer.parseInt(key), value);
            }
        }
        return result;
    }

    static {
        ZTI_CALLSTATE.put("callreceived", 1);
        ZTI_CALLSTATE.put("ringing", 1);
        ZTI_CALLSTATE.put("callinitiated", 2);
        ZTI_CALLSTATE.put("calldialed", 2);
        ZTI_CALLSTATE.put("callanswered", 3);
        ZTI_CALLSTATE.put("callconnected", 3);
        ZTI_CALLSTATE.put("callended", 4);
        ZTI_CALLSTATE.put("callhungup", 4);
        ZTI_CALLSTATE.put("completed", 4);
        ZTI_CALLSTATE.put("callmissed", 5);
    }
}

