/*
 * Decompiled with CFR 0.152.
 */
package avaya.com.zohocorp.zoho.ztiimpl;

import avaya.com.zohocorp.zoho.ztiimpl.handlers.ZTITerminal;
import avaya.com.zohocorp.zoho.ztiimpl.utils.ConfManager;
import avaya.com.zohocorp.zoho.ztiimpl.utils.LRUCache;
import com.zohocorp.zoho.ztiadapter.ZohoTeleAdapter;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZTIAvayaImpl
extends ZohoTeleAdapter {
    private static Logger logger = Logger.getLogger(ZTIAvayaImpl.class.getName());
    private static final int LRUCACHESIZE = 500;
    private LRUCache<String, Integer> httpReqIdVsCount;
    ZTITerminal ztiTerminal;

    public ZTIAvayaImpl(String protocol, Integer interval) {
        super(protocol, interval);
        logger.log(Level.INFO, "Protocol = " + protocol + ", Interval = " + interval);
    }

    protected boolean isLive() {
        return this.ztiTerminal.getZtiProvider() != null;
    }

    public boolean init() {
        if (!ConfManager.initialize(this.getHome())) {
            logger.log(Level.INFO, "Error in loading properties file...");
            return false;
        }
        return this.newlogin();
    }

    public boolean init(int serverIdx) {
        if (!ConfManager.initialize(this.getHome(), serverIdx)) {
            logger.log(Level.INFO, "Error in loading properties file...");
            return false;
        }
        return this.newlogin();
    }

    public boolean makeCall(String fromNumber, String toNumber, Hashtable attachments) {
        logger.log(Level.INFO, "Make Call : fromNumber = {0}, toNumber = {1}, attachments : {2}", new Object[]{fromNumber, toNumber, attachments});
        try {
            String httpReqId = (String)(attachments.containsKey("httpReqId") ? attachments.get("httpReqId") : Long.valueOf(System.currentTimeMillis()));
            Integer wmsNotifiedCount = this.httpReqIdVsCount.containsKey(httpReqId) ? (Integer)this.httpReqIdVsCount.get(httpReqId) : Integer.valueOf(0);
            logger.log(Level.INFO, "Make Call wmsNotifiedCount : {0}", wmsNotifiedCount);
            this.httpReqIdVsCount.put(httpReqId, wmsNotifiedCount + 1);
            if (wmsNotifiedCount < 1) {
                return this.ztiTerminal.makeCall(fromNumber, toNumber, attachments);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error in makeCall", e);
        }
        return true;
    }

    public boolean handleExtnUpdate(Hashtable attachments) {
        logger.log(Level.INFO, "Extensions modified in Zoho. Extensions list (Terminal Listeners to be added/removed) => " + attachments);
        try {
            if (attachments == null) {
                return true;
            }
            Hashtable addextns = (Hashtable)attachments.get("addlist");
            Hashtable remextns = (Hashtable)attachments.get("deletelist");
            this.ztiTerminal.removeTerminalListeners(remextns);
            this.ztiTerminal.addTerminalListeners(addextns);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error: Error in getting added/removed extensions list towhich we have to add/remove listeners", e);
            return false;
        }
        return true;
    }

    public synchronized boolean newlogin() {
        try {
            this.ztiTerminal = new ZTITerminal();
            this.ztiTerminal.addTerminalListeners(ZOHO.getUserExtensions());
            this.httpReqIdVsCount = new LRUCache(500);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception =============> ", e);
        }
        return true;
    }
}

