/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.tcp;

import com.adventnet.wms.nioclient.exception.NIOSSLCertificateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509TrustManager;

public class TCPSSLTrustManager
implements X509TrustManager {
    private KeyStore trustStore;
    private String domain;
    private boolean ignorecertificatevalidation;
    private boolean ignorechainverification;
    private ArrayList extdomains = new ArrayList();
    private KeyManagerFactory kf;
    private static Logger logger = Logger.getLogger(TCPSSLTrustManager.class.getName());

    public TCPSSLTrustManager(String domain) {
        this(domain, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCPSSLTrustManager(String domain, String fileNameWithPath, String password, String keystoreType) {
        this.domain = domain;
        InputStream in = null;
        try {
            if (fileNameWithPath == null || password == null) {
                this.trustStore = KeyStore.getInstance("JKS");
                String jrehome = System.getProperty("jre.home");
                password = "changeit";
                fileNameWithPath = jrehome + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
            } else {
                this.trustStore = keystoreType != null && keystoreType.length() > 0 ? KeyStore.getInstance(keystoreType) : KeyStore.getInstance("PKCS12");
            }
            in = new FileInputStream(fileNameWithPath);
            this.trustStore.load(in, password.toCharArray());
            this.kf = KeyManagerFactory.getInstance("SunX509");
            this.kf.init(this.trustStore, password.toCharArray());
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception ", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    logger.log(Level.INFO, "Exception ", ioe);
                }
            }
        }
    }

    public void ignoreCertificateValidation() {
        this.ignorecertificatevalidation = true;
    }

    public void ignoreChainVerification() {
        this.ignorechainverification = true;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    public void setExternalDomains(ArrayList extdomains) {
        this.extdomains = extdomains;
    }

    public KeyManager[] getKeyManagers() {
        return this.kf.getKeyManagers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws NIOSSLCertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certs, String arg1) throws NIOSSLCertificateException {
        try {
            if (this.ignorecertificatevalidation) {
                return;
            }
            int certLen = x509Certs.length;
            Date d = new Date();
            for (int i = 0; i < certLen; ++i) {
                try {
                    x509Certs[i].checkValidity(d);
                    continue;
                }
                catch (Exception e) {
                    throw new NIOSSLCertificateException("Certificate Expired", e);
                }
            }
            String dname = x509Certs[0].getSubjectDN().getName();
            String name = null;
            int idx = dname.indexOf("CN=");
            if (idx == -1) {
                idx = dname.indexOf("cn=");
            }
            HashSet<String> hashset = new HashSet<String>();
            if (idx != -1) {
                String dtemp = dname.substring(idx + 3);
                if (dtemp.indexOf(",") != -1) {
                    hashset.add(dtemp.substring(0, dtemp.indexOf(",")));
                } else {
                    hashset.add(dtemp.substring(0).trim());
                }
            }
            Collection<List<?>> coll = x509Certs[0].getSubjectAlternativeNames();
            Iterator<List<?>> iterator = coll.iterator();
            while (iterator.hasNext()) {
                Object[] arr = ((Collection)iterator.next()).toArray();
                if ((Integer)arr[0] != 2) continue;
                hashset.add("" + arr[1]);
            }
            if (hashset.isEmpty()) {
                throw new NIOSSLCertificateException("Subject DN not present");
            }
            boolean valid = false;
            Iterator it = hashset.iterator();
            block9: while (it.hasNext()) {
                name = "" + it.next();
                if (this.domain.equals("default")) {
                    if (this.extdomains.contains(name)) {
                        valid = true;
                        break;
                    }
                    for (String indomain : this.extdomains) {
                        if (name.equals(indomain) || name.replace("*.", "").equals(indomain)) {
                            valid = true;
                            continue block9;
                        }
                        if (!name.startsWith("*.") || !indomain.substring(indomain.indexOf(".") + 1).equals(name.replace("*.", ""))) continue;
                        valid = true;
                        continue block9;
                    }
                    continue;
                }
                if (name.equals(this.domain) || name.replace("*.", "").equals(this.domain)) {
                    valid = true;
                    break;
                }
                if (!name.startsWith("*.") || !this.domain.substring(this.domain.indexOf(".") + 1).equals(name.replace("*.", ""))) continue;
                valid = true;
                break;
            }
            if (!valid) {
                throw new NIOSSLCertificateException("Subject DN Mismatch");
            }
            if (!this.ignorechainverification) {
                Principal authprincipal = null;
                for (int i = x509Certs.length - 1; i >= 0; --i) {
                    X509Certificate cert = x509Certs[i];
                    Principal issuer = cert.getIssuerDN();
                    Principal subject = cert.getSubjectDN();
                    if (authprincipal != null) {
                        if (issuer.equals(authprincipal)) {
                            try {
                                PublicKey publickey = x509Certs[i + 1].getPublicKey();
                                x509Certs[i].verify(publickey);
                            }
                            catch (GeneralSecurityException generalsecurityexception) {
                                throw new NIOSSLCertificateException("signature verification failed", generalsecurityexception);
                            }
                        } else {
                            throw new NIOSSLCertificateException("subject/issuer verification failed of");
                        }
                    }
                    authprincipal = subject;
                }
            }
        }
        catch (NIOSSLCertificateException cxe) {
            throw cxe;
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Exception ", ex);
            throw new NIOSSLCertificateException("Unknown issue");
        }
    }
}

