/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.tcp;

import com.adventnet.wms.nioclient.exception.NIOException;
import com.adventnet.wms.nioclient.exception.NIOSSLCertificateException;
import com.adventnet.wms.nioclient.tcp.NioSelector;
import com.adventnet.wms.nioclient.tcp.TCPConnectionHeartBeatMonitor;
import com.adventnet.wms.nioclient.tcp.TCPSSLManager;
import com.adventnet.wms.nioclient.tcp.TCPSSLWrapper;
import com.adventnet.wms.nioclient.util.NIOCommonUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.conscrypt.OpenSSLContextImpl;

public abstract class PacketAssembler {
    private static Logger logger = Logger.getLogger(PacketAssembler.class.getName());
    private SocketChannel sc;
    private TCPSSLWrapper ssl;
    private SSLContext sslCntx;
    private OpenSSLContextImpl conscryptCntx;
    private int connectionType;
    private boolean hsdone = false;
    private int zeroReadCount = 0;
    private int maxZeroReadCount = 100;
    private SelectionKey key = null;
    private int connectretrycount = 0;
    private int connectretryMaxCount = 10;
    private NioSelector selector = null;
    private Object niolock = new Object();
    private boolean hsstarted = false;
    private int writebuffersize = 8192;
    private int readbuffersize = 8192;
    private int maxwritebuffersize = 40960;
    private boolean highpriority = false;
    private ByteBuffer writeBB = ByteBuffer.allocate(this.writebuffersize);
    private ArrayList<String> sslversions = new ArrayList();
    private ArrayList<String> ciphersuites = new ArrayList();
    private ArrayList<String> ignoredsslversions = new ArrayList();
    private ArrayList<String> ignoredciphersuites = new ArrayList();
    private boolean ignorecertificatevalidation = false;
    private boolean ignorechainverification = false;
    private long initConnectTime;
    private long connectexpiretime;
    protected HashMap statReports = new LinkedHashMap();
    private long bytesRead;
    private long byteswritten;
    private long lastconnhbtime = 0L;
    private boolean isConnectionHeartBeatEnabled = false;
    private long connmaxidletime = 90000L;
    private long ignorehbperiod = 1000L;
    private String serverName;

    public void setSSLVersions(String versions) {
        if (versions != null) {
            this.sslversions.addAll(NIOCommonUtil.getList(versions));
        }
    }

    public void setCipherSuites(String suites) {
        if (suites != null) {
            this.ciphersuites.addAll(NIOCommonUtil.getList(suites));
        }
    }

    public void setIgnoredSSLVersions(String versions) {
        if (versions != null) {
            this.ignoredsslversions.addAll(NIOCommonUtil.getList(versions));
        }
    }

    public void setIgnoredCipherSuites(String suites) {
        if (suites != null) {
            this.ignoredciphersuites.addAll(NIOCommonUtil.getList(suites));
        }
    }

    public void ignoreCertificateValidation() {
        this.ignorecertificatevalidation = true;
    }

    public void ignoreChainVerification() {
        this.ignorechainverification = true;
    }

    public void setConnectionType(int connectionType) {
        this.connectionType = connectionType;
    }

    public void setSelector(NioSelector selector) {
        this.selector = selector;
    }

    public void setSSLContext(SSLContext sslCntx) throws IOException {
        if (TCPSSLManager.isConscryptEnabled()) {
            throw new IOException("Attempt to set Conscrypt context for default SSL case");
        }
        this.sslCntx = sslCntx;
    }

    public void setConscryptContext(OpenSSLContextImpl conscrypt) throws IOException {
        if (!TCPSSLManager.isConscryptEnabled()) {
            throw new IOException("Attemp to set default SSLContext for conscrypt case");
        }
        this.conscryptCntx = conscrypt;
    }

    public void setHighPriority() {
        this.highpriority = true;
    }

    public void setSocketChannel(SocketChannel sc) {
        this.sc = sc;
        this.initConnectTime = System.currentTimeMillis();
        try {
            if (this.isSSL()) {
                this.ssl = !TCPSSLManager.isConscryptEnabled() ? new TCPSSLWrapper(sc, TCPSSLManager.getSSLEngine(this.sslCntx), this.sslversions, this.ciphersuites, this.ignoredsslversions, this.ignoredciphersuites, this.serverName) : new TCPSSLWrapper(sc, TCPSSLManager.getSSLEngine(this.conscryptCntx), this.sslversions, this.ciphersuites, this.ignoredsslversions, this.ignoredciphersuites, this.serverName);
                this.ssl.setWriteBufferSize(this.writebuffersize, this.maxwritebuffersize);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.statReports.put("inittime", System.currentTimeMillis());
    }

    public void switchTLS() {
        try {
            this.ssl = !TCPSSLManager.isConscryptEnabled() ? new TCPSSLWrapper(this.sc, TCPSSLManager.getSSLEngine(this.sslCntx), this.sslversions, this.ciphersuites, this.ignoredsslversions, this.ignoredciphersuites, this.serverName) : new TCPSSLWrapper(this.sc, TCPSSLManager.getSSLEngine(this.conscryptCntx), this.sslversions, this.ciphersuites, this.ignoredsslversions, this.ignoredciphersuites, this.serverName);
            this.ssl.setWriteBufferSize(this.writebuffersize, this.maxwritebuffersize);
            this.hsstarted = true;
            this.setInterestOps(5);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void switchTLS(SSLContext sslcontxt) throws Exception {
        this.setSSLContext(sslcontxt);
        this.switchTLS();
    }

    public void switchTLS(OpenSSLContextImpl sslcontxt) throws Exception {
        this.setConscryptContext(sslcontxt);
        this.switchTLS();
    }

    public void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    public void setInterestOps(int ops) {
        this.key.interestOps(ops);
    }

    public void setWriteModeForKey() {
        this.selector.setWriteModeForKey(this.sc);
    }

    public SocketChannel getSocketChannel() {
        return this.sc;
    }

    public String getLocalAddress() {
        try {
            return this.sc.getLocalAddress().toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getRemoteAddress() {
        try {
            return this.sc.getRemoteAddress().toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isOpen() {
        if (this.sc != null) {
            return this.sc.isOpen();
        }
        return false;
    }

    public Object getLockObject() {
        return this.niolock;
    }

    public boolean isSSL() {
        return this.connectionType == 2;
    }

    public boolean isTLS() {
        return this.connectionType == 1;
    }

    public boolean isPlain() {
        return this.connectionType == 0;
    }

    public void setConnectExpireTime(long time) {
        this.connectexpiretime = time;
    }

    public long getConnectExpireTime() {
        return this.connectexpiretime;
    }

    public boolean isConnectExpired() {
        return System.currentTimeMillis() >= this.connectexpiretime;
    }

    public boolean isInvalidConnectExpireTime(long time) {
        return time != this.connectexpiretime;
    }

    public void setHSDone() {
        this.hsdone = true;
    }

    public boolean isHSDone() {
        return this.hsdone;
    }

    public boolean isHSStarted() {
        return this.hsstarted;
    }

    public int getInterestOps() {
        try {
            if (this.ssl != null) {
                return this.ssl.getInterestOps();
            }
            return this.key.interestOps();
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public void setWriteBufferSize(int size, int maxsize) {
        this.writebuffersize = size;
        this.maxwritebuffersize = maxsize;
    }

    public void setReadBufferSize(int size) {
        this.readbuffersize = size;
    }

    public List<Throwable> getThrowableList(Exception e) {
        ArrayList<Throwable> tList = new ArrayList<Throwable>();
        try {
            for (Throwable cause = e.getCause(); cause != null && !tList.contains(cause); cause = cause.getCause()) {
                tList.add(cause);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tList;
    }

    public boolean doHandshake() throws Exception {
        return this.doHandshake(this.key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doHandshake(SelectionKey key) throws Exception {
        if (this.connectionType == 0) {
            return true;
        }
        this.hsstarted = true;
        Object object = this.niolock;
        synchronized (object) {
            try {
                this.hsdone = this.ssl.doHandshake(key);
                if (this.isSSL() && this.hsdone) {
                    for (Map.Entry pair : this.ssl.getHandshakeReports().entrySet()) {
                        this.statReports.put(pair.getKey(), pair.getValue());
                    }
                }
                return this.hsdone;
            }
            catch (IOException e) {
                List<Throwable> throwables = this.getThrowableList(e);
                for (int traceCount = 0; traceCount < throwables.size(); ++traceCount) {
                    try {
                        Throwable t = throwables.get(traceCount);
                        if (!(t instanceof NIOSSLCertificateException)) continue;
                        NIOSSLCertificateException excep = (NIOSSLCertificateException)t;
                        this.onSSLExceptions(excep.getErrorCode(), excep.getErrorMsg());
                        this.close();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readData(SelectionKey key) throws Exception {
        Object object = this.niolock;
        synchronized (object) {
            if (!this.statReports.containsKey("readinittime")) {
                this.statReports.put("readinittime", System.currentTimeMillis());
            }
            ByteBuffer byteBuffer = null;
            int count = -1;
            if (this.isSSL() || this.isTLS() && (this.hsstarted || this.hsdone)) {
                if (this.ssl.doHandshake(key)) {
                    this.hsdone = true;
                    count = this.ssl.read();
                    if (count > 0) {
                        this.zeroReadCount = 0;
                        byteBuffer = this.ssl.getDataBuffer();
                        byteBuffer.flip();
                    }
                }
            } else {
                byteBuffer = ByteBuffer.allocate(this.readbuffersize);
                count = ((SocketChannel)key.channel()).read(byteBuffer);
                byteBuffer.flip();
            }
            this.bytesRead += (long)count;
            this.statReports.put("bytesread", this.bytesRead);
            this.statReports.put("lastreadtime", System.currentTimeMillis());
            if (count > 0) {
                this.updateConnectionHeartBeat();
                byte[] arr = new byte[count];
                byteBuffer.get(arr, 0, arr.length);
                this.onData(arr);
                byteBuffer.clear();
            } else {
                if (count < 0) {
                    throw new NIOException("Key Read Count < 0");
                }
                if (count == 0) {
                    ++this.zeroReadCount;
                    if (this.zeroReadCount > this.maxZeroReadCount) {
                        throw new NIOException("Key Read Count = 0 : Max Crossed");
                    }
                }
            }
            if (this.isWritePending()) {
                this.handleWrite(key);
            }
            key.interestOps(key.interestOps() | 1);
        }
    }

    private boolean isWritePending() {
        if (this.isSSL() || this.isTLS() && this.hsstarted) {
            return this.ssl.isWritePending();
        }
        return this.writeBB.position() > 0;
    }

    public void writeData(ByteBuffer bb) throws Exception {
        this.writeData(new ByteBuffer[]{bb});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeData(ByteBuffer[] buffers) throws Exception {
        Object object = this.niolock;
        synchronized (object) {
            if (!this.statReports.containsKey("writeinittime")) {
                this.statReports.put("writeinittime", System.currentTimeMillis());
            }
            if (this.isSSL() || this.isTLS() && (this.hsstarted || this.hsdone)) {
                this.ssl.writeData(buffers);
                this.key.interestOps(4);
                return;
            }
            for (int i = 0; i < buffers.length; ++i) {
                ByteBuffer src = buffers[i];
                if (this.writeBB.position() == 0 && src.capacity() <= this.maxwritebuffersize) {
                    ByteBuffer bb = ByteBuffer.allocate(src.capacity());
                    this.writeBB.flip();
                    bb.put(this.writeBB);
                    this.writeBB = bb;
                    this.writeBB.put(src);
                    this.key.interestOps(4);
                    return;
                }
                if (this.writeBB.capacity() - this.writeBB.position() > src.capacity()) {
                    this.writeBB.put(src);
                } else if (src.capacity() + this.writeBB.position() < this.writebuffersize) {
                    ByteBuffer bb = ByteBuffer.allocate(this.writebuffersize);
                    this.writeBB.flip();
                    bb.put(this.writeBB);
                    this.writeBB = bb;
                    this.writeBB.put(src);
                } else if (src.capacity() + this.writeBB.position() > this.writeBB.capacity() * 2) {
                    if (src.capacity() + this.writeBB.position() >= this.maxwritebuffersize) throw new IOException("Exceeded max allowed size " + (src.capacity() + this.writeBB.position()) + " Allowed " + this.maxwritebuffersize);
                    int en_size = src.capacity() + this.writeBB.position();
                    ByteBuffer bb = ByteBuffer.allocate(en_size);
                    this.writeBB.flip();
                    bb.put(this.writeBB);
                    this.writeBB = bb;
                    this.writeBB.put(src);
                } else {
                    ByteBuffer bb = ByteBuffer.allocate(this.writeBB.capacity() * 2);
                    this.writeBB.flip();
                    bb.put(this.writeBB);
                    this.writeBB = bb;
                    this.writeBB.put(src);
                }
                this.key.interestOps(4);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleWrite(SelectionKey key) throws IOException, CancelledKeyException {
        if (this.key == null) {
            this.key = key;
        }
        Object object = this.niolock;
        synchronized (object) {
            try {
                if (this.isSSL() || this.isTLS() && (this.hsdone || this.hsstarted)) {
                    this.ssl.handleWrite(key);
                    this.updateConnectionHeartBeat();
                    return;
                }
                this.writeBB.flip();
                SocketChannel sk = (SocketChannel)key.channel();
                boolean proceed = true;
                while (proceed) {
                    int written = sk.write(this.writeBB);
                    this.updateConnectionHeartBeat();
                    this.byteswritten += (long)written;
                    this.statReports.put("lastwrittentime", System.currentTimeMillis());
                    if (written <= 0) {
                        proceed = false;
                        continue;
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, "{0} Exception in sleep during write {1}", new Object[]{this, ex});
                    }
                }
                this.writeBB.compact();
                if (this.writeBB.position() > 0) {
                    this.key.interestOps(4);
                } else {
                    this.key.interestOps(1);
                }
            }
            catch (CancelledKeyException cex) {
                throw cex;
            }
            catch (IOException ex) {
                throw ex;
            }
        }
    }

    private void updateConnectionHeartBeat() {
        boolean update;
        if (!this.isConnectionHeartBeatEnabled) {
            return;
        }
        boolean bl = update = this.lastconnhbtime > 0L;
        if (update) {
            if (System.currentTimeMillis() - this.lastconnhbtime < this.getIgnoreHBPeriod()) {
                return;
            }
            long prevvalue = this.lastconnhbtime + this.connmaxidletime;
            this.lastconnhbtime = System.currentTimeMillis();
            TCPConnectionHeartBeatMonitor.TRACKER.update(prevvalue, this.lastconnhbtime + this.connmaxidletime, this);
        } else {
            this.lastconnhbtime = System.currentTimeMillis();
            TCPConnectionHeartBeatMonitor.TRACKER.touch(this.lastconnhbtime + this.connmaxidletime, this);
        }
    }

    private void removeFromConnectionHeartBeatTracker() {
        if (!this.isConnectionHeartBeatEnabled) {
            return;
        }
        TCPConnectionHeartBeatMonitor.TRACKER.remove(this.lastconnhbtime + this.connmaxidletime, this);
    }

    protected void incrementConnectRetry() {
        ++this.connectretrycount;
    }

    public void setConnectRetryMaxCount(int maxcount) {
        this.connectretryMaxCount = maxcount;
    }

    public int getConnectRetryCount() {
        return this.connectretrycount;
    }

    public long getInitConnectTime() {
        return this.initConnectTime;
    }

    protected boolean isConnectRetryLimitExceeded() {
        return this.connectretrycount > this.connectretryMaxCount;
    }

    protected boolean isHighPriority() {
        return this.highpriority;
    }

    public void setConnectionHeartBeatMonitor(long time) {
        this.isConnectionHeartBeatEnabled = true;
        this.setConnectionHeartBeatMonitor(time, 30000L, 1000L);
    }

    public void setConnectionHeartBeatMonitor(long time, long interval, long ignorehb) {
        this.isConnectionHeartBeatEnabled = true;
        this.connmaxidletime = time;
        this.ignorehbperiod = ignorehb;
        TCPConnectionHeartBeatMonitor.TRACKER.setConnectionTrackerInterval(interval);
    }

    public long getIgnoreHBPeriod() {
        return this.ignorehbperiod;
    }

    public boolean isInvalidHeartBeatTimeoutEntry(long time) {
        return this.lastconnhbtime + this.connmaxidletime != time;
    }

    public long getMaxAllowedHeartBeatTime() {
        return this.lastconnhbtime + this.connmaxidletime;
    }

    public void close() {
        try {
            if (this.ssl != null) {
                this.ssl.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        AbstractInterruptibleChannel ch = null;
        if (this.key != null) {
            try {
                ch = (SocketChannel)this.key.channel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.key.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (ch.isOpen()) {
                ch.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.writeBB = null;
        this.statReports.put("closetime", System.currentTimeMillis());
        this.onClose();
    }

    public HashMap getReports(boolean humanReadable) {
        if (this.isSSL()) {
            this.byteswritten += this.ssl.byteswritten();
            this.statReports.put("lastwrittentime", this.ssl.getLastWrittenTime());
        }
        this.statReports.put("byteswritten", this.byteswritten);
        LinkedHashMap humanReadableStats = new LinkedHashMap();
        if (humanReadable) {
            for (Map.Entry pair : this.statReports.entrySet()) {
                if (pair.getKey() == "bytesread" || pair.getKey() == "byteswritten" || pair.getKey() == "readtime" || pair.getKey() == "writetime" || pair.getKey() == "handshaketime") {
                    humanReadableStats.put(pair.getKey(), pair.getValue());
                    continue;
                }
                humanReadableStats.put(pair.getKey(), new Date(Long.parseLong(pair.getValue().toString())));
            }
            return humanReadableStats;
        }
        return this.statReports;
    }

    public abstract void onConnect();

    public abstract void onConnectFailure(long var1);

    public abstract void onDisconnect(int var1);

    public abstract void onHandshake();

    public abstract void onData(byte[] var1);

    public abstract void onClose();

    public boolean isValid() {
        return true;
    }

    public void onSSLExceptions(int code, String msg) {
    }

    public void setServerName(String sniServerName) {
        if (this.serverName == null) {
            this.serverName = sniServerName;
        }
    }

    public String getServerName() {
        return this.serverName;
    }
}

