/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.tcp;

import com.adventnet.wms.nioclient.exception.NIOSSLCertificateException;
import com.adventnet.wms.nioclient.tcp.ConnectTimeOutListener;
import com.adventnet.wms.nioclient.tcp.NetDataProcessor;
import com.adventnet.wms.nioclient.tcp.PacketAssembler;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NioSelector
extends Thread {
    private static Logger logger = Logger.getLogger(NioSelector.class.getName());
    private Vector channelRegVector = new Vector();
    private Vector writeModeKeysVector = new Vector();
    private Selector selector;
    private int selecttimeout;

    public NioSelector(int selecttimeout) throws Exception {
        this.selecttimeout = selecttimeout;
        this.selector = Selector.open();
    }

    public void connect(String host, int port, PacketAssembler pasm, int sendbuffersize, long connecttimeout) throws Exception {
        SocketChannel sc = SocketChannel.open();
        if (sendbuffersize != -1) {
            sc.socket().setSendBufferSize(sendbuffersize);
        }
        sc.configureBlocking(false);
        InetAddress iadd = InetAddress.getByName(host);
        sc.connect(new InetSocketAddress(iadd, port));
        pasm.setServerName(host);
        pasm.setSocketChannel(sc);
        pasm.setConnectExpireTime(System.currentTimeMillis() + connecttimeout);
        this.register(sc, pasm);
    }

    private void register(SocketChannel sc, PacketAssembler pasm) {
        Object[] channelIdArr = new Object[]{sc, pasm};
        this.channelRegVector.add(channelIdArr);
    }

    private void registerSocketChannels() {
        if (this.channelRegVector == null) {
            return;
        }
        for (int i = 0; i < this.channelRegVector.size(); ++i) {
            Object[] channelSesIdArr = new Object[2];
            channelSesIdArr = (Object[])this.channelRegVector.firstElement();
            this.channelRegVector.removeElement(channelSesIdArr);
            if (channelSesIdArr == null || channelSesIdArr.length != 2) continue;
            SocketChannel sc = (SocketChannel)channelSesIdArr[0];
            PacketAssembler pasm = (PacketAssembler)channelSesIdArr[1];
            SelectionKey key = null;
            try {
                if (pasm == null) continue;
                if (sc.isConnected() && sc.finishConnect()) {
                    if (pasm.isSSL()) {
                        if (pasm.isHSDone()) continue;
                        key = sc.register(this.selector, 5);
                        key.attach(pasm);
                        pasm.setSelectionKey(key);
                        boolean bl = pasm.doHandshake(key);
                        continue;
                    }
                    key = sc.register(this.selector, 1);
                    key.attach(pasm);
                    pasm.setSelectionKey(key);
                    pasm.onConnect();
                    continue;
                }
                key = sc.register(this.selector, 8);
                key.attach(pasm);
                pasm.setSelectionKey(key);
                pasm.incrementConnectRetry();
                ConnectTimeOutListener.TRACKER.touch(pasm.getConnectExpireTime(), key);
                continue;
            }
            catch (ConnectException ce) {
                logger.log(Level.INFO, "Exception ", ce);
                if (!ce.getMessage().contains("Connection refused")) continue;
                try {
                    sc.close();
                    if (pasm == null) continue;
                    this.processRetry(pasm);
                }
                catch (Exception cee) {
                    logger.log(Level.INFO, "Exception ", cee);
                }
                continue;
            }
            catch (NIOSSLCertificateException excep) {
                if (key == null) continue;
                SocketChannel ch = null;
                try {
                    ch = (SocketChannel)key.channel();
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "EXCEPTION IN SOCKET CHANNEL TYPECAST ", ex);
                }
                try {
                    key.cancel();
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "EXCEPTION IN KEY CANCEL ", ex);
                }
                try {
                    if (ch.isOpen()) {
                        ch.close();
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "EXCEPTION IN SOCKET CHANNEL CLOSE ", ex);
                }
                key.attach(null);
                return;
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Exception ", e);
            }
        }
    }

    public void setWriteModeForKey(SocketChannel sc) {
        this.writeModeKeysVector.add(sc);
    }

    private void registerWriteMode() {
        try {
            if (this.writeModeKeysVector == null || this.writeModeKeysVector.size() == 0) {
                return;
            }
            Enumeration en = this.writeModeKeysVector.elements();
            while (en.hasMoreElements()) {
                SocketChannel sc = (SocketChannel)en.nextElement();
                try {
                    SelectionKey key = sc.keyFor(this.selector);
                    key.interestOps(5);
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Exception ", ex);
                }
                try {
                    this.writeModeKeysVector.remove(sc);
                }
                catch (Exception exp) {
                    logger.log(Level.INFO, "Exception ", exp);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception ", e);
        }
    }

    @Override
    public void run() {
        block12: while (true) {
            this.registerSocketChannels();
            this.registerWriteMode();
            int count = 1;
            try {
                int i = this.selector.select(this.selecttimeout);
                if (++count % 250 == 0) {
                    try {
                        Thread.sleep(1L);
                        count = 0;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                while (true) {
                    if (!it.hasNext()) continue block12;
                    SelectionKey key = it.next();
                    it.remove();
                    try {
                        this.handleKey(key);
                    }
                    catch (Exception e) {
                        if (key == null) continue;
                        SocketChannel sc = null;
                        try {
                            sc = (SocketChannel)key.channel();
                        }
                        catch (Exception ex) {
                            logger.log(Level.INFO, "EXCEPTION IN SOCKET CHANNEL TYPECAST ", ex);
                        }
                        try {
                            key.cancel();
                        }
                        catch (Exception ex) {
                            logger.log(Level.INFO, "EXCEPTION IN KEY CANCEL ", ex);
                        }
                        try {
                            if (sc.isOpen()) {
                                sc.close();
                            }
                        }
                        catch (Exception ex) {
                            logger.log(Level.INFO, "EXCEPTION IN SOCKET CHANNEL CLOSE ", ex);
                        }
                        key.attach(null);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Exception ", e);
                continue;
            }
            break;
        }
    }

    private void handleKey(SelectionKey key) {
        block10: {
            try {
                int readyops = key.readyOps();
                if (readyops == 0) {
                    return;
                }
                key.interestOps(0);
                NetDataProcessor.process(key, readyops);
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Exception ", e);
                if (key == null) break block10;
                this.processDisconnect((PacketAssembler)key.attachment());
                SocketChannel sc = null;
                try {
                    sc = (SocketChannel)key.channel();
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "EXCEPTION IN SOCKET CHANNEL TYPECAST ", ex);
                }
                try {
                    key.cancel();
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "EXCEPTION IN KEY CANCEL ", ex);
                }
                try {
                    if (sc.isOpen()) {
                        sc.close();
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "EXCEPTION IN SOCKET CHANNEL CLOSE ", ex);
                }
                key.attach(null);
            }
        }
    }

    private void processDisconnect(PacketAssembler pasm) {
        try {
            pasm.onDisconnect(-1);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception ", e);
        }
    }

    private void processRetry(PacketAssembler pasm) {
        try {
            pasm.onDisconnect(-2);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception ", e);
        }
    }
}

