/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.tcp;

import com.adventnet.wms.nioclient.VariableTimeOutListener;
import com.adventnet.wms.nioclient.tcp.PacketAssembler;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectTimeOutListener
extends VariableTimeOutListener {
    private static Logger logger = Logger.getLogger(ConnectTimeOutListener.class.getName());
    private static long timerinterval = 10000L;
    public static final ConnectTimeOutListener TRACKER = new ConnectTimeOutListener(timerinterval);

    private ConnectTimeOutListener(long timerinterval) {
        super("ConnectTimeOutListener ", timerinterval);
    }

    @Override
    public boolean isExpired(Object obj) {
        try {
            PacketAssembler pasm = (PacketAssembler)((SelectionKey)obj).attachment();
            return pasm.isConnectExpired();
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Override
    public boolean isInvalidEntry(Object obj, long time) {
        try {
            PacketAssembler pasm = (PacketAssembler)((SelectionKey)obj).attachment();
            return pasm.isInvalidConnectExpireTime(time);
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Override
    public void handleExpired(ArrayList list) {
        logger.info("Expired Connect list : " + list.size());
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            try {
                SelectionKey key = (SelectionKey)itr.next();
                PacketAssembler pasm = (PacketAssembler)key.attachment();
                pasm.onConnectFailure(System.currentTimeMillis() - pasm.getInitConnectTime());
                if (key == null) continue;
                SocketChannel ch = null;
                try {
                    ch = (SocketChannel)key.channel();
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "CHANNEL TYPE CAST EXPCEPTION ", ex);
                }
                try {
                    key.cancel();
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "EXCEPTION IN KEY CANCEL ", ex);
                }
                try {
                    if (ch.isOpen()) {
                        ch.close();
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "EXCEPTION IN CHANNEL CLOSE ", ex);
                }
                key.attach(null);
            }
            catch (Exception ex) {
                logger.info("CONNECT TIMEOUT LISTENER ERROR : " + ex);
            }
        }
    }

    public static void setTimerInterval(long interval) {
        timerinterval = interval;
    }
}

