/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.rtsp;

import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RTSPUtil {
    public static Logger logger = Logger.getLogger(RTSPUtil.class.getName());

    public static String getDigest(String username, String password, String realm, String method, String uri, String nonce) {
        try {
            String ha1 = RTSPUtil.hash(username + ":" + realm + ":" + password);
            String ha2 = RTSPUtil.hash(method + ":" + uri);
            String ha3 = RTSPUtil.hash(ha1 + ":" + nonce + ":" + ha2);
            return ha3;
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Exception on creating digest : ", ex);
            return null;
        }
    }

    public static String byteToHexString(byte[] input) {
        String output = "";
        for (int i = 0; i < input.length; ++i) {
            output = output + String.format("%02X", input[i]);
        }
        return output.toLowerCase();
    }

    public static String hash(String value) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return RTSPUtil.byteToHexString(md.digest(value.getBytes("UTF-8")));
        }
        catch (Exception e) {
            return null;
        }
    }
}

