/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.rtsp;

import com.adventnet.wms.nioclient.rtsp.KeyValueProp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class RTSPRequest {
    private static Logger logger = Logger.getLogger(RTSPRequest.class.getName());
    protected String uri = null;
    private String reqType = null;
    private byte[] body = null;
    private ByteArrayOutputStream headerbaos = new ByteArrayOutputStream();
    private ByteArrayOutputStream bodybaos = null;
    private ByteBuffer headerboas;
    private HashMap headerMap = null;
    private HashMap paramMap = null;
    private static final String NEWLINE = "\r\n";
    private StringBuffer paramBuffer = new StringBuffer();
    private int inputdatasize = 1024;
    private String version;

    public RTSPRequest(String uri) throws Exception {
        this(uri, null, null, null);
    }

    public RTSPRequest(String uri, String reqType) throws Exception {
        this(uri, reqType, null, null);
    }

    public RTSPRequest(String uri, String reqType, HashMap headerMap) throws Exception {
        this(uri, reqType, headerMap, null);
    }

    public RTSPRequest(String uri, String reqType, HashMap headerMap, byte[] body) throws Exception {
        this.uri = uri;
        this.reqType = reqType;
        this.headerMap = headerMap;
        this.body = body;
        this.headerMap = new HashMap();
        this.initializeDefaultHeader();
    }

    public RTSPRequest() throws Exception {
        this(null, null, new HashMap(), null);
    }

    public void setType(String type) {
        this.reqType = type;
    }

    public String getType() {
        return this.reqType;
    }

    public void setURI(String reqUri) {
        if (!reqUri.startsWith("/")) {
            reqUri = "/" + reqUri;
        }
        this.uri = reqUri;
    }

    public String getURI() {
        return this.uri + File.separator + this.paramBuffer;
    }

    public void setBody(String data) throws IOException {
        if (this.bodybaos == null) {
            this.bodybaos = new ByteArrayOutputStream();
        }
        if (data != null && !data.equals("")) {
            this.bodybaos.write(data.getBytes("UTF-8"));
            this.inputdatasize += this.bodybaos.toByteArray().length;
        }
    }

    public void setBody(byte[] data) throws IOException {
        if (this.bodybaos == null) {
            this.bodybaos = new ByteArrayOutputStream();
        }
        if (data != null && data.length > 0) {
            this.bodybaos.write(data);
            this.inputdatasize += this.bodybaos.toByteArray().length;
        }
    }

    public void parseBody(byte[] data) {
        try {
            if (this.isGZIPEncoded()) {
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                GZIPInputStream stream = new GZIPInputStream(bais);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] arr = new byte[1024];
                int c = -1;
                while ((c = stream.read(arr)) != -1) {
                    baos.write(arr, 0, c);
                }
                this.body = baos.toByteArray();
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Exception in setBody : ", ex);
        }
    }

    public ByteBuffer getBody() {
        if (this.bodybaos != null) {
            return ByteBuffer.wrap(this.bodybaos.toByteArray());
        }
        return null;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    private void initializeDefaultHeader() {
        try {
            this.addHeader("User-agent", "Java", false);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception while intializeDefaultParams : ", e);
        }
    }

    public void addHeader(ArrayList headerList) {
        for (int i = 0; i < headerList.size(); ++i) {
            try {
                KeyValueProp param = (KeyValueProp)headerList.get(i);
                this.addHeader(param.getName(), param.getValue(), false);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Exception in add header : ", e);
            }
        }
    }

    public void addHeader(String header, String value) throws IOException {
        this.addHeader(header, value, false);
    }

    public void addHeader(String header, String value, boolean encode) throws IOException {
        String currentValue = this.getHeader(header);
        if (currentValue == null) {
            if (encode) {
                value = URLEncoder.encode(value, "UTF-8");
            }
            this.headerMap.put(header, value);
            this.headerbaos.write((header + ": " + value + NEWLINE).getBytes("UTF-8"));
            return;
        }
        logger.log(Level.INFO, "RTSPRequest -> {0} header already present with value {1}", new Object[]{header, currentValue});
    }

    public String getHeader(String key) {
        try {
            return (String)this.headerMap.get(key.toLowerCase());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getCSeq() {
        return Integer.parseInt(this.getHeader("CSeq"));
    }

    public void parseHeader(String header, String value) {
        this.headerMap.put(header, value);
    }

    public ByteBuffer getHeaderInfo() {
        return ByteBuffer.wrap(this.headerbaos.toByteArray());
    }

    public void addParam(String param, String value) throws IOException {
        this.addParam(param, value, true);
    }

    public void addParam(String param, String value, boolean encode) throws IOException {
        if (encode) {
            value = URLEncoder.encode(value, "UTF-8");
        }
        if (this.paramMap.size() > 0 && this.paramBuffer.length() > 0) {
            this.paramBuffer.append("&");
        }
        this.paramMap.put(param, value);
        this.paramBuffer.append(param + "=" + value);
    }

    public boolean isGZIPEncoded() {
        return this.headerMap.get("content-encoding") != null && ((String)this.headerMap.get("content-encoding")).toLowerCase().equals("gzip");
    }

    public int getInputDataSize() {
        return this.inputdatasize + this.paramBuffer.length() + this.uri.length();
    }

    public String toString() {
        return "RTSPRequest Info : URI " + this.uri + " TYPE " + this.reqType + " PARAM " + this.paramMap + " HEADER " + this.headerMap;
    }
}

