/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.rtsp;

import com.adventnet.wms.nioclient.rtsp.EventDispatcher;
import com.adventnet.wms.nioclient.rtsp.RTSPAgent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetworkEventProcessor {
    private static LinkedBlockingQueue queue = new LinkedBlockingQueue();
    private static ThreadPoolExecutor executor;
    private static boolean initialized;
    private static Logger logger;

    public static synchronized void initialize(int threadCount) {
        if (initialized) {
            return;
        }
        executor = new ThreadPoolExecutor(threadCount, threadCount, 100L, TimeUnit.MILLISECONDS, queue);
        initialized = true;
    }

    public static void process(RTSPAgent agent, int eventcode) {
        if (!initialized) {
            NetworkEventProcessor.initialize(2);
        }
        executor.execute(new AgentNetworkEventProcessor(agent, eventcode));
    }

    public static List<Runnable> shutdown() {
        List<Runnable> list = new ArrayList<Runnable>();
        try {
            if (executor == null) {
                initialized = false;
                return list;
            }
            list = executor.shutdownNow();
            executor = null;
            initialized = false;
            return list;
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in networkevent processor shutdown ", e);
            return null;
        }
    }

    static {
        initialized = false;
        logger = Logger.getLogger(NetworkEventProcessor.class.getName());
    }

    static class AgentNetworkEventProcessor
    implements Runnable {
        private RTSPAgent agent;
        private int eventcode;

        public AgentNetworkEventProcessor(RTSPAgent agent, int eventcode) {
            this.agent = agent;
            this.eventcode = eventcode;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                switch (this.eventcode) {
                    case 1: {
                        try {
                            EventDispatcher.process(this.agent, 1);
                            return;
                        }
                        catch (Exception ex) {
                            logger.log(Level.INFO, "Exception in AgentNetworkEventProcessor : ", ex);
                            if (this.agent.isClosed()) return;
                            try {
                                this.agent.close();
                                return;
                            }
                            catch (Exception exception) {}
                        }
                        return;
                    }
                    case -5: {
                        if (this.agent.isClosed()) return;
                        try {
                            this.agent.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        EventDispatcher.process(this.agent, -5);
                    }
                }
                return;
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Exception in AgentNetworkEventProcessor ", ex);
            }
        }
    }
}

