/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.rtsp;

import com.adventnet.wms.nioclient.rtsp.RTSPAgent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventDispatcher {
    private static Logger logger = Logger.getLogger(EventDispatcher.class.getName());
    private static LinkedBlockingQueue queue = new LinkedBlockingQueue();
    private static ThreadPoolExecutor executor;
    private static boolean initialized;

    public static synchronized void initialize(int threadCount) {
        if (initialized) {
            return;
        }
        executor = new ThreadPoolExecutor(threadCount, threadCount, 100L, TimeUnit.MILLISECONDS, queue);
        initialized = true;
    }

    public static void process(RTSPAgent agent, int eventcode) {
        if (!initialized) {
            EventDispatcher.initialize(2);
        }
        executor.execute(new AgentEventDispatcher(agent, eventcode));
    }

    public static void process(RTSPAgent agent, int eventcode, int instanceId) {
        if (!initialized) {
            EventDispatcher.initialize(2);
        }
        executor.execute(new AgentEventDispatcher(agent, eventcode, instanceId));
    }

    public static List<Runnable> shutdown() {
        List<Runnable> list = new ArrayList<Runnable>();
        try {
            if (executor == null) {
                initialized = false;
                return list;
            }
            list = executor.shutdownNow();
            executor = null;
            initialized = false;
            return list;
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in eventdispatcher shutdown ", e);
            return null;
        }
    }

    static {
        initialized = false;
    }

    static class AgentEventDispatcher
    implements Runnable {
        private RTSPAgent agent;
        private int eventcode;
        private int instanceId = -1;

        public AgentEventDispatcher(RTSPAgent agent, int eventcode) {
            this.agent = agent;
            this.eventcode = eventcode;
        }

        public AgentEventDispatcher(RTSPAgent agent, int eventcode, int instanceId) {
            this.agent = agent;
            this.eventcode = eventcode;
            this.instanceId = instanceId;
        }

        @Override
        public void run() {
            try {
                this.agent.notifyListener(this.eventcode, this.instanceId);
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Exception in EventDispatcher : ", ex);
            }
        }
    }
}

