/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.http;

import com.adventnet.wms.nioclient.http.SelectorPool;
import com.adventnet.wms.nioclient.http.SelectorPoolImpl;
import java.io.IOException;
import java.util.HashMap;

public class SelectorPoolFactory {
    private static SelectorPoolFactory spool;
    private static HashMap selectorPoolMap;
    private static HashMap highpriorityselectorPoolMap;

    public static SelectorPool getInstance(int port) {
        if (selectorPoolMap.containsKey("" + port)) {
            return (SelectorPool)selectorPoolMap.get(port + "");
        }
        return null;
    }

    public static SelectorPool getHighPriorityInstance(int port) {
        if (highpriorityselectorPoolMap.containsKey("" + port)) {
            return (SelectorPool)highpriorityselectorPoolMap.get("" + port);
        }
        return null;
    }

    public static void init(int port, int count) throws IOException {
        SelectorPoolFactory.init(port, count, -1);
    }

    public static void init(int port, int count, int highprioritycount) throws IOException {
        SelectorPoolFactory.init(port, count, highprioritycount, 100);
    }

    public static void init(int port, int count, int highprioritycount, int timeout) throws IOException {
        SelectorPoolImpl httppool = new SelectorPoolImpl(count, timeout);
        ((SelectorPool)httppool).init();
        selectorPoolMap.put("" + port, httppool);
        if (highprioritycount != -1) {
            SelectorPoolImpl highpriorityhttppool = new SelectorPoolImpl(highprioritycount);
            ((SelectorPool)highpriorityhttppool).init();
            highpriorityselectorPoolMap.put("" + port, highpriorityhttppool);
        }
    }

    static {
        selectorPoolMap = new HashMap();
        highpriorityselectorPoolMap = new HashMap();
    }
}

