/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.http;

import com.adventnet.wms.nioclient.http.Multipart;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Part {
    private static Logger logger = Logger.getLogger(Part.class.getName());
    private String charset = "ISO-8859-1";
    private byte[] rawContent;
    private byte[] rawData;
    private Hashtable<String, String> paramMap = new Hashtable();
    private Hashtable<String, String> headers = new Hashtable();
    private byte[] crlf = "\r\n".getBytes();
    private byte[] body;
    private LinkedHashMap mimeheaders;
    private Multipart multipart;
    private String type = "";
    private String nameField;
    private String filename;
    public static final String FORM_DATA = "form-data";

    public Part(byte[] body) {
        this(null, body);
    }

    public Part(LinkedHashMap mimeheaders, byte[] body) {
        this.mimeheaders = mimeheaders;
        this.body = body;
    }

    public Part(Multipart part) {
        this.multipart = part;
    }

    Part(String content, String charset) throws Exception {
        this(content.getBytes(charset), charset);
    }

    Part(byte[] content, String charset) {
        try {
            this.charset = charset;
            this.rawContent = content;
            String contentData = new String(content, charset);
            int splitIndex = contentData.indexOf("\r\n\r\n");
            String namePart = contentData.substring(0, splitIndex);
            String contentPart = contentData.substring(splitIndex + 4, contentData.length() - 2);
            this.setNameHeaders(namePart);
            this.setValue(contentPart);
        }
        catch (Exception ex) {
            logger.log(Level.INFO, " Exception ", ex);
        }
    }

    private void setNameHeaders(String namePart) {
        if (namePart == null) {
            return;
        }
        String[] headerArray = namePart.trim().split("\r\n");
        for (int i = 0; i < headerArray.length; ++i) {
            String[] keyValue = headerArray[i].split(":");
            if (keyValue.length == 2) {
                String key = keyValue[0].trim().toLowerCase();
                String value = keyValue[1].trim();
                if (key.equals("content-disposition")) {
                    this.setParameter(value);
                }
                this.headers.put(key, value);
                continue;
            }
            logger.log(Level.INFO, "Undefined MIME header : {0}", new Object[]{headerArray[i]});
        }
    }

    private void setParameter(String content) {
        String[] parameter = content.split(";");
        for (int i = 1; i < parameter.length; ++i) {
            String[] keyValue = parameter[i].split("=");
            try {
                if (keyValue.length == 2) {
                    this.paramMap.put(keyValue[0].trim(), URLDecoder.decode(keyValue[1].trim().replace("\"", ""), this.charset));
                    continue;
                }
                logger.log(Level.INFO, "Undefined MIME param : {0}", new Object[]{parameter[i]});
                continue;
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "MIME Parameter URL Decoding Exception ", ex);
            }
        }
    }

    private void setValue(String contentPart) throws Exception {
        block6: {
            this.rawData = contentPart.getBytes(this.charset);
            try {
                String contentType = this.getHeader("content-type");
                if (contentType == null || !contentType.toLowerCase().startsWith("multipart")) break block6;
                String boundary = this.getHeaderParameter(contentType, "boundary");
                String charset = this.getHeaderParameter(contentType, "charset");
                if (boundary == null) {
                    throw new IOException("Invalid inner MIME header " + contentType);
                }
                if (charset == null) {
                    charset = "ISO-8859-1";
                }
                this.multipart = new Multipart(contentType, boundary, charset);
                String[] parts = new String(this.rawData, charset).trim().split("--" + boundary);
                for (int i = 1; i < parts.length - 1; ++i) {
                    Part part = new Part(parts[i], charset);
                    this.multipart.addPart(part);
                }
                this.multipart.setPreambleContent(parts[0].replace("\r\n", ""));
                if (parts[parts.length - 1].equals("--")) break block6;
                if (parts[parts.length - 1].startsWith("--")) {
                    this.multipart.setEpilogueContent(parts[parts.length - 1].replace("--\r\n", ""));
                    break block6;
                }
                throw new IOException("Invalid inner MIME content closure :" + parts[parts.length - 1]);
            }
            catch (Exception ex) {
                logger.log(Level.INFO, " Exception ", ex);
            }
        }
    }

    private String getHeaderParameter(String headerValue, String parameter) {
        String[] parameters = headerValue.split(";");
        for (int i = 1; i < parameters.length; ++i) {
            if (!parameters[i].contains(parameter)) continue;
            String[] keyValue = parameters[i].split("=");
            if (keyValue.length == 2) {
                return keyValue[1].trim().replace("\"", "");
            }
            logger.log(Level.INFO, "UNDEFINED HEADER PARAM : ", new Object[]{parameters[i]});
        }
        return null;
    }

    public Hashtable getHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        return this.headers.get(name.toLowerCase());
    }

    public String getName() {
        return this.paramMap.get("name");
    }

    public String getFileName() {
        return this.paramMap.get("filename");
    }

    public String getContentType() {
        String contentType = this.headers.get("content-type");
        if (contentType != null) {
            return contentType;
        }
        return "text/plain";
    }

    public String getValue() throws Exception {
        return new String(this.rawData, this.charset);
    }

    public byte[] getRawData() {
        return this.rawData;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.rawData);
    }

    public void write(String path) {
        try {
            File file = new File(path);
            FileOutputStream fos = new FileOutputStream(file);
            InputStream is = this.getInputStream();
            try {
                byte[] b = new byte[100];
                int i = 0;
                while ((i = is.read(b)) > 0) {
                    fos.write(b, 0, i);
                    fos.flush();
                    i = 0;
                }
            }
            catch (Exception exe) {
                throw exe;
            }
            finally {
                is.close();
                fos.close();
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, " Exception ", ex);
        }
    }

    public byte[] getRawContent() {
        return this.rawContent;
    }

    public Multipart getMultipart() {
        return this.multipart;
    }

    public String toString() {
        return "Params : " + this.paramMap + ", contentType: " + this.getContentType() + ", value: " + this.rawData.length + ", Has InnerParts: " + (this.multipart != null) + ", headers : " + this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] frameMultipart() throws Exception {
        if (this.body == null || this.body.length == 0) {
            throw new Exception("Multipart body should not be null");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (this.type.equals(FORM_DATA)) {
                if (this.nameField == null) {
                    throw new Exception("For formdata, name param is mandatory");
                }
                baos.write(("Content-Disposition: form-data; name=\"" + this.nameField + "\"").getBytes());
                if (this.filename != null) {
                    baos.write(("; filename=\"" + this.filename + "\"").getBytes());
                }
                baos.write(this.crlf);
            }
            if (this.mimeheaders != null && this.mimeheaders.size() > 0) {
                for (String key : this.mimeheaders.keySet()) {
                    baos.write((key + ": " + this.mimeheaders.get(key)).getBytes());
                    baos.write(this.crlf);
                }
            }
            baos.write(this.crlf);
            baos.write(this.body);
            baos.write(this.crlf);
            Object iterator = baos.toByteArray();
            return iterator;
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Exception in frameMultipart : ", ex);
        }
        finally {
            try {
                baos.close();
            }
            catch (Exception exception) {}
        }
        return new byte[0];
    }

    byte[] getData() throws Exception {
        if (this.multipart != null) {
            this.multipart.processMultipart(true);
            return this.multipart.getData();
        }
        return this.frameMultipart();
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.nameField = name;
    }

    public void setFileName(String filename) {
        this.filename = filename;
    }

    public void setFormData(String type, String name) {
        this.setFormData(type, name, null);
    }

    public void setFormData(String type, String name, String filename) {
        this.type = type;
        this.nameField = name;
        this.filename = filename;
    }

    boolean isFormData() {
        return this.type.equals(FORM_DATA) || this.multipart != null;
    }
}

