/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.http;

import com.adventnet.wms.nioclient.VariableTimeOutListener;
import com.adventnet.wms.nioclient.http.ConnectionManager;
import com.adventnet.wms.nioclient.http.HttpKeepaliveConnection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KeepaliveTimeOutListener
extends VariableTimeOutListener {
    private static Logger logger = Logger.getLogger(KeepaliveTimeOutListener.class.getName());
    public static final KeepaliveTimeOutListener TRACKER = new KeepaliveTimeOutListener();

    private KeepaliveTimeOutListener() {
        super("KeepaliveTimeOutListener", 10000L);
    }

    @Override
    public boolean isExpired(Object obj) {
        try {
            if (obj instanceof HttpKeepaliveConnection) {
                return ConnectionManager.isExpired((HttpKeepaliveConnection)obj);
            }
            if (obj instanceof Hashtable) {
                return ConnectionManager.isExpired((Hashtable)obj);
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in isExpired : ", e);
        }
        return false;
    }

    @Override
    public boolean isInvalidEntry(Object obj, long time) {
        return false;
    }

    @Override
    public void handleExpired(ArrayList list) {
        logger.log(Level.INFO, "[keepalive TimeOut Listener] Expired list Size : {0}", new Object[]{list.size()});
        try {
            for (Object obj : list) {
                if (obj instanceof HttpKeepaliveConnection) {
                    ConnectionManager.handleExpired((HttpKeepaliveConnection)obj);
                }
                if (!(obj instanceof Hashtable)) continue;
                ConnectionManager.handleExpired((Hashtable)obj);
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in handle Expired : ", e);
        }
    }
}

